;- #########################################################################################
;  ##                                                                                     ##
;  ##                                  GRAVITATION  3.4                                   ##
;  ##                            Copyright  Dr. Arnim Wegner                             ##
;  ##                                                                                     ##
;  #########################################################################################
;
;  Dieses Programm ist freie Software; Sie knnen es unter den Bedingungen der GNU General
;  Public License, wie von der Free Software Foundation verffentlicht, weitergeben und/oder
;  modifizieren, entweder gem Version 2 der Lizenz oder (nach Ihrer Option) jeder spteren
;  Version. Die Verffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen von
;  Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite Garantie der
;  MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der
;  GNU General Public License. Sie sollten eine Kopie der GNU General Public License zusam-
;  men mit diesem Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA oder an die
;  Free Software Foundation Europe e.V., Villa Vogelsang, Antonienallee 1, 45279 Essen.
;
;  This program is free software; you can redistribute it and/or modify it under the terms
;  of the GNU General Public License as published by the Free Software Foundation; either
;  version 2 of the License, or (at your option) any later version. This program is
;  distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
;  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;  GNU General Public License for more details. You should have received a copy of the GNU
;  General Public License along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1307 USA, or to the Free
;  Software Foundation Europe e.V., Villa Vogelsang, Antonienallee 1, 45279 Essen, Germany.
;
;  #########################################################################################
;  ##                                                                                     ##
;  ##                       Quelltext geschrieben und kompiliert mit                      ##
;  ##                    PureBasic 4.20  Copyright  Fantaisie Software                   ##
;  ##                                                                                     ##
;  #########################################################################################
;
;- INITIALISIERUNG
;- Deklarationen
; Konfiguration
Declare Konfiguration()
Declare Instanztest(win)
Declare Speicherinfo()
Declare DatenSpeichern()
Declare DatenLaden(typ)
Declare ConfigSpeichern(typ)
Declare ConfigLaden(dat$,typ)
Declare ConfigUebernehmen()
Declare Schreibschutz(typ)
Declare ZustandSpeichern()
Declare ZustandLaden()
Declare StartdateiAusw()
Declare StartdateiErzg()
Declare Zeit()
Declare Reset(typ)
Declare Programmende()
; Fenster:
Declare FensterAuf()
; Steuerung:
Declare InitMenuGadget()
Declare CtrlMenuGadget()
Declare EinstGadget(typ,txt1$,txt2$)
; Eingabe:
Declare Eingeben(typ)
Declare Entfernen(typ,del)
Declare Zustand(typ,k)
Declare Zuordnen(n,m)
; Bahnrechnung:
Declare.l BahnrechnungA(typ)
Declare BahnrechnungB(richt)
Declare GeschwLP(k1,k2)
Declare Lagrangepunkte(k1,k2)
Declare Schwerpunkt()
Declare Kreisbahn(k)
Declare.l Hohmann(k)
Declare ZusatzkraftEA(typ)
Declare Erdfeld(typ)
; Kollision:
Declare Kollisionsmatrix()
Declare.l Kollisionstest(xx.d,yy.d,zz.d,k,m)
Declare Kollisionsreaktion(k1,k2)
Declare StossEA()
Declare ReduzierungEA(typ)
; Bild:
Declare.l Bildweite()
Declare.l Bildhoehe()
Declare.l Bildtiefe()
Declare Geometrie(typ)
Declare BildEA(typ)
Declare.l ScrTimeOut()
Declare SpriteErzeugen()
Declare SpriteKoerper(n,r,f,m=#PB_2DDrawing_Default)
Declare SpritePunkt(n,f)
Declare BildAnzeigen(typ,rkn)
Declare Zeichnen(bhn,fhr,shw,lgg,rkn)
Declare Rekonstruieren(typ)
Declare RekonstruierenW()
Declare Achsen()
Declare Namen(krp,spk,lag)
Declare Geschwindigkeit()
Declare Text(txt$,xloc,yloc.d,m=#PB_2DDrawing_Transparent)
Declare BildSpeichern(typ)
Declare BildOeffnen()
Declare BildDrucken(typ)
; Darstellung:
Declare ParameterEin(typ)
Declare ParameterAus(typ)
Declare.d Voreinstellung(typ)
Declare Zeitschritt(typ)
Declare BezugBild(typ)
Declare BildBrt(typ)
Declare Erdoberflaeche(typ)
Declare BahnenEA()
Declare GeschwindigkeitEA()
Declare FahrstrahlEA()
Declare AchsenEA()
Declare SchwerpunktEA()
Declare LagrangeEA(k1,k2,mn)
Declare ZeitEA()
Declare ZeitschrittEA()
Declare BildbreiteEA()
Declare NamenEA()
Declare NamenLagrEA()
Declare NamenAbbEA()
Declare Blickrichtung(typ)
Declare Zoom(zoo.d)
Declare Spritegroesse(typ)
Declare Farbwahl(typ)
Declare Radiuswahl(typ)
Declare DruckgeometrieEA()
Declare BahnWeg()
Declare SynchronisationEA()
Declare LokalEA()
; Info-Hilfe:
Declare Info()
Declare InfoL(txt$)
Declare InfoM(txt$,typ)
Declare InfoMo(txt$)
Declare InfoR(txt$)
Declare InfoHilfe(typ)
Declare HilfeBild()
; Sonstige Funktionen:
Declare.l Btst(i,xxx)
Declare.l BtstI(i,j,xxx)
Declare.l Bset(i,xxx)
Declare.l Bclr(i,xxx)
Declare.l Bchg(i,xxx)
Declare.l HexLong(h$)
Declare.d RadiusBetrag(k)
Declare.d GeschwBetrag(k)
Declare ProjPar()
Declare Index()
Declare DoppPar()
Declare.d WoffErde()
Declare.l UTC()
Declare.s Datum(typ)
Declare.s Jahr(t.d)
Declare.l UU(x.d,y.d,z.d)
Declare.l WW(x.d,y.d,z.d)
Declare.l HH(x.d,y.d,z.d)
Declare.l UUR(u,w,uztr,wztr,ph.d)
Declare.l WWR(u,w,uztr,wztr,ph.d)
Declare.d Wert(a$)
Declare.s StrDD(x.d,s)
Declare.s StrE(x.d,st)
Declare.l MaxL(x.l,y.l)
Declare.l MinL(x.l,y.l)
Declare.d MaxD(x.d,y.d)
Declare.d MinD(x.d,y.d)
Declare Status()
;- Variable
Define.l
; Steuerung:
Global QQQ,KKK,EventID,WinID,MenID,GadID
; Dateien etc.:
Global programmtitel$,programmtitelalt$,version$,versionalt$
Global pfad$,appenv$,appdat$,appdatalt$,exe$,tmpdat$,tmpdatfile$,inidat$,neudat$
Global einini$,eininialt$,eininifile$
Global starthilfe
; Oberflche etc.
Global fenstertitel$,zeilen.d,zeilenl,spalten.d,spaltenl,tiefe
Global asp.d,aspbild.d,aspdruck.d,vblsync,scrtmout
; Zeit:
Global zeit.d,zeitalt.d,tzbias,tzadd$,dlbias,lokal,biaskorr,datum$,datumalt$
Global dt.d,dtcfg.d,dtvar.d,dtalt.d,dtvorscr.d,dtvorred.d,dtkoll.d,fahrint.d,fahrkp
Global reduz,reduztmp
Global startdateizeit,tempstartdateizeit,datenzeit.d,zustandszeit.d
Global startzeit.d,startzeitalt.d,stopzeit.d,stopzeitalt.d,stopzeitvor.d,diffstartstop.d
Global eingabezeit.d,startzeitvar,startdatentyp
; Raum:
Global pa.d,pb.d,sia.d,coa.d,sib.d,cob.d
Global siasib.d, siacob.d,sibcoa.d,coacob.d,sia2cob.d,coa2cob.d
Global projx.d,projy.d,proja.d,projb.d,blick
Global omega.d,phi.d,phib.d,rtstp,rtcmp
Global akoll.d,testdist.d,testkoll.d
; Darstellung:
Global Dim men(1)
Global Dim spritenum(20)
Global Dim ku(20)
Global Dim kw(20)
Global Dim kh(20)
Global Dim lu(5)
Global Dim lw(5)
Global Dim hcop(20)
Global Dim hsort(20)
Global Dim hind(20)
Global Dim bldradcfg(30)
Global Dim bldrad(30)
Global Dim farbecfg(40)
Global Dim farbe(40)
Global Dim farbetmp(40)
Global Dim frbplot(20)
Global Dim fotoname$(0)
Global Dim fotopart$(0)
Global breite.d,brttmp,uoff.d,woff.d,uoffcfg.d,woffcfg.d,labor
Global bldzoom,bahnpunkte,bahnspeicher,bahnschritt,rknschritt,bildschritt.d
Global bahnweg,mondzoom.d,bildpfad$,fotozahl,foto
; Krper:
Global Dim name$(20)
Global Dim namezst$(20)
Global Dim datname$(30)
Global Dim datmm$(11)
Global Dim datmm.d(30)
Global Dim datrr$(11)
Global Dim datrr.d(30)
Global Dim radius.d(30)
Global Dim koll.d(30,30)
Global Dim kpr(22)
Global Dim pos(30)
Global Dim datsx.d(11)
Global Dim datsy.d(11)
Global Dim datsz.d(11)
Global Dim datvx.d(11)
Global Dim datvy.d(11)
Global Dim datvz.d(11)
Global Dim stasx.d(11)
Global Dim stasy.d(11)
Global Dim stasz.d(11)
Global Dim stavx.d(11)
Global Dim stavy.d(11)
Global Dim stavz.d(11)
Global Dim stosx.d(11)
Global Dim stosy.d(11)
Global Dim stosz.d(11)
Global Dim stovx.d(11)
Global Dim stovy.d(11)
Global Dim stovz.d(11)
Global Dim osx.d(11)
Global Dim osy.d(11)
Global Dim osz.d(11)
Global Dim ovx.d(11)
Global Dim ovy.d(11)
Global Dim ovz.d(11)
Global Dim csv$(11,6)
Global kp,bezug,posbzg,kpgad,hohkp
Global dpp.d,ydpp1.d,ydpp2.d,zdpp1.d,zdpp2.d,vxdpp1.d,vxdpp2.d
; Zustnde:
Global Dim m.d(22)
Global Dim sx.d(22)
Global Dim sy.d(22)
Global Dim sz.d(22)
Global Dim vx.d(20)
Global Dim vy.d(20)
Global Dim vz.d(20)
Global Dim ax.d(20)
Global Dim ay.d(20)
Global Dim az.d(20)
Global Dim grav.d(20)
Global Dim sxalt.d(2)
Global Dim syalt.d(2)
Global Dim szalt.d(2)
Global Dim sxb.d(0)
Global Dim syb.d(0)
Global Dim szb.d(0)
Global Dim fb.b(0)
Global Dim cb.b(0)
Global Dim mb.b(0)
Global Dim sxw.d(0)
Global Dim syw.d(0)
Global Dim szw.d(0)
Global Dim phw.d(0)
Global mstern1.d,mstern2.d
Global gamma.d,gravob
Global rr.d,r1.d,r2.d,r3.d,v1.d,v2.d,rbtg.d,vbtg.d,satfak.d
Global dx.d,dy.d,dz.d,wx.d,wy.d,wz.d
Global sxzwi.d,syzwi.d,szzwi.d,vxzwi.d,vyzwi.d,vzzwi.d,mzwi.d
Global gsx$,gsy$,gsz$,gvx$,gvy$,gvz$,gm$
Global fahrf.d,uschw,wschw,hohfak.d,hoh,bcnt,bcntmax,wcnt,wcntmax
; Lagrangepunkte:
Global Dim sxl.d(5)
Global Dim syl.d(5)
Global Dim szl.d(5)
Global Dim sxlalt.d(5)
Global Dim sylalt.d(5)
Global Dim szlalt.d(5)
Global Dim vxl.d(5)
Global Dim vyl.d(5)
Global Dim vzl.d(5)
Global lagr1,lagr2,lagralt,lagrstop
; Zusatzkrfte:
Global zusatztyp,zusatzkp,beschl.d,fzusatz.d,reib.d,reibpar.d,zusatzdauer.d
; Diverses:
Global Dim lp(7)
Global Dim bgad(4)
Global Dim htxt$(26)
Global stellen,stellenalt,stellenexp,stellengeschw,stbartxt$,stbartyp
Global par,keinabbruch,multein,eingad,exit$
Global temp.d,tempa.d,tempb.d,tempc.d,tempq.q,templa,templb,temps$
;- Version
version$="3.4"
versionalt$="3.3"
programmtitel$="Gravitation"+Chr(32)+version$
programmtitelalt$="Gravitation"+Chr(32)+versionalt$
fenstertitel$="Gravitation"+Chr(160)+version$
;- Instanztest
If EnumWindows_(@Instanztest(),0)=#False
  Programmende()
EndIf
;- Konstanten
#obsolet_zustand=30
#winspalten=848
#winzeilen=504
#breitecfg=1
#bldzoomklcfg=3
#bldzoommicfg=4
#bldzoomgrcfg=5
#brttmpcfg=1
#bahnspeichercfg=5242880 ; 5 MB
#bahnschrittcfg=10
#bildschrittcfg=1
#rknschrittcfg=10
#stellencfg=0
#stellenexpcfg=6
#starthilfecfg=1
#lokalcfg=0
#mezbias=-3600
#biaskorrcfg=0
#aspbildcfg=1
#aspdruckcfg=1
#vblsync=#PB_Screen_SmartSynchronization 
#inaktiv=10
#fehll=-2147483648 ; -2^31
#fehlq=-9223372036854775808 ; -2^63
#fehld=1.30319e39
#riesig=1e100
#ecl=0.41015   ; 23.5 Grad
#blickcfg=1
#grosss=1.4e26 ; (m)   ca. 15 Milliarden Lichtjahre
#grossv=3e8    ; (m/s) ca. Lichtgeschwindigkeit
#grosst=4.7e17 ; (s)   ca. 15 Milliarden Jahre
#dtcfg=600
#dtvarcfg=0.00001
#dtkollcfg=1
#akollcfg=1
#fzusatzcfg=1
#reibparcfg=1
#mondzoomcfg=1
#satfakcfg=1.5
#hohfakcfg=1.2
#dppcfg=5e10
#omegacfg=-7.272205216643e-5 ; -2pi/d
#geostat=42241096.727873
#vxob=0
#vxlabgr=10 ; Startgeschwindigkeiten Krper W1 - W2
#vxlabkl=1
#vyerde=9000
#vyob=3000
#vylabgr=45
#vylabkl=4
; Gravitationskonstante nach University of Washington 2002 in m^3/(kg*s^2)
; siehe: http://lheawww.gsfc.nasa.gov/users/merk/G/Big_G.html
#gammacfg=6.674215e-11
; Astronomische Einheit in m:
#ae=149597870660
; Geschwindigkeit in m/s:
#aeprotag=1731456.8363425925
; Siderisches Jahr in s:
#jahrsid=31558149.54
; Massen in kg (Planetary Fact Sheets, NASA);
; korrigierte Werte fr 1 - 11 ggf. in Daten... .ini eingeben
datmm$(1)="1.9891e30"    ; Sonne
datmm$(2)="3.3022e23"    ; Merkur
datmm$(3)="4.8685e24"    ; Venus
datmm$(4)="5.972245e24"  ; Erde nach Univ. of Wash. 2002 ; 5.9736e24 nach NASA
datmm$(5)="6.4185e23"    ; Mars
datmm$(6)="1.8986e27"    ; Jupiter
datmm$(7)="5.6846e26"    ; Saturn
datmm$(8)="8.6832e25"    ; Uranus
datmm$(9)="1.0243e26"    ; Neptun
datmm$(10)="1.412e22"    ; Pluto + Charon (1,25e22 + 1,62e21) !
datmm$(11)="7.349e22"    ; Mond
For k=1 To 11
  datmm.d(k)=ValD(datmm$(k))
Next k
For k=12 To 18
  datmm.d(k)=1e19        ; Krper A - G (Dichte ca. 2,4g/cm^3)
Next k
datmm.d(19)=datmm.d(1)/2 ; Stern 1
datmm.d(20)=datmm.d(1)/2 ; Stern 2
datmm.d(24)=datmm.d(4)   ; Erde
datmm.d(25)=datmm.d(11)  ; Mond
datmm.d(26)=1e3          ; Satellit S1
datmm.d(27)=1e3          ; Satellit S2
datmm.d(28)=1e3          ; Satellit S3
datmm.d(29)=1            ; Krper W1
datmm.d(30)=1            ; Krper W2
; Radien (Mittel) in m (Planetary Fact Sheets, NASA)
; korrigierte Werte fr 1 - 11 ggf. in Daten... .ini eingeben
datrr$(1)="696000000"    ; Sonne
datrr$(2)="2439700"      ; Merkur
datrr$(3)="6051800"      ; Venus
datrr$(4)="6378000"      ; Erde
datrr$(5)="3397000"      ; Mars
datrr$(6)="71492000"     ; Jupiter
datrr$(7)="60268000"     ; Saturn
datrr$(8)="25559000"     ; Uranus
datrr$(9)="24764000"     ; Neptun
datrr$(10)="1195000"     ; Pluto
datrr$(11)="1738000"     ; Mond
For k=1 To 11
  datrr.d(k)=ValD(datrr$(k))
Next k
For k=12 To 18
  datrr.d(k)=100000      ; Krper A - G
Next k
datrr.d(19)=554000000    ; Stern 1
datrr.d(20)=554000000    ; Stern 2
datrr.d(24)=datrr.d(4)   ; Erde
datrr.d(25)=datrr.d(11)  ; Mond
datrr.d(26)=10           ; Satellit S1
datrr.d(27)=10           ; Satellit S2
datrr.d(28)=10           ; Satellit S3
datrr.d(29)=0.01         ; Krper W1
datrr.d(30)=0.01         ; Krper W2
; Namensliste:
datname$(1)="Sonne"
datname$(2)="Merkur"
datname$(3)="Venus"
datname$(4)="Erde"
datname$(5)="Mars"
datname$(6)="Jupiter"
datname$(7)="Saturn"
datname$(8)="Uranus"
datname$(9)="Neptun"
datname$(10)="Pluto"
datname$(11)="Mond"
datname$(12)="A"
datname$(13)="B"
datname$(14)="C"
datname$(15)="D"
datname$(16)="E"
datname$(17)="F"
datname$(18)="G"
datname$(19)="Stern 1"
datname$(20)="Stern 2"
datname$(22)="SP"
datname$(23)="L"
datname$(24)="Erde"
datname$(25)="Mond"
datname$(26)="S1"
datname$(27)="S2"
datname$(28)="S3"
datname$(29)="W1"
datname$(30)="W2"
; Bilderradien:
bldradcfg(1)=3
bldradcfg(2)=2
bldradcfg(3)=2
bldradcfg(4)=2
bldradcfg(5)=2
bldradcfg(6)=2
bldradcfg(7)=2
bldradcfg(8)=2
bldradcfg(9)=2
bldradcfg(10)=1
bldradcfg(11)=1
bldradcfg(12)=1
bldradcfg(13)=1
bldradcfg(14)=1
bldradcfg(15)=1
bldradcfg(16)=1
bldradcfg(17)=1
bldradcfg(18)=1
bldradcfg(19)=3
bldradcfg(20)=3
bldradcfg(24)=2
bldradcfg(25)=1
bldradcfg(26)=1
bldradcfg(27)=1
bldradcfg(28)=1
bldradcfg(29)=1
bldradcfg(30)=1
; Farben:
farbecfg(1)=$DCFFFF
farbecfg(2)=$04BCFB
farbecfg(3)=$A0FFFF
farbecfg(4)=$DDAA20
farbecfg(5)=$1154EE
farbecfg(6)=$3C88EC
farbecfg(7)=$15AFEA
farbecfg(8)=$FBF1AD
farbecfg(9)=$FBF1AD
farbecfg(10)=$FBF1AD
farbecfg(11)=$E3FFFF
farbecfg(12)=$ADD552
farbecfg(13)=$ADD552
farbecfg(14)=$ADD552
farbecfg(15)=$ADD552
farbecfg(16)=$ADD552
farbecfg(17)=$ADD552
farbecfg(18)=$ADD552
farbecfg(19)=$DCFFFF
farbecfg(20)=$DCFFFF
farbecfg(21)=$D5DC50
farbecfg(22)=$FFFF00
farbecfg(23)=$0055FF
farbecfg(24)=$DDAA20
farbecfg(25)=$E3FFFF
farbecfg(26)=$ADD552
farbecfg(27)=$ADD552
farbecfg(28)=$ADD552
farbecfg(29)=$ADD552
farbecfg(30)=$ADD552
farbecfg(31)=$643200
farbecfg(32)=$00FFFF
farbecfg(33)=$00FF00
farbecfg(34)=farbecfg(22)
farbecfg(35)=$FFFFFF
farbecfg(36)=$0064FF
farbecfg(37)=$0070FF
farbecfg(38)=$A0F080
farbecfg(39)=$000000
farbecfg(40)=$000000
; Meldung Programmende:
exit$=Chr(13)+Chr(13)+programmtitel$+" wird beendet.    "
;-
;- Programmstart
Konfiguration()
FensterAuf()
InitMenuGadget()
CtrlMenuGadget()
HideWindow(0,0)
If startdateizeit=tempstartdateizeit
  BahnrechnungA(1)
Else
  BahnrechnungA(9)
EndIf
;- HAUPTSCHLEIFE
Repeat
  EventID=WaitWindowEvent()
  Select EventId
    Case #PB_Event_CloseWindow
      InfoM(stbartxt$,stbartyp)
      quit=1
    Case #PB_Event_Menu
      InfoM(stbartxt$,stbartyp)
      MenID=EventMenu()
      Select MenID
        Case 11 ; Startdatei auswhlen
          StartdateiAusw()
        Case 12 ; Bilder ffnen
          BildOeffnen()
        Case 13 ; Bilder drucken
          BildDrucken(0)
        Case 14 ; Einstellungen bernehmen
          ConfigUebernehmen()
        Case 15 ; Pfade anzeigen
          InfoHilfe(6)
        Case 16 ; Startdatei erzeugen
          StartdateiErzg()
        Case 19 ; Programmende
          quit=1
        Case 21,22 ; Geometrie einstellen
          Geometrie(MenID-20)  
        Case 23 ; Druckgeometrie ein/aus
          DruckgeometrieEA()
        Case 24 ; Synchronisation ein/aus
          SynchronisationEA()
        Case 27 ; Voreinstellung Bahnspeicher
          Reset(7)
        Case 28 ; Bahnspeicher einstellen
          ParameterEin(15)
        Case 29 ; Belegter Bahnspeicher
          Speicherinfo()
        Case 30 ; LOC-Anzeige ein/aus
          LokalEA()
        Case 31 ; UTC-Korrektur
          ParameterEin(42)
        Case 310 To 319 ; Sonne ... Pluto eingeben
          Eingeben(MenID-309)
        Case 3190 ; innere Planeten eingeben
          Eingeben(2)
          multein=1
          If keinabbruch
            Eingeben(3)
          EndIf
          If keinabbruch
            Eingeben(4)
          EndIf
          If keinabbruch
            Eingeben(5)
          EndIf
          multein=0
        Case 3191 ; uere Planeten eingeben
          Eingeben(6)
          multein=1
          If keinabbruch
            Eingeben(7)
          EndIf
          If keinabbruch
            Eingeben(8)
          EndIf
          If keinabbruch
            Eingeben(9)
          EndIf
          multein=0
        Case 3192 ; Mond baryzentrisch eingeben
          Eingeben(11)
        Case 3193 ; Krper A - G baryzentrisch eingeben
          Eingeben(12)
        Case 3194 ; Krper A - G baryzentrisch in Ekliptikebene eingeben
          Eingeben(13)
        Case 3195 ; Doppelstern eingeben
          Eingeben(19)
        Case 320 ; Erde geozentrisch eingeben
          Eingeben(24)
        Case 321 ; Erdoberflche eingeben
          Eingeben(241)
        Case 322 ; Erdoberflche Laborsystem gro eingeben
          Eingeben(242)
        Case 3221; Erdoberflche Laborsystem klein eingeben
          Eingeben(243)
        Case 323 ; Mond geozentrisch eingeben
          Eingeben(25)
        Case 324 ; Satellit in quatorebene eingeben
          Eingeben(26)
        Case 325 ; Satellit auf polarer Bahn eingeben
          Eingeben(27)
        Case 326 ; Krper A - G geozentrisch eingeben
          Eingeben(12)
        Case 327 ; Krper A - G geozentrisch in quatorebene eingeben
          Eingeben(14)
        Case 328 ; Krper W1 - W2 geozentrisch eingeben
          Eingeben(29)
        Case 341 To 345 ; Krper eingeben nach L1 ... L5
          Eingeben(MenID-310)
        Case 346 ; ... alle
          For i=31 To 35
            Eingeben(i)
          Next i
        Case 40 ; Bild anzeigen (Shortcut)
          BildAnzeigen(1,1)
        Case 501 ; Startzeit einstellen
          ParameterEin(41)
        Case 502 ; Temporre Startdatei neu berechnen
          BahnrechnungA(9)  
        Case 505 ; Voreinstellung Parameter 1
          Reset(0)
        Case 506 ; Zeitschritt Standard
          ParameterEin(2)
        Case 507 ; Schrittweite Bahn
          ParameterEin(4)
        Case 508 ; Schrittweite Bild
          ParameterEin(13)
        Case 509 ; Schrittweite Rekonstruktion
          ParameterEin(14)
        Case 510 ; Voreinstellung Parameter 2
          Reset(1)
        Case 520 ; Bildbreite einstellen
          ParameterEin(1)
        Case 521 ; Zeitschritt (variabel) einstellen
          ParameterEin(3)
        Case 522 ; Zoomfaktor Mondbahn einstellen
          ParameterEin(5)
        Case 523 ; Fahrstrahlintervall einstellen
          ParameterEin(7)
        Case 524 ; Hohmannfaktor einstellen
          ParameterEin(8)
        Case 525 ; Zusatzkraft einstellen
          ParameterEin(10)
        Case 526 ; Reibungsfaktor einstellen
          ParameterEin(11)
        Case 527 ; Nachkommastellen Normaldarstellung einstellen
          ParameterEin(9)
        Case 528 ; Nachkommastellen Exponentialdarstellung einstellen
          ParameterEin(18)
        Case 530 ; Voreinstellung Farben laden
          Farbwahl(0)
        Case 531 ; Benutzereinstellung Farben speichern
          ConfigSpeichern(2)
        Case 532 ; Benutzereinstellung Farben laden
          ConfigLaden(einini$,2)
        Case 5330 To 5340 ; Farben einstellen
          Farbwahl(MenID-5329)
        Case 540 ; Voreinstellung Bilderradien einstellen
          Radiuswahl(0)
        Case 541 ; Benutzereinstellung Radien speichern
          ConfigSpeichern(3)
        Case 542 ; Benutzereinstellung Radien laden
          ConfigLaden(einini$,3)
        Case 543 ; Bildradius des selektierten Krpers einstellen
          Radiuswahl(1)
        Case 544 ; Voreinstellung Zoomfaktor laden
          Spritegroesse(0)
        Case 545 ; Zoomfaktor fr Bildradius aller Krper einstellen
          Spritegroesse(3)
        Case 555 ; Voreinstellung Krfte laden
          Reset(5)
        Case 556 ; Gravitationskonstante einstellen
          ParameterEin(50)
        Case 561 ; Voreinstellung Krperradien laden
          Reset(2)
        Case 562 ; Krperradius einstellen
          ParameterEin(21)
        Case 565 ; Voreinstellung Satellitenbahn laden
          Reset(6)
        Case 566 ; Satellitenbahnradius einstellen
          ParameterEin(33)
        Case 570 ; Voreinstellung Doppelstern laden
          Reset(3)
        Case 571 ; Doppelsternabstand einstellen
          ParameterEin(24)
        Case 572 ; Masse Stern 1 einstellen
          ParameterEin(25)
        Case 573 ; Masse Stern 2 einstellen
          ParameterEin(26)
        Case 575 ; Voreinstellung Kollisionsverhalten laden
          Reset(4)
        Case 576 ; Beschleunigung vor Kollision einstellen
          ParameterEin(16)
        Case 577 ; Zeitschritt vor Kollision einstellen
          ParameterEin(17)
        Case 578 ; Unelastischer Sto ein/aus
          StossEA()
        Case 579 ; Zeitschrittreduzierung ein/aus
          ReduzierungEA(0)
        Case 65 ; Lagrangepunkte Sonne-Merkur anzeigen
          LagrangeEA(1,2,65)
        Case 66 ; Lagrangepunkte Sonne-Venus anzeigen
          LagrangeEA(1,3,66)
        Case 67 ; Lagrangepunkte Sonne-Erde anzeigen
          LagrangeEA(1,4,67)
        Case 68 ; Lagrangepunkte Sonne-Mars anzeigen
          LagrangeEA(1,5,68)
        Case 69 ; Lagrangepunkte Sonne-Jupiter anzeigen
          LagrangeEA(1,6,69)
        Case 70 ; Lagrangepunkte Sonne-Saturn anzeigen
          LagrangeEA(1,7,70)
        Case 71 ; Lagrangepunkte Sonne-Uranus anzeigen
          LagrangeEA(1,8,71)
        Case 72 ; Lagrangepunkte Sonne-Neptun anzeigen
          LagrangeEA(1,9,72)
        Case 73 ; Lagrangepunkte Sonne-Pluto anzeigen
          LagrangeEA(1,10,73)
        Case 74 ; Lagrangepunkte Erde-Mond anzeigen
          LagrangeEA(24,25,74)
        Case 75 ; Lagrangepunkte Stern 1-Stern 2 anzeigen
          LagrangeEA(19,20,75)
        Case 76 ; Lagrangepunkte abschalten
          LagrangeEA(0,0,76)
        Case 770 ; Zusatzkraft aus
          ZusatzkraftEA(0)
        Case 771 ; Zusatzkraft konstant
          ZusatzkraftEA(1)
        Case 772 ; Zusatzkraft ~ v
          ZusatzkraftEA(2)
        Case 773 ; Zusatzkraft ~ v^2
          ZusatzkraftEA(3)
        Case 777 ; Dauer der Zusatzkraft einstellen
          ParameterEin(12)
        Case 85 ; Texte ffnen
          InfoHilfe(2)
        Case 86 ; Hilfeanzeige beim Programmstart ein/aus
          InfoHilfe(3)
        Case 87 ; Info
          Info()
        Case 91 ; bernehmen mit Return- oder Enter-Taste
          If bgad(0)=0
            ParameterAus(1) ; bernehmen (Parameter)
          ElseIf kpgad>0
            Zustand(1,kpgad); bernehmen (Zustand)
          EndIf
        Case 99 ; Nur zur Entwicklung
          Status()
      EndSelect
      CtrlMenuGadget()  
    Case #PB_Event_Gadget
      InfoM(stbartxt$,stbartyp)
      GadID=EventGadget()
      Select GadID
        Case 101 ; bernehmen (Zustand)
          Zustand(1,kpgad)
        Case 102 ; rckgngig (Zustand)
          Zustand(2,kpgad)
        Case 103 ; Bahnradius
          ParameterEin(32)
        Case 104 ; Geschwindigkeit
          ParameterEin(31)
        Case 105 ; Zustand aller eingegebenen Krper speichern
          ZustandSpeichern()
        Case 106 ; gespeicherten Zustand laden
          ZustandLaden()
        Case 112 ; bernehmen (Parameter)
          ParameterAus(1)
        Case 113 ; abbrechen (Parameter)
          ParameterAus(0)
        Case 2 ; Zustand
          kgd=GetGadgetState(2)+1
          If kgd>0 ; keine leere Zeile ausgewhlt
            kpgad=kgd
            Zustand(0,kpgad)
          EndIf
        Case 22 ; Bild anzeigen
          BildAnzeigen(1,1)
        Case 23 ; ausgewhlten Krper entfernen
          Entfernen(kpgad,1)
        Case 24 ; alle Krper entfernen
          Entfernen(0,1)
        Case 31 ; Bild Bezug Nullpunkt
          BezugBild(0)
        Case 32 ; Bild Bezug Sonne
          BezugBild(1)
        Case 33 ; Bild Bezug Erde
          BezugBild(4)
        Case 34 ; Bild Bezug Schwerpunkt
          BezugBild(22)
        Case 41 To 45 ; Blickrichtung whlen
          Blickrichtung(GadID-40)  
        Case 51 ; Bahnen zeichnen ein/aus
          BahnenEA()
        Case 52 ; Geschwindigkeit anzeigen ein/aus
          GeschwindigkeitEA()
        Case 53 ; Schwerpunkt zeichnen ein/aus
          SchwerpunktEA()
        Case 54 ; Fahrstrahl ein/aus
          FahrstrahlEA()
        Case 55 ; Hilfe anzeigen
          InfoHilfe(0)
        Case 56 ; Namen anzeigen
          NamenEA()
        Case 57 ; Achsen anzeigen
          AchsenEA()
        Case 58 ; Bildbreite anzeigen
          BildbreiteEA()
        Case 59 ; Zeit anzeigen
          ZeitEA()
        Case 590 ; Zeitschritt anzeigen
          ZeitschrittEA()
        Case 591 ; Schwarzweibild
          Farbwahl(12)
        Case 61 ; Bildbreite Merkurbahn
          BildBrt(2)
        Case 62 ; Bildbreite Erdbahn
          BildBrt(4)
        Case 63 ; Bildbreite Marsbahn
          BildBrt(5)
        Case 64 ; Bildbreite Jupiterbahn
          BildBrt(6)
        Case 65 ; Bildbreite Neptunbahn
          BildBrt(9)
        Case 66 ; Bildbreite Mondbahn geozentrisch
          BildBrt(11)
        Case 67 ; Bildbreite Satellitenbahn
          BildBrt(12)
        Case 68 ; Bildbreite geostationre Satellitenbahn
          BildBrt(13) 
        Case 72 ; Erdrotation ein
          Erdoberflaeche(1)
        Case 73 ; Erdrotation aus
          Erdoberflaeche(2)
        Case 75 ; Bezug Erdoberflche Koordinatensystem
          Erdoberflaeche(3)
        Case 76 ; Bezug Erdoberflche
          Erdoberflaeche(4)
        Case 81 To 88 ; Zeitschritt
          Zeitschritt(GadID-81)
        Case 91 To 93 ; Gravitationsfeld Erdoberflche 
          Erdfeld(GadID-91)  
      EndSelect
      CtrlMenuGadget()
  EndSelect
  If (quit=1) And (kp>0)
    If kp=1
      nkp$="ist ein"
    Else
      nkp$="sind "+Str(kp)
    EndIf
    txt$="Es "+nkp$+" Krper eingegeben.    "
    txt$+Chr(13)+Chr(13)
    txt$+"Mchten Sie "+programmtitel$+" trotzdem beenden?    "
    res=MessageRequester(programmtitel$,txt$,#PB_MessageRequester_YesNo|#MB_ICONQUESTION|#MB_DEFBUTTON2)
    If res=#PB_MessageRequester_No
      quit=0
    EndIf
  EndIf
Until quit=1
;- Programmende
Programmende()
;-
;- KONFIGURATION
Procedure Konfiguration()
  tit$=programmtitel$+": Fehler beim Programmstart "
  ;
  If (InitSprite()=0) Or (InitKeyboard()=0)
    txt$=programmtitel$+" bentigt DirectX in der Version 7.0 oder hher.    "
    txt$+Chr(13)
    txt$+"DirectX 7.0 oder hher wurde auf diesem Rechner nicht gefunden.    "+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  ;
  exe$=programmtitel$+".exe"
  *buf=AllocateMemory(255)
  If *buf And GetFullPathName_(exe$,255,*buf,0)
    pfad$=GetPathPart(PeekS(*buf))
    FreeMemory(*buf)
  Else
    txt$="Der vollstndige Dateipfad der Datei "
    txt$+exe$+Space(4)+Chr(13)
    txt$+"konnte nicht ermittelt werden.    "+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  If FileSize(pfad$+"Daten*.ini")=-1
    txt$="Es wurden keine Startdateien Daten... .ini gefunden.    "+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  ;
  appenv$=GetEnvironmentVariable("AppData")+"\"
  appdat$=appenv$+programmtitel$+"\"
  If FileSize(appdat$)=-1
    ; Anwendungsdatenverzeichnis erzeugen
    If CreateDirectory(appdat$)=0
      txt$="Das Verzeichnis "
      txt$+Chr(13)+appdat$+Space(4)+Chr(13)
      txt$+"konnte nicht erzeugt werden.    "+exit$
      MessageRequester(tit$,txt$,#MB_ICONSTOP)
      Programmende()
    EndIf
  EndIf
  tmpdat$=appdat$+"TempDaten.ini"
  tmpdatfile$=GetFilePart(tmpdat$)
  einini$=appdat$+"Einstellungen.ini"
  eininifile$=GetFilePart(einini$)
  Schreibschutz(0)
  ;
  Zeit()
  ;
  drct=ExamineDirectory(#PB_Any,pfad$,"Daten*.ini")
  If drct>0
    While NextDirectoryEntry(drct)=1
      nd$=pfad$+DirectoryEntryName(drct)
      nd$=GetFilePart(nd$)
      nnnalt=nnn
      nnn=Abs(Date(Val(Mid(nd$,6,4)),Val(Mid(nd$,10,2)),Val(Mid(nd$,12,2)),0,0,0)-UTC())
      If nnn<nnnalt
        neudat$=nd$
      EndIf
    Wend
    inidat$=neudat$
  EndIf
  FinishDirectory(drct)
  ;
  drct=ExamineDirectory(#PB_Any,appdat$,"Grav*.jpg")
  If drct>0
    While NextDirectoryEntry(drct)=1
      ft$=appdat$+DirectoryEntryName(drct)
      fotozahl+1
      ReDim fotoname$(fotozahl)
      ReDim fotopart$(fotozahl)
      fotoname$(fotozahl)=ft$
      fn$=GetFilePart(ft$)
      unl=FindString(fn$,"_",1)
      unr=FindString(fn$,"_",unl+1)
      If (unl>0) And (unr>0)
        fotopart$(fotozahl)=Mid(fn$,unl+1,unr-unl-1)
      EndIf
    Wend
  EndIf
  FinishDirectory(drct)
  UseJPEGImageEncoder()
  UseJPEGImageDecoder()
  ;
  ; altes Anwendungsdatenverzeichnis suchen
  drct=ExamineDirectory(#PB_Any,appenv$,programmtitelalt$)
  If drct>0
    While NextDirectoryEntry(drct)=1
      appdatalt$=appenv$+DirectoryEntryName(drct)+"\"
    Wend
  EndIf
  FinishDirectory(drct)
  If (appdatalt$<>"") And (FileSize(appdatalt$+eininifile$)<>-1)
    eininialt$=appdatalt$+eininifile$
  EndIf
  ;
  zeilenl=Bildhoehe()
  zeilen.d=zeilenl
  spaltenl=Bildweite()
  spalten.d=spaltenl
  tiefe=MaxL(Bildtiefe(),16)
  uoffcfg.d=spalten.d/2
  woffcfg.d=zeilen.d/2
  uoff.d=uoffcfg.d
  woff.d=woffcfg.d
  gamma.d=#gammacfg
  gammaalt.d=#gammacfg
  fahrint.d=#jahrsid/12
  dtkoll.d=#dtkollcfg
  akoll.d=#akollcfg
  reibpar.d=#reibparcfg
  mondzoom.d=#mondzoomcfg
  satfak.d=#satfakcfg
  hohfak.d=#hohfakcfg
  dpp.d=#dppcfg
  omega.d=#omegacfg
  breite.d=#breitecfg
  bldzoom=#bldzoomgrcfg
  brttmp=#brttmpcfg
  pb.d=#ecl
  blick=#blickcfg
  stellen=#stellencfg
  stellenexp=#stellenexpcfg
  starthilfe=#starthilfecfg
  lokal=#lokalcfg
  biaskorr=#biaskorrcfg
  aspbild.d=#aspbildcfg
  asp.d=#aspbildcfg
  aspdruck.d=#aspdruckcfg
  vblsync=#vblsync
  bahnschritt=#bahnschrittcfg
  bildschritt.d=#bildschrittcfg
  rknschritt=#rknschrittcfg
  bahnspeicher=#bahnspeichercfg
  dtcfg.d=#dtcfg
  dtvar.d=#dtvarcfg
  mstern1.d=datmm.d(19)
  mstern2.d=datmm.d(20)
  Zuordnen(22,22)
  For i=1 To 30
    radius.d(i)=datrr.d(i)
    bldrad(i)=bldradcfg(i)
  Next i
  For i=1 To 40
    farbe(i)=farbecfg(i)
  Next i
  If FileSize(einini$)=-1
    ConfigSpeichern(0)
  EndIf
  ;
  ConfigLaden(einini$,1)
  ConfigLaden(einini$,2)
  ConfigLaden(einini$,3)
  DatenLaden(0)
  ProjPar()
  Kollisionsmatrix()
  HilfeBild()
EndProcedure ; Konfiguration
;
Procedure Instanztest(win)
  *buf=AllocateMemory(255)
  If *buf
    GetWindowText_(win,*buf,255)
    If PeekS(*buf)=fenstertitel$
      FreeMemory(*buf)
      wndpl.WINDOWPLACEMENT
      wndpl\length=SizeOf(WINDOWPLACEMENT)
      GetWindowPlacement_(win,@wndpl)
      wndpl\showCmd=#SW_RESTORE
      SetWindowPlacement_(win,@wndpl)
      SetForegroundWindow_(win)
      ProcedureReturn #False
    Else
      FreeMemory(*buf)
      ProcedureReturn #True
    EndIf
  EndIf
EndProcedure ; Instanztest
;
Procedure Speicherinfo()
  speicher.MEMORYSTATUS
  speicher\dwLength=SizeOf(MEMORYSTATUS)
  GlobalMemoryStatus_(@speicher)
  speichergesamt.d=speicher\dwTotalPhys/1048576
  speicherfrei.d=speicher\dwAvailPhys/1048576
  bahnspges.d=bahnspeicher/1048576
  bahnspfrei.d=bahnspges.d-MaxL(wcnt+bcnt+1,wcntmax+bcntmax+1)*59/1048576 ; 7*8+3*1=59
  tit$="Speicherinformationen"
  txt$="Physikalischer Speicher: "+StrDD(speichergesamt.d,0)+" MB    "
  txt$+Chr(13)
  txt$+"Davon jetzt frei: "+StrDD(speicherfrei.d,0)+" MB    "
  txt$+Chr(13)+Chr(13)
  txt$+"Bahnspeicher: "+StrDD(bahnspges.d,2)+" MB    "
  txt$+Chr(13)
  txt$+"Davon jetzt frei: "+StrDD(bahnspfrei.d,2)+" MB    "
  MessageRequester(tit$,txt$,#MB_ICONINFORMATION)
EndProcedure ; Speicherinfo
;
Procedure DatenSpeichern()
  If inidat$<>neudat$
    ProcedureReturn
  EndIf
  If CreatePreferences(tmpdat$)
    WritePreferenceString("Version",version$)
    temps$=FormatDate("%yyyy.%mm.%dd.%hh.%ii.%ss",startdateizeit)
    WritePreferenceString("startdateizeit",temps$)
    temps$=FormatDate("%yyyy.%mm.%dd.%hh.%ii.%ss",Int(startzeit.d+zeit.d)+biaskorr)
    WritePreferenceString("zeit",temps$)
    WritePreferenceDouble("sonmm",datmm.d(1))
    WritePreferenceDouble("sonrr",datrr.d(1))
    WritePreferenceDouble("sonsx",stasx.d(1))
    WritePreferenceDouble("sonsy",stasy.d(1))
    WritePreferenceDouble("sonsz",stasz.d(1))
    WritePreferenceDouble("sonvx",stavx.d(1))
    WritePreferenceDouble("sonvy",stavy.d(1))
    WritePreferenceDouble("sonvz",stavz.d(1))
    WritePreferenceDouble("mermm",datmm.d(2))
    WritePreferenceDouble("merrr",datrr.d(2))
    WritePreferenceDouble("mersx",stasx.d(2))
    WritePreferenceDouble("mersy",stasy.d(2))
    WritePreferenceDouble("mersz",stasz.d(2))
    WritePreferenceDouble("mervx",stavx.d(2))
    WritePreferenceDouble("mervy",stavy.d(2))
    WritePreferenceDouble("mervz",stavz.d(2))
    WritePreferenceDouble("venmm",datmm.d(3))
    WritePreferenceDouble("venrr",datrr.d(3))
    WritePreferenceDouble("vensx",stasx.d(3))
    WritePreferenceDouble("vensy",stasy.d(3))
    WritePreferenceDouble("vensz",stasz.d(3))
    WritePreferenceDouble("venvx",stavx.d(3))
    WritePreferenceDouble("venvy",stavy.d(3))
    WritePreferenceDouble("venvz",stavz.d(3))
    WritePreferenceDouble("erdmm",datmm.d(4))
    WritePreferenceDouble("erdrr",datrr.d(4))
    WritePreferenceDouble("erdsx",stasx.d(4))
    WritePreferenceDouble("erdsy",stasy.d(4))
    WritePreferenceDouble("erdsz",stasz.d(4))
    WritePreferenceDouble("erdvx",stavx.d(4))
    WritePreferenceDouble("erdvy",stavy.d(4))
    WritePreferenceDouble("erdvz",stavz.d(4))
    WritePreferenceDouble("marmm",datmm.d(5))
    WritePreferenceDouble("marrr",datrr.d(5))
    WritePreferenceDouble("marsx",stasx.d(5))
    WritePreferenceDouble("marsy",stasy.d(5))
    WritePreferenceDouble("marsz",stasz.d(5))
    WritePreferenceDouble("marvx",stavx.d(5))
    WritePreferenceDouble("marvy",stavy.d(5))
    WritePreferenceDouble("marvz",stavz.d(5))
    WritePreferenceDouble("jupmm",datmm.d(6))
    WritePreferenceDouble("juprr",datrr.d(6))
    WritePreferenceDouble("jupsx",stasx.d(6))
    WritePreferenceDouble("jupsy",stasy.d(6))
    WritePreferenceDouble("jupsz",stasz.d(6))
    WritePreferenceDouble("jupvx",stavx.d(6))
    WritePreferenceDouble("jupvy",stavy.d(6))
    WritePreferenceDouble("jupvz",stavz.d(6))
    WritePreferenceDouble("satmm",datmm.d(7))
    WritePreferenceDouble("satrr",datrr.d(7))
    WritePreferenceDouble("satsx",stasx.d(7))
    WritePreferenceDouble("satsy",stasy.d(7))
    WritePreferenceDouble("satsz",stasz.d(7))
    WritePreferenceDouble("satvx",stavx.d(7))
    WritePreferenceDouble("satvy",stavy.d(7))
    WritePreferenceDouble("satvz",stavz.d(7))
    WritePreferenceDouble("uramm",datmm.d(8))
    WritePreferenceDouble("urarr",datrr.d(8))
    WritePreferenceDouble("urasx",stasx.d(8))
    WritePreferenceDouble("urasy",stasy.d(8))
    WritePreferenceDouble("urasz",stasz.d(8))
    WritePreferenceDouble("uravx",stavx.d(8))
    WritePreferenceDouble("uravy",stavy.d(8))
    WritePreferenceDouble("uravz",stavz.d(8))
    WritePreferenceDouble("nepmm",datmm.d(8))
    WritePreferenceDouble("neprr",datrr.d(9))
    WritePreferenceDouble("nepsx",stasx.d(9))
    WritePreferenceDouble("nepsy",stasy.d(9))
    WritePreferenceDouble("nepsz",stasz.d(9))
    WritePreferenceDouble("nepvx",stavx.d(9))
    WritePreferenceDouble("nepvy",stavy.d(9))
    WritePreferenceDouble("nepvz",stavz.d(9))
    WritePreferenceDouble("plumm",datmm.d(10))
    WritePreferenceDouble("plurr",datrr.d(10))
    WritePreferenceDouble("plusx",stasx.d(10))
    WritePreferenceDouble("plusy",stasy.d(10))
    WritePreferenceDouble("plusz",stasz.d(10))
    WritePreferenceDouble("pluvx",stavx.d(10))
    WritePreferenceDouble("pluvy",stavy.d(10))
    WritePreferenceDouble("pluvz",stavz.d(10))
    WritePreferenceDouble("monmm",datmm.d(11))
    WritePreferenceDouble("monrr",datrr.d(11))
    WritePreferenceDouble("monsx",stasx.d(11))
    WritePreferenceDouble("monsy",stasy.d(11))
    WritePreferenceDouble("monsz",stasz.d(11))
    WritePreferenceDouble("monvx",stavx.d(11))
    WritePreferenceDouble("monvy",stavy.d(11))
    WritePreferenceDouble("monvz",stavz.d(11))
    ClosePreferences()
  Else
    tit$=programmtitel$+": Dateifehler"
    txt$="Die Datei "+tmpdatfile$+" konnte nicht geschrieben werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
  EndIf
EndProcedure ; DatenSpeichern
;
Procedure DatenLaden(typ)
  If OpenPreferences(pfad$+inidat$)
    dat$=ReadPreferenceString("zeit","1970.01.01.00.00.00")
    ClosePreferences()
    startdateizeit=ParseDate("%yyyy.%mm.%dd.%hh.%ii.%ss",dat$)+biaskorr
  Else
    tit$=programmtitel$+": Dateifehler"
    txt$="Die Datei "
    txt$+inidat$
    txt$+" konnte nicht geffnet werden.    "+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  ;
  If (FileSize(tmpdat$)=-1) Or (typ=1) Or (inidat$<>neudat$)
    dat1$=pfad$+inidat$
    dat2$=inidat$
    startdatentyp=1
    datenzeit.d=startdateizeit
  Else
    dat1$=tmpdat$
    dat2$=tmpdatfile$
    startdatentyp=0
    If OpenPreferences(dat1$)
      tempvers$=ReadPreferenceString("Version","")
      tempstrt$=ReadPreferenceString("startdateizeit","1970:01:01:00:00:00")
      tempzeit$=ReadPreferenceString("zeit","1970:01:01:00:00:00")
      ClosePreferences()
      If tempvers$<>version$
        Datenladen(1)
        ProcedureReturn
      EndIf
      tempstartdateizeit=ParseDate("%yyyy.%mm.%dd.%hh.%ii.%ss",tempstrt$)
      datenzeit.d=ParseDate("%yyyy.%mm.%dd.%hh.%ii.%ss",tempzeit$)+biaskorr
    Else
      DatenLaden(1)
      ProcedureReturn
    EndIf
  EndIf
  ;
  If OpenPreferences(dat1$)
    datmm.d(1) = ReadPreferenceDouble("sonmm",datmm.d(1))
    datrr.d(1) = ReadPreferenceDouble("sonrr",datrr.d(1))
    datsx.d(1) = ReadPreferenceDouble("sonsx",0)
    datsy.d(1) = ReadPreferenceDouble("sonsy",0)
    datsz.d(1) = ReadPreferenceDouble("sonsz",0)
    datvx.d(1) = ReadPreferenceDouble("sonvx",0)
    datvy.d(1) = ReadPreferenceDouble("sonvy",0)
    datvz.d(1) = ReadPreferenceDouble("sonvz",0)
    datmm.d(2) = ReadPreferenceDouble("mermm",datmm.d(2))
    datrr.d(2) = ReadPreferenceDouble("merrr",datrr.d(2))
    datsx.d(2) = ReadPreferenceDouble("mersx",0)
    datsy.d(2) = ReadPreferenceDouble("mersy",0)
    datsz.d(2) = ReadPreferenceDouble("mersz",0)
    datvx.d(2) = ReadPreferenceDouble("mervx",0)
    datvy.d(2) = ReadPreferenceDouble("mervy",0)
    datvz.d(2) = ReadPreferenceDouble("mervz",0)
    datmm.d(3) = ReadPreferenceDouble("venmm",datmm.d(3))
    datrr.d(3) = ReadPreferenceDouble("venrr",datrr.d(3))
    datsx.d(3) = ReadPreferenceDouble("vensx",0)
    datsy.d(3) = ReadPreferenceDouble("vensy",0)
    datsz.d(3) = ReadPreferenceDouble("vensz",0)
    datvx.d(3) = ReadPreferenceDouble("venvx",0)
    datvy.d(3) = ReadPreferenceDouble("venvy",0)
    datvz.d(3) = ReadPreferenceDouble("venvz",0)
    datmm.d(4) = ReadPreferenceDouble("erdmm",datmm.d(4))
    datrr.d(4) = ReadPreferenceDouble("erdrr",datrr.d(4))
    datsx.d(4) = ReadPreferenceDouble("erdsx",0)
    datsy.d(4) = ReadPreferenceDouble("erdsy",0)
    datsz.d(4) = ReadPreferenceDouble("erdsz",0)
    datvx.d(4) = ReadPreferenceDouble("erdvx",0)
    datvy.d(4) = ReadPreferenceDouble("erdvy",0)
    datvz.d(4) = ReadPreferenceDouble("erdvz",0)
    datmm.d(5) = ReadPreferenceDouble("marmm",datmm.d(5))
    datrr.d(5) = ReadPreferenceDouble("marrr",datrr.d(5))
    datsx.d(5) = ReadPreferenceDouble("marsx",0)
    datsy.d(5) = ReadPreferenceDouble("marsy",0)
    datsz.d(5) = ReadPreferenceDouble("marsz",0)
    datvx.d(5) = ReadPreferenceDouble("marvx",0)
    datvy.d(5) = ReadPreferenceDouble("marvy",0)
    datvz.d(5) = ReadPreferenceDouble("marvz",0)
    datmm.d(6) = ReadPreferenceDouble("jupmm",datmm.d(6))
    datrr.d(6) = ReadPreferenceDouble("juprr",datrr.d(6))
    datsx.d(6) = ReadPreferenceDouble("jupsx",0)
    datsy.d(6) = ReadPreferenceDouble("jupsy",0)
    datsz.d(6) = ReadPreferenceDouble("jupsz",0)
    datvx.d(6) = ReadPreferenceDouble("jupvx",0)
    datvy.d(6) = ReadPreferenceDouble("jupvy",0)
    datvz.d(6) = ReadPreferenceDouble("jupvz",0)
    datmm.d(7) = ReadPreferenceDouble("satmm",datmm.d(7))
    datrr.d(7) = ReadPreferenceDouble("satrr",datrr.d(7))
    datsx.d(7) = ReadPreferenceDouble("satsx",0)
    datsy.d(7) = ReadPreferenceDouble("satsy",0)
    datsz.d(7) = ReadPreferenceDouble("satsz",0)
    datvx.d(7) = ReadPreferenceDouble("satvx",0)
    datvy.d(7) = ReadPreferenceDouble("satvy",0)
    datvz.d(7) = ReadPreferenceDouble("satvz",0)
    datmm.d(8) = ReadPreferenceDouble("uramm",datmm.d(8))
    datrr.d(8) = ReadPreferenceDouble("urarr",datrr.d(8))
    datsx.d(8) = ReadPreferenceDouble("urasx",0)
    datsy.d(8) = ReadPreferenceDouble("urasy",0)
    datsz.d(8) = ReadPreferenceDouble("urasz",0)
    datvx.d(8) = ReadPreferenceDouble("uravx",0)
    datvy.d(8) = ReadPreferenceDouble("uravy",0)
    datvz.d(8) = ReadPreferenceDouble("uravz",0)
    datmm.d(9) = ReadPreferenceDouble("nepmm",datmm.d(9))
    datrr.d(9) = ReadPreferenceDouble("neprr",datrr.d(9))
    datsx.d(9) = ReadPreferenceDouble("nepsx",0)
    datsy.d(9) = ReadPreferenceDouble("nepsy",0)
    datsz.d(9) = ReadPreferenceDouble("nepsz",0)
    datvx.d(9) = ReadPreferenceDouble("nepvx",0)
    datvy.d(9) = ReadPreferenceDouble("nepvy",0)
    datvz.d(9) = ReadPreferenceDouble("nepvz",0)
    datmm.d(10) = ReadPreferenceDouble("plumm",datmm.d(10))
    datrr.d(10) = ReadPreferenceDouble("plurr",datrr.d(10))
    datsx.d(10) = ReadPreferenceDouble("plusx",0)
    datsy.d(10) = ReadPreferenceDouble("plusy",0)
    datsz.d(10) = ReadPreferenceDouble("plusz",0)
    datvx.d(10) = ReadPreferenceDouble("pluvx",0)
    datvy.d(10) = ReadPreferenceDouble("pluvy",0)
    datvz.d(10) = ReadPreferenceDouble("pluvz",0)
    datmm.d(11) = ReadPreferenceDouble("monmm",datmm.d(11))
    datrr.d(11) = ReadPreferenceDouble("monrr",datrr.d(11))
    datsx.d(11) = ReadPreferenceDouble("monsx",0)
    datsy.d(11) = ReadPreferenceDouble("monsy",0)
    datsz.d(11) = ReadPreferenceDouble("monsz",0)
    datvx.d(11) = ReadPreferenceDouble("monvx",0)
    datvy.d(11) = ReadPreferenceDouble("monvy",0)
    datvz.d(11) = ReadPreferenceDouble("monvz",0)
    ClosePreferences()
    ;
    datmm.d(19)=datmm.d(1)/2
    datmm.d(20)=datmm.d(1)/2
    mstern1.d=datmm.d(19)
    mstern2.d=datmm.d(20)
    datmm.d(24)=datmm.d(4)
    datmm.d(25)=datmm.d(11)
    datrr.d(24)=datrr.d(4)
    datrr.d(25)=datrr.d(11)
    For k=1 To 11
      radius.d(k)=datrr.d(k)
    Next k
  Else
    If startdatentyp=0
      DatenLaden(1)
    Else
      tit$=programmtitel$+": Dateifehler"
      txt$="Die Datei "
      txt$+dat2$
      txt$+" konnte nicht geffnet werden.    "
      MessageRequester(tit$,txt$,#MB_ICONSTOP)
    EndIf
    ProcedureReturn
  EndIf
  If startdatentyp=1
    For k=1 To 11
      datsx.d(k)=datsx.d(k)*#ae
      datsy.d(k)=datsy.d(k)*#ae
      datsz.d(k)=datsz.d(k)*#ae
      datvx.d(k)=datvx.d(k)*#aeprotag
      datvy.d(k)=datvy.d(k)*#aeprotag
      datvz.d(k)=datvz.d(k)*#aeprotag
    Next k
  EndIf
EndProcedure ; DatenLaden
;
Procedure ConfigSpeichern(typ)
  tit$=programmtitel$+": Dateifehler"
  txt$="Die Datei "+eininifile$+" konnte nicht "
  Select typ
    Case 0
      If CreatePreferences(einini$)
        PreferenceGroup("Version")
        WritePreferenceString("Version",version$)
        PreferenceGroup("Parameter")
        WritePreferenceLong("lokal",lokal)
        WritePreferenceLong("biaskorr",biaskorr)
        WritePreferenceDouble("aspectbild",aspbild.d)
        WritePreferenceDouble("aspectdruck",aspdruck.d)
        WritePreferenceLong("vblsync",vblsync)
        WritePreferenceLong("bahnspeicher",bahnspeicher)
        WritePreferenceDouble("zeitschritt",dtcfg.d)
        WritePreferenceLong("bahnschritt",bahnschritt)
        WritePreferenceDouble("bildschritt",bildschritt.d)
        WritePreferenceLong("rknschritt",rknschritt)
        WritePreferenceLong("starthilfe",starthilfe)
        PreferenceGroup("Farben")
        For i=1 To 40
          WritePreferenceString("farbe("+Str(i)+")","$"+RSet(Hex(farbe(i)),6,"0"))
        Next i
        PreferenceGroup("Radien")
        For i=1 To 30
          WritePreferenceLong("radius("+Str(i)+")",bldrad(i))
        Next i
        ClosePreferences()
      Else
        txt$+"geschrieben werden.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
      EndIf
    Case 1
      If OpenPreferences(einini$)
        PreferenceGroup("Version")
        WritePreferenceString("Version",version$)
        PreferenceGroup("Parameter")
        WritePreferenceLong("lokal",lokal)
        WritePreferenceLong("biaskorr",biaskorr)
        WritePreferenceDouble("aspectbild",aspbild.d)
        WritePreferenceDouble("aspectdruck",aspdruck.d)
        WritePreferenceLong("vblsync",vblsync)
        WritePreferenceLong("bahnspeicher",bahnspeicher)
        WritePreferenceDouble("zeitschritt",dtcfg.d)
        WritePreferenceLong("bahnschritt",bahnschritt)
        WritePreferenceDouble("bildschritt",bildschritt.d)
        WritePreferenceLong("rknschritt",rknschritt)
        WritePreferenceLong("starthilfe",starthilfe)
        ClosePreferences()
      Else
        txt$+"geffnet werden.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
      EndIf
    Case 2
      If OpenPreferences(einini$)
        PreferenceGroup("Version")
        WritePreferenceString("Version",version$)
        PreferenceGroup("Farben")
        For i=1 To 40
          WritePreferenceString("farbe("+Str(i)+")","$"+RSet(Hex(farbe(i)),6,"0"))
        Next i
        ClosePreferences()
      Else
        txt$+"geffnet werden.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
      EndIf
    Case 3
      If OpenPreferences(einini$)
        PreferenceGroup("Version")
        WritePreferenceString("Version",version$)
        PreferenceGroup("Radien")
        For i=1 To 30
          WritePreferenceLong("radius("+Str(i)+")",bldrad(i))
        Next i
        ClosePreferences()
      Else
        txt$+"geffnet werden.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
      EndIf
    Case 9
      If OpenPreferences(einini$)
        PreferenceGroup("Version")
        WritePreferenceString("Version",version$)
        ClosePreferences()
      Else
        txt$+"geffnet werden.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
      EndIf
  EndSelect
EndProcedure ; ConfigSpeichern
;
Procedure ConfigLaden(dat$,typ)
  If OpenPreferences(dat$)
    testversion$=ReadPreferenceString("Version","")
    Select typ
      Case 1
        PreferenceGroup("Parameter")
        lokal=ReadPreferenceLong("lokal",#lokalcfg)
        biaskorr=ReadPreferenceLong("biaskorr",#biaskorrcfg)
        aspbild.d=ReadPreferenceDouble("aspectbild",#aspbildcfg)
          asp.d=aspbild.d
        aspdruck.d=ReadPreferenceDouble("aspectdruck",#aspdruckcfg)
        vblsync=ReadPreferenceLong("vblsync",#vblsync)
        bahnspeicher=ReadPreferenceLong("bahnspeicher",#bahnspeichercfg)
          bahnpunkte=bahnspeicher/59-1
          ReDim sxb.d(bahnpunkte)
          ReDim syb.d(bahnpunkte)
          ReDim szb.d(bahnpunkte)
          ReDim fb.b(bahnpunkte)
          ReDim cb.b(bahnpunkte)
          ReDim mb.b(bahnpunkte)
          ReDim sxw.d(bahnpunkte)
          ReDim syw.d(bahnpunkte)
          ReDim szw.d(bahnpunkte)
          ReDim phw.d(bahnpunkte)
        dtcfg.d=ReadPreferenceDouble("zeitschritt",#dtcfg)
          dt.d=dtcfg.d
        bahnschritt=ReadPreferenceLong("bahnschritt",#bahnschrittcfg)
        bildschritt.d=ReadPreferenceDouble("bildschritt",#bildschrittcfg)
        rknschritt=ReadPreferenceLong("rknschritt",#rknschrittcfg)
        starthilfe=ReadPreferenceLong("starthilfe",#starthilfecfg)
      Case 2
        PreferenceGroup("Farben")
        For i=1 To 40
          fb$=ReadPreferenceString("farbe("+Str(i)+")","$000000")
          farbe(i)=HexLong(fb$)
        Next i
      Case 3
        PreferenceGroup("Radien")
        For i=1 To 29
          bldrad(i)=ReadPreferenceLong("radius("+Str(i)+")",1)
        Next i
        bldrad(30)=ReadPreferenceLong("radius(30)",-1) ; kompatibel zu Version 2.3
        If bldrad(30)=-1
           bldrad(30)=bldrad(29)
           ConfigSpeichern(3)
        EndIf
    EndSelect
    ClosePreferences()
  Else
    tit$=programmtitel$+": Dateifehler"
    txt$="Die Datei "+eininifile$+" konnte nicht geffnet werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
  EndIf
  If testversion$=""
    ConfigSpeichern(9)
  EndIf
EndProcedure ; ConfigLaden
;
Procedure ConfigUebernehmen()
  bak$=RemoveString(einini$,".ini",1)+FormatDate("%yy%mm%dd%hh%ii%ss",UTC())+".bak"
  tit$="Einstellungen bernehmen"
  txt$="Sollen die Einstellungen aus "+programmtitelalt$+" bernommen werden?    "
  txt$+Chr(13)+Chr(13)
  txt$+"Die zurzeit verwendeten Einstellungen werden dann in die Datei    "
  txt$+Chr(13)
  txt$+GetFilePart(bak$)+" kopiert.    "
  res=MessageRequester(tit$,txt$,#PB_MessageRequester_YesNo|#MB_ICONQUESTION|#MB_DEFBUTTON2)
  If res=#PB_MessageRequester_No
    ProcedureReturn
  EndIf
  If CopyFile(einini$,bak$)=0
    txt$="Das Kopieren der zurzeit verwendeten Einstellungen ist fehlgeschlagen.    "
    txt$+Chr(13)
    txt$+"Die bernahme der Einstellungen wird abgebrochen.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  ConfigLaden(eininialt$,1)
  ConfigLaden(eininialt$,2)
  ConfigLaden(eininialt$,3)
  ConfigSpeichern(0)
  InfoM(Datum(stbartyp),stbartyp) ; wegen UTC-MEZ
  SetMenuItemState(0,86,starthilfe)
EndProcedure ; ConfigUebernehmen
;
Procedure Schreibschutz(typ)
  If typ=0
    If FileSize(tmpdat$)<>-1
      SetFileAttributes(tmpdat$,#PB_FileSystem_Normal)
    EndIf
    If FileSize(einini$)<>-1
      SetFileAttributes(einini$,#PB_FileSystem_Normal)
    EndIf
  Else
    If FileSize(tmpdat$)<>-1
      SetFileAttributes(tmpdat$,#PB_FileSystem_ReadOnly)
    EndIf
    If FileSize(einini$)<>-1
      SetFileAttributes(einini$,#PB_FileSystem_ReadOnly)
    EndIf
  EndIf
EndProcedure ; Schreibschutz
;
Procedure ZustandSpeichern()
  tit$="Zustand speichern"
  temp.d=startzeit.d+zeit.d
  templb=Int(temp.d)
  If (templb<0) Or (templb>2145916800) Or (templb=#fehll)
    txt$="Zustnde fr das Jahr "+Jahr(temp.d)+" knnen nicht gespeichert werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  zunum=0
  Repeat
    zunum+1
    txt1$=appdat$+"Zustand "+Str(zunum)+".ini"
  Until FileSize(txt1$)=-1
  txt0$="Soll der Zustand der eingegebenen Krper in    "
  txt0$+Chr(13)
  txt0$+"der Datei Zustand "
  txt0$+Str(zunum)
  txt0$+".ini gespeichert werden?    "
  res=MessageRequester(tit$,txt0$,#PB_MessageRequester_YesNo|#MB_ICONQUESTION|#MB_DEFBUTTON2)
  If res=#PB_MessageRequester_No
    ProcedureReturn
  EndIf
  If CreatePreferences(txt1$)
    WritePreferenceString("Datei","Zustand "+Str(zunum))
    WritePreferenceString("Version",version$)
    WritePreferenceString("Datum",Datum(6))
    WritePreferenceDouble("zeit",temp.d)
    WritePreferenceDouble("stopzeit",stopzeit.d)
    WritePreferenceDouble("stopzeitvor",stopzeitalt.d)
    WritePreferenceLong("koerperzahl",kp)
    WritePreferenceLong("kkk",KKK)
    If Btst(4,QQQ)
      sys$="baryzentrisch"
    ElseIf Btst(5,QQQ)
      sys$="geozentrisch"
    EndIf
    WritePreferenceString("system",sys$)
    WritePreferenceLong("bildbreite",brttmp)
    For k=1 To 20
      If kpr(k)>0
        WritePreferenceLong("kpr"+Str(k),kpr(k))
      EndIf
    Next k
    PreferenceComment("")
    For k=1 To kp
      WritePreferenceString("name"+Str(k),name$(k))
      WritePreferenceLong("spritenummer"+Str(k),spritenum(k))
      WritePreferenceDouble("m"+Str(k),m.d(k))
      WritePreferenceDouble("sx"+Str(k),sx.d(k))
      WritePreferenceDouble("sy"+Str(k),sy.d(k))
      WritePreferenceDouble("sz"+Str(k),sz.d(k))
      WritePreferenceDouble("vx"+Str(k),vx.d(k))
      WritePreferenceDouble("vy"+Str(k),vy.d(k))
      WritePreferenceDouble("vz"+Str(k),vz.d(k))
    Next k
    ClosePreferences()
  Else
    tit$="Dateifehler"
    txt$="Die Datei Zustand "
    txt$+Str(zunum)
    txt$+".ini konnte nicht geschrieben werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
  EndIf
EndProcedure ; ZustandSpeichern
;
Procedure ZustandLaden()
  tit$="Zustand laden"
  zustand$=OpenFileRequester(tit$,appdat$+"Zustand*.ini","Zustandsdateien|Zustand*.ini",0)
  fp$=GetFilePart(zustand$)
  If zustand$=""
    ProcedureReturn
  ElseIf GetExtensionPart(zustand$)<>"ini"
    txt$="Eine Zustandsdatei muss die Dateiendung ini haben.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  ElseIf FileSize(zustand$)=-1
    txt$="Eine Zustandsdatei "+GetFilePart(zustand$)+" existiert nicht.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  If OpenPreferences(zustand$)
    ver$=ReadPreferenceString("Version","0")
    If Val(Left(RemoveString(ver$,"."),2))<#obsolet_zustand
      txt$="Die Datei "+fp$+" kann mit "+programmtitel$+" nicht mehr geladen werden.    "
      MessageRequester(tit$,txt$,#MB_ICONSTOP)
      ClosePreferences()
      ProcedureReturn
    EndIf
    datum$=ReadPreferenceString("Datum","")
    tit$=RemoveString(fp$,".ini")
    tit$+" laden?"
    kk=ReadPreferenceLong("koerperzahl",0)
    txt$+"Datum: "
    txt$+datum$+Space(4)+Chr(13)
    txt$+"Krper: "
    For k=1 To kk
      namezst$(k)=ReadPreferenceString("name"+Str(k),"")
      If k=1
        namezst$(k)
      EndIf
      txt$+namezst$(k)+Space(2)
    Next k
    txt$+Space(4)
    res=MessageRequester(tit$,txt$,#MB_YESNO|#MB_ICONQUESTION|#MB_DEFBUTTON2)
    If res=#PB_MessageRequester_No
      ClosePreferences()
      ProcedureReturn
    EndIf
    ;
    zustandszeit.d=ReadPreferenceDouble("zeit",0)
    stopzeit.d=ReadPreferenceDouble("stopzeit",0)
    stopzeitvor.d=ReadPreferenceDouble("stopzeitvor",0)
    kp=kk
    KKK=ReadPreferenceLong("kkk",0)
    sys$=ReadPreferenceString("system","baryzentrisch")
    brtmp=ReadPreferenceLong("bildbreite",0)
    For k=1 To 20
      kpr(k)=ReadPreferenceLong("kpr"+Str(k),0)
    Next k
    For i=1 To 30
      For j=1 To 20
        If kpr(j)=i
          pos(i)=j
        EndIf
      Next j
    Next i
    For k=1 To kp
      name$(k)=ReadPreferenceString("name"+Str(k),"")
      spritenum(k)=ReadPreferenceLong("spritenummer"+Str(k),0)
      sx.d(k)=ReadPreferenceDouble("sx"+Str(k),0)
      sy.d(k)=ReadPreferenceDouble("sy"+Str(k),0)
      sz.d(k)=ReadPreferenceDouble("sz"+Str(k),0)
      vx.d(k)=ReadPreferenceDouble("vx"+Str(k),0)
      vy.d(k)=ReadPreferenceDouble("vy"+Str(k),0)
      vz.d(k)=ReadPreferenceDouble("vz"+Str(k),0)
      m.d(k)=ReadPreferenceDouble("m"+Str(k),0)
    Next k
    ClosePreferences()
  Else
    tit$="Dateifehler"
    txt$="Die Datei "+fp$+" konnte nicht geffnet werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  ;
  BildBrt(brtmp)
  If sys$="geozentrisch"
    QQQ=Bset(5,QQQ)
    BezugBild(4)
  Else
    QQQ=Bset(4,QQQ)
  EndIf
  zeit.d=zustandszeit.d-startzeit.d
  If Btst(5,QQQ)
    phi.d=omega.d*zeit.d
    sx.d(21)=Sin(phi.d)*radius.d(24)
    sy.d(21)=Cos(phi.d)*radius.d(24)
    sz.d(21)=0
  EndIf
  For k=1 To kp
    If k<10
      spc=2
    Else
      spc=0
    EndIf
    AddGadgetItem(2,-1,Space(spc)+Str(k)+" :  "+name$(k))
    Zustand(0,k)
  Next k
  AddKeyboardShortcut(0,#PB_Shortcut_F5,40)
  InfoM(Datum(2),2)
EndProcedure ; ZustandLaden
;
Procedure StartdateiAusw()
  tit$="Startdatei auswhlen"
  inineu$=OpenFileRequester(tit$,pfad$+"Daten*.ini","Startdateien|Daten*.ini",0)
  fp$=GetFilePart(inineu$)
  If inineu$=""
    ProcedureReturn
  ElseIf inidat$=fp$
    txt$="Die Startdatei "+fp$+" wird bereits verwendet.    "
    MessageRequester(tit$,txt$,#MB_ICONINFORMATION)
    ProcedureReturn
  ElseIf GetExtensionPart(inineu$)<>"ini"
    txt$="Eine Startdatei muss die Dateiendung ini haben.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  ElseIf FileSize(inineu$)=-1
    txt$="Eine Startdatei "+GetFilePart(inineu$)+" existiert nicht.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  inidat$=fp$
  DatenLaden(0)
  If inidat$=neudat$
    startzeit.d=UTC()
  Else
    startzeit.d=startdateizeit
  EndIf
  stopzeit.d=startzeit.d
  stopzeitalt.d=startzeit.d
  SetGadgetText(27,Datum(3))
  BahnrechnungA(1)
EndProcedure ; StartdateiAusw
;
Procedure StartdateiErzg()
  tit$="csv-Datei auswhlen"
  quelle$=OpenFileRequester(tit$,"*.csv","csv-Dateien|*.csv",0)
  If quelle$=""
    ProcedureReturn
  EndIf
  ;
  If ReadFile(0,quelle$)
    For i=0 To 11
      zeile$=ReadString(0)
      If i=0
        jjjj$=Mid(zeile$,1,4)
        mmmm$=Mid(zeile$,6,2)
        dddd$=Mid(zeile$,9,2)
        hhhh$=Mid(zeile$,12,2)
        iiii$=Mid(zeile$,15,2)
        ssss$=Mid(zeile$,18,2)
      EndIf
      If i=1 And Left(zeile$,5)<>"Sonne"
        txt$="Die Werte fr die Sonne stehen nicht    "
        txt$+Chr(13)
        txt$+"in der ersten Zeile der csv-Datei.    "
        MessageRequester(tit$,txt$,#MB_ICONSTOP)
        ProcedureReturn
      EndIf
      p=1
      q=1
      For j=1 To 6
        p=FindString(zeile$,";",q)
        q=FindString(zeile$,";",p+1)
        csv$(i,j)=Mid(zeile$,p+1,q-p-1)
        csv$(i,j)=ReplaceString(csv$(i,j),",",".")
        csv$(i,j)=ReplaceString(csv$(i,j),"E","e")
        r=FindString(csv$(i,j),".",1)
        csv$(i,j)=Space(4-r)+csv$(i,j)
      Next j
      If (i>0) And (q>0) And (jed$="")
        jed$=Mid(zeile$,q+1,Len(zeile$)-q)
      EndIf
    Next i
    CloseFile(0)
  Else
    txt$="Die Datei "+fp$+" konnte nicht gelesen werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    ProcedureReturn
  EndIf
  ;
  ziel$=appdat$+"Daten"+jjjj$+mmmm$+dddd$+hhhh$+iiii$+ssss$+".ini"
  tit1$="Gravitation "+version$+" Startdatei"
  tit2$="Aequ. J2000 baryzentrisch"
  zeit1$="Zeitpunkt: "+dddd$+"."+mmmm$+"."+jjjj$+" "+hhhh$+":"+iiii$+":"+ssss$+" UTC"
  If jed$<>""
    zeit1$+" ("+jed$+")"
  EndIf
  zeit2$=jjjj$+"."+mmmm$+"."+dddd$+"."+hhhh$+"."+iiii$+"."+ssss$
  ;
  ; Erzeugung der Startdatei:
  If CreatePreferences(ziel$)
    PreferenceComment(tit1$)
    PreferenceComment(tit2$)
    PreferenceComment(zeit1$)
    WritePreferenceString("zeit",zeit2$)
    PreferenceComment("Sonne:")
    WritePreferenceString("sonmm",Space(2)+datmm$(1))
    WritePreferenceString("sonrr",Space(2)+datrr$(1))
    WritePreferenceString("sonsx",csv$(1,1))
    WritePreferenceString("sonsy",csv$(1,2))
    WritePreferenceString("sonsz",csv$(1,3))
    WritePreferenceString("sonvx",csv$(1,4))
    WritePreferenceString("sonvy",csv$(1,5))
    WritePreferenceString("sonvz",csv$(1,6))
    PreferenceComment("Merkur:")
    WritePreferenceString("mermm",Space(2)+datmm$(2))
    WritePreferenceString("merrr",Space(2)+datrr$(2))
    WritePreferenceString("mersx",csv$(2,1))
    WritePreferenceString("mersy",csv$(2,2))
    WritePreferenceString("mersz",csv$(2,3))
    WritePreferenceString("mervx",csv$(2,4))
    WritePreferenceString("mervy",csv$(2,5))
    WritePreferenceString("mervz",csv$(2,6))
    PreferenceComment("Venus:")
    WritePreferenceString("venmm",Space(2)+datmm$(3))
    WritePreferenceString("venrr",Space(2)+datrr$(3))
    WritePreferenceString("vensx",csv$(3,1))
    WritePreferenceString("vensy",csv$(3,2))
    WritePreferenceString("vensz",csv$(3,3))
    WritePreferenceString("venvx",csv$(3,4))
    WritePreferenceString("venvy",csv$(3,5))
    WritePreferenceString("venvz",csv$(3,6))
    PreferenceComment("Erde:")
    WritePreferenceString("erdmm",Space(2)+datmm$(4))
    WritePreferenceString("erdrr",Space(2)+datrr$(4))
    WritePreferenceString("erdsx",csv$(4,1))
    WritePreferenceString("erdsy",csv$(4,2))
    WritePreferenceString("erdsz",csv$(4,3))
    WritePreferenceString("erdvx",csv$(4,4))
    WritePreferenceString("erdvy",csv$(4,5))
    WritePreferenceString("erdvz",csv$(4,6))
    PreferenceComment("Mars:")
    WritePreferenceString("marmm",Space(2)+datmm$(5))
    WritePreferenceString("marrr",Space(2)+datrr$(5))
    WritePreferenceString("marsx",csv$(5,1))
    WritePreferenceString("marsy",csv$(5,2))
    WritePreferenceString("marsz",csv$(5,3))
    WritePreferenceString("marvx",csv$(5,4))
    WritePreferenceString("marvy",csv$(5,5))
    WritePreferenceString("marvz",csv$(5,6))
    PreferenceComment("Jupiter:")
    WritePreferenceString("jupmm",Space(2)+datmm$(6))
    WritePreferenceString("juprr",Space(2)+datrr$(6))
    WritePreferenceString("jupsx",csv$(6,1))
    WritePreferenceString("jupsy",csv$(6,2))
    WritePreferenceString("jupsz",csv$(6,3))
    WritePreferenceString("jupvx",csv$(6,4))
    WritePreferenceString("jupvy",csv$(6,5))
    WritePreferenceString("jupvz",csv$(6,6))
    PreferenceComment("Saturn:")
    WritePreferenceString("satmm",Space(2)+datmm$(7))
    WritePreferenceString("satrr",Space(2)+datrr$(7))
    WritePreferenceString("satsx",csv$(7,1))
    WritePreferenceString("satsy",csv$(7,2))
    WritePreferenceString("satsz",csv$(7,3))
    WritePreferenceString("satvx",csv$(7,4))
    WritePreferenceString("satvy",csv$(7,5))
    WritePreferenceString("satvz",csv$(7,6))
    PreferenceComment("Uranus:")
    WritePreferenceString("uramm",Space(2)+datmm$(8))
    WritePreferenceString("urarr",Space(2)+datrr$(8))
    WritePreferenceString("urasx",csv$(8,1))
    WritePreferenceString("urasy",csv$(8,2))
    WritePreferenceString("urasz",csv$(8,3))
    WritePreferenceString("uravx",csv$(8,4))
    WritePreferenceString("uravy",csv$(8,5))
    WritePreferenceString("uravz",csv$(8,6))
    PreferenceComment("Neptun:")
    WritePreferenceString("nepmm",Space(2)+datmm$(8))
    WritePreferenceString("neprr",Space(2)+datrr$(9))
    WritePreferenceString("nepsx",csv$(9,1))
    WritePreferenceString("nepsy",csv$(9,2))
    WritePreferenceString("nepsz",csv$(9,3))
    WritePreferenceString("nepvx",csv$(9,4))
    WritePreferenceString("nepvy",csv$(9,5))
    WritePreferenceString("nepvz",csv$(9,6))
    PreferenceComment("Pluto:")
    WritePreferenceString("plumm",Space(2)+datmm$(10))
    WritePreferenceString("plurr",Space(2)+datrr$(10))
    WritePreferenceString("plusx",csv$(10,1))
    WritePreferenceString("plusy",csv$(10,2))
    WritePreferenceString("plusz",csv$(10,3))
    WritePreferenceString("pluvx",csv$(10,4))
    WritePreferenceString("pluvy",csv$(10,5))
    WritePreferenceString("pluvz",csv$(10,6))
    PreferenceComment("Mond:")
    WritePreferenceString("monmm",Space(2)+datmm$(11))
    WritePreferenceString("monrr",Space(2)+datrr$(11))
    WritePreferenceString("monsx",csv$(11,1))
    WritePreferenceString("monsy",csv$(11,2))
    WritePreferenceString("monsz",csv$(11,3))
    WritePreferenceString("monvx",csv$(11,4))
    WritePreferenceString("monvy",csv$(11,5))
    WritePreferenceString("monvz",csv$(11,6))
    ClosePreferences()
    tit$="Startdatei erzeugen"
    txt$="Die Startdatei "+GetFilePart(ziel$)+" wurde erzeugt und in das Anwendungsdatenverzeichnis    "
    txt$+Chr(13)
    txt$+GetPathPart(ziel$)
    txt$+Chr(13)
    txt$+"geschrieben.   "
    MessageRequester(tit$,txt$,#MB_ICONINFORMATION)
  Else
    tit$="Startdatei erzeugen"
    txt$="Die Startdatei "+GetFilePart(ziel$)+" konnte nicht erzeugt werden.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP) 
  EndIf
EndProcedure ; StartdateiErzg
;
Procedure Zeit()
  tzi.TIME_ZONE_INFORMATION
  dlinf=GetTimeZoneInformation_(tzi)
  tzbias=60*tzi\Bias
  temp.d=-tzi\Bias/60
  ta$=StrE(temp.d,2)
  ta$=ReplaceString(ta$,".00","")
  ta$=ReplaceString(ta$,".25",":15")
  ta$=ReplaceString(ta$,".50",":30")
  ta$=ReplaceString(ta$,".75",":45")
  If tzbias<0
    tzadd$="+"+ta$
  ElseIf tzbias>0
    tzadd$=ta$
  Else
    tzadd$=""
  EndIf
  If dlinf=#TIME_ZONE_ID_DAYLIGHT
    dlbias=60*tzi\DaylightBias
  Else
    dlbias=0
  EndIf
  startzeit.d=UTC()
  stopzeit.d=startzeit.d
  stopzeitalt.d=startzeit.d
EndProcedure ; Zeit
;
Procedure Reset(typ)
  Select typ
    Case 0 ; Parameter 1
      temp.d=dtcfg.d
      dtcfg.d=#dtcfg
      If dt.d=temp.d
        dt.d=dtcfg.d
      EndIf
      bahnschritt=#bahnschrittcfg
      bildschritt.d=#bildschrittcfg
      rknschritt=#rknschrittcfg
      ConfigSpeichern(1)
      InfoHilfe(1)
    Case 1 ; Parameter 2
      BildBrt(1)
      dtvar.d=#dtvarcfg
      mondzoom.d=#mondzoomcfg
      fahrint.d=#jahrsid/12
      stellen=#stellencfg
      stellenexp=#stellenexpcfg
      ProjPar()
      InfoHilfe(1)
    Case 2 ; Krperradien
      For k=1 To 30
        radius.d(k)=datrr.d(k)
      Next k
      Kollisionsmatrix()
    Case 3 ; Doppelstern
      dpp.d=#dppcfg
      mstern1.d=datmm.d(19)
      mstern2.d=datmm.d(20)
    Case 4 ; Kollision
      dtkoll.d=#dtkollcfg
      akoll.d=#akollcfg
      Kollisionsmatrix()
      If Btst(5,QQQ)=0
        QQQ=Bclr(24,QQQ)
        SetMenuItemState(0,578,0)
        QQQ=Bclr(26,QQQ)
        SetMenuItemState(0,579,0)
      EndIf
    Case 5 ; Krfte
      gamma.d=#gammacfg
      QQQ=Bclr(30,QQQ)
      fzusatz.d=#fzusatzcfg
      reibpar.d=#reibparcfg
      zusatzdauer.d=#riesig
    Case 6 ; Satelliten
      satfak.d=#satfakcfg
      hohfak.d=#hohfakcfg
    Case 7 ; Speicher
      bahnspeicher=#bahnspeichercfg
      bahnpunkte=bahnspeicher/59-1
      ReDim sxb.d(bahnpunkte)
      ReDim syb.d(bahnpunkte)
      ReDim szb.d(bahnpunkte)
      ReDim fb.b(bahnpunkte)
      ReDim cb.b(bahnpunkte)
      ReDim mb.b(bahnpunkte)
      ReDim sxw.d(bahnpunkte)
      ReDim syw.d(bahnpunkte)
      ReDim szw.d(bahnpunkte)
      ReDim phw.d(bahnpunkte)
      ConfigSpeichern(1)
  EndSelect
  EinstGadget(0,"Einstellungen","")
  If kp>0
    If kpgad>0
       Zustand(0,kpgad)
    Else
       Zustand(0,kp)
    EndIf
  EndIf
EndProcedure ; Reset
;
Procedure Programmende()
  Schreibschutz(1)
  End
EndProcedure ; Programmende
;
;- FENSTER
Procedure FensterAuf()
  tit$="Fehler beim Programmstart"
  txt1$="Das bentigte Programmfenster konnte nicht geffnet werden.    "
  txt2$="Das bentigte Programmfenster konnte nicht korrekt dargestellt werden.    "
  ;
  WinID=OpenWindow(0,0,0,#winspalten,#winzeilen,fenstertitel$,#PB_Window_MinimizeGadget|#PB_Window_ScreenCentered|#PB_Window_Invisible)
  If WinID=0
    MessageRequester(programmtitel$+": "+tit$,txt1$+exit$,#MB_ICONSTOP)
    Programmende()
  EndIf
  If CreateToolBar(0,WinID)=0
    MessageRequester(programmtitel$+": "+tit$,txt2$+exit$,#MB_ICONSTOP)
    Programmende()
  EndIf
  If CreateStatusBar(0,WinID)
    AddStatusBarField(155)
    AddStatusBarField(#winspalten-310)
    AddStatusBarField(155)
    InfoL("")
    InfoM("",0)
    InfoR("")
  Else
    MessageRequester(programmtitel$+": "+tit$,txt2$+exit$,#MB_ICONSTOP)
    Programmende()
  EndIf
  SetForegroundWindow_(WinID)
  ;
  AddKeyboardShortcut(0,#PB_Shortcut_S|#PB_Shortcut_Control,310)
  AddKeyboardShortcut(0,#PB_Shortcut_1|#PB_Shortcut_Control,311)
  AddKeyboardShortcut(0,#PB_Shortcut_2|#PB_Shortcut_Control,312)
  AddKeyboardShortcut(0,#PB_Shortcut_3|#PB_Shortcut_Control,313)
  AddKeyboardShortcut(0,#PB_Shortcut_4|#PB_Shortcut_Control,314)
  AddKeyboardShortcut(0,#PB_Shortcut_5|#PB_Shortcut_Control,315)
  AddKeyboardShortcut(0,#PB_Shortcut_6|#PB_Shortcut_Control,316)
  AddKeyboardShortcut(0,#PB_Shortcut_7|#PB_Shortcut_Control,317)
  AddKeyboardShortcut(0,#PB_Shortcut_8|#PB_Shortcut_Control,318)
  AddKeyboardShortcut(0,#PB_Shortcut_P|#PB_Shortcut_Control,319)
  AddKeyboardShortcut(0,#PB_Shortcut_I|#PB_Shortcut_Control,3190)
  AddKeyboardShortcut(0,#PB_Shortcut_A|#PB_Shortcut_Control,3191)
  AddKeyboardShortcut(0,#PB_Shortcut_M|#PB_Shortcut_Control,3192)
  AddKeyboardShortcut(0,#PB_Shortcut_K|#PB_Shortcut_Control,3193)
  AddKeyboardShortcut(0,#PB_Shortcut_E|#PB_Shortcut_Control,3194)
  AddKeyboardShortcut(0,#PB_Shortcut_D|#PB_Shortcut_Control,3195)
  AddKeyboardShortcut(0,#PB_Shortcut_E|#PB_Shortcut_Alt,320)
  AddKeyboardShortcut(0,#PB_Shortcut_O|#PB_Shortcut_Alt,321)
  AddKeyboardShortcut(0,#PB_Shortcut_A|#PB_Shortcut_Alt,322)
  AddKeyboardShortcut(0,#PB_Shortcut_B|#PB_Shortcut_Alt,3221)
  AddKeyboardShortcut(0,#PB_Shortcut_M|#PB_Shortcut_Alt,323)
  AddKeyboardShortcut(0,#PB_Shortcut_S|#PB_Shortcut_Alt,324)
  AddKeyboardShortcut(0,#PB_Shortcut_P|#PB_Shortcut_Alt,325)
  AddKeyboardShortcut(0,#PB_Shortcut_K|#PB_Shortcut_Alt,326)
  AddKeyboardShortcut(0,#PB_Shortcut_Q|#PB_Shortcut_Alt,327)
  AddKeyboardShortcut(0,#PB_Shortcut_W|#PB_Shortcut_Alt,328)
  AddKeyboardShortcut(0,#PB_Shortcut_F1,85)
  AddKeyboardShortcut(0,#PB_Shortcut_Return,91)
  AddKeyboardShortcut(0,#PB_Shortcut_F12|#PB_Shortcut_Control|#PB_Shortcut_Alt|#PB_Shortcut_Shift,99)
EndProcedure ; FensterAuf
;
;- STEUERUNG
Procedure InitMenuGadget()
  men(0)=CreateMenu(0,WinID)
  If men(0)
    MenuTitle("Datei")
      MenuItem(11,"Startdatei auswhlen...")
      MenuItem(12,"Bilder ffnen...")
      MenuItem(13,"Bilder drucken...")
      MenuItem(14,"Einstellungen bernehmen...")
      MenuItem(15,"Pfade anzeigen")
      MenuItem(16,"Startdatei erzeugen...")
      MenuBar()
      MenuItem(19,"Beenden")
    MenuTitle("Eingabe")
      OpenSubMenu("Sonnensystem")
        MenuItem(310,"Sonne"+Chr(9)+"Strg+S")
        MenuBar()
        MenuItem(311,"Merkur"+Chr(9)+"Strg+1")
        MenuItem(312,"Venus"+Chr(9)+"Strg+2")
        MenuItem(313,"Erde"+Chr(9)+"Strg+3")
        MenuItem(314,"Mars"+Chr(9)+"Strg+4")
        MenuItem(315,"Jupiter"+Chr(9)+"Strg+5")
        MenuItem(316,"Saturn"+Chr(9)+"Strg+6")
        MenuItem(317,"Uranus"+Chr(9)+"Strg+7")
        MenuItem(318,"Neptun"+Chr(9)+"Strg+8")
        MenuBar()
        MenuItem(3190,"Innere Planeten"+Chr(9)+"Strg+I")
        MenuItem(3191,"uere Planeten"+Chr(9)+"Strg+A")
        MenuBar()
        MenuItem(319,"Pluto"+Chr(9)+"Strg+P")
        MenuItem(3192,"Mond"+Chr(9)+"Strg+M")
        MenuBar()
        MenuItem(3193,"Krper A - G"+Chr(9)+"Strg+K")
        MenuItem(3194,"Krper A - G (Ekl)"+Chr(9)+"Strg+E")
        MenuBar()
        MenuItem(3195,"Doppelstern"+Chr(9)+"Strg+D")
      CloseSubMenu()
      OpenSubMenu("Erdsystem")
        MenuItem(320,"Erde"+Chr(9)+"Alt+E")
        MenuItem(321,"Erdoberflche"+Chr(9)+"Alt+O")
        MenuItem(322,"Laborsystem gro"+Chr(9)+"Alt+A")
        MenuItem(3221,"Laborsystem klein"+Chr(9)+"Alt+B")
        MenuBar()
        MenuItem(323,"Mond"+Chr(9)+"Alt+M")
        MenuItem(324,"Satellit S1 - S3 (qu)"+Chr(9)+"Alt+S")
        MenuItem(325,"Satellit S1 - S3 (Pol)"+Chr(9)+"Alt+P")
        MenuItem(326,"Krper A - G"+Chr(9)+"Alt+K")
        MenuItem(327,"Krper A - G (qu)"+Chr(9)+"Alt+Q")
        MenuItem(328,"Krper W1 - W2"+Chr(9)+"Alt+W")
      CloseSubMenu()
      MenuBar()
      OpenSubMenu("Lagrange")
        OpenSubMenu("Lagrangepunkte anzeigen")
          MenuItem(65,"Sonne - Merkur")
          MenuItem(66,"Sonne - Venus")
          MenuItem(67,"Sonne - Erde")
          MenuItem(68,"Sonne - Mars")
          MenuItem(69,"Sonne - Jupiter")
          MenuItem(70,"Sonne - Saturn")
          MenuItem(71,"Sonne - Uranus")
          MenuItem(72,"Sonne - Neptun")
          MenuItem(73,"Sonne - Pluto")
          MenuItem(74,"Erde - Mond")
          MenuItem(75,"Stern 1 - Stern 2")
          MenuBar()
          MenuItem(76,"Keine")
        CloseSubMenu()
        OpenSubMenu("Krper in Lagrangepunkt")
          MenuItem(341,"L1")
          MenuItem(342,"L2")
          MenuItem(343,"L3")
          MenuItem(344,"L4")
          MenuItem(345,"L5")
          MenuBar()
          MenuItem(346,"Alle")
        CloseSubMenu()
      CloseSubMenu()
      OpenSubMenu("Zusatzkraft")
        MenuItem(770,"F = 0")
        SetMenuItemState(0,770,1)
        MenuItem(771,"F const")
        MenuItem(772,"F ~ v")
        MenuItem(773,"F ~ v"+Chr(178))
      CloseSubMenu()
    MenuTitle("Einstellungen")
      OpenSubMenu("Geometrie")
        MenuItem(21,"Bildgeometrie...")
        MenuItem(22,"Druckgeometrie...")
        MenuBar()
        MenuItem(23,"Druckgeometrie verwenden ?")
        MenuItem(24,"Synchronisation ausschalten ?")
        SetMenuItemState(0,24,#PB_Screen_SmartSynchronization-vblsync)
      CloseSubMenu()
      OpenSubMenu("Speicher")
        MenuItem(27,"Voreinstellung")
        MenuBar()
        MenuItem(28,"Bahnspeicher...")
        MenuItem(29,"Speicherinformationen")
      CloseSubMenu()
      OpenSubMenu("Zeit")
        If tzbias=#mezbias
          tz$="(MEZ)"
        Else
          tz$="(UTC"+tzadd$+")"
        EndIf
        MenuItem(30,"Lokale Zeit "+tz$+" anzeigen ?")
        MenuItem(31,"Zeitanzeige korrigieren...")
      CloseSubMenu()
      MenuBar()
      OpenSubMenu("Parameter 1")
        MenuItem(505,"Voreinstellung")
        MenuBar()
        MenuItem(506,"Standard-Zeitschritt...")
        MenuItem(507,"Schrittweite Bahn...")
        MenuItem(508,"Schrittweite Bild...")
        MenuItem(509,"Schrittweite Rekonstruktion...")
      CloseSubMenu()
      OpenSubMenu("Parameter 2")
        MenuItem(510,"Voreinstellung")
        MenuBar()
        MenuItem(520,"Bildbreite...")
        MenuItem(521,"Variabler Zeitschritt...")
        MenuItem(522,"Zoomfaktor Mondbahn...")
        MenuItem(523,"Fahrstrahlintervall...")
        MenuItem(527,"Nachkommastellen Normaldarstellung...")
        MenuItem(528,"Nachkommastellen Exponentialdarstellung...")
      CloseSubMenu()
      OpenSubMenu("Farben")
        MenuItem(530,"Voreinstellung")
        MenuItem(531,"Einstellung speichern")
        MenuItem(532,"Einstellung laden")
        MenuBar()
        MenuItem(5330,"Ausgewhlter Krper...")
        MenuBar()
        MenuItem(5331,"Hintergrund...")
        MenuItem(5332,"Bahn...")
        MenuItem(5333,"Fahrstrahl...")
        MenuItem(5334,"Schwerpunkt...")
        MenuItem(5335,"Achsen...")
        MenuItem(5336,"Text...")
        MenuItem(5337,"Bahn (Hohmannbergang)...")
        MenuItem(5338,"Lagrangepunkte...")
        MenuItem(5339,"quatormarke...")
        MenuItem(5340,"Eingabezeile...")
      CloseSubMenu()
      OpenSubMenu("Bilderradien")
        MenuItem(540,"Voreinstellung Radien")
        MenuItem(541,"Einstellung speichern")
        MenuItem(542,"Einstellung laden")
        MenuBar()
        MenuItem(543,"Ausgewhlter Krper...")
        MenuBar()
        MenuItem(544,"Voreinstellung Zoomfaktor")
        MenuItem(545,"Zoomfaktor...")
      CloseSubMenu()
      MenuBar()
      OpenSubMenu("Krfte")
        MenuItem(555,"Voreinstellung")
        MenuBar()
        MenuItem(556,"Gravitationskonstante...")
        OpenSubMenu("Zusatzkraft")
          MenuItem(525,"F const...")
          MenuItem(526,"F ~ v , v"+Chr(178)+"...")
          MenuItem(777,"Dauer...")
        CloseSubMenu()
      CloseSubMenu()
      OpenSubMenu("Krperradien")
        MenuItem(561,"Voreinstellung")
        MenuBar()
        MenuItem(562,"Ausgewhlter Krper...")
      CloseSubMenu()
      OpenSubMenu("Satelliten")
        MenuItem(565,"Voreinstellung")
        MenuBar()
        MenuItem(566,"Bahnradius...")
        MenuItem(524,"Hohmannfaktor...")
      CloseSubMenu()
      OpenSubMenu("Doppelstern")
        MenuItem(570,"Voreinstellung")
        MenuBar()
        MenuItem(571,"Abstand...")
        MenuItem(572,"Masse Stern 1...")
        MenuItem(573,"Masse Stern 2...")
      CloseSubMenu()
      OpenSubMenu("Kollisionen")
        MenuItem(575,"Voreinstellung")
        MenuBar()
        MenuItem(576,"Grenzbeschleunigung...")
        MenuItem(577,"Reduzierter Zeitschritt...")
        MenuBar()
        MenuItem(578,"Kollidierte Krper entfernen ?")
        MenuItem(579,"Zeitschrittreduzierung ausschalten ?")
      CloseSubMenu()
      MenuBar()
      OpenSubMenu("Start")
        MenuItem(501,"Startzeit...")
        MenuItem(502,"Temporre Startdatei neu berechnen")
      CloseSubMenu()
    MenuTitle("Hilfe")
      MenuItem(85,"Handbuch ffnen..."+Chr(9)+"F1")
      MenuItem(86,"Hilfe beim Programmstart eingeschaltet ?")
      SetMenuItemState(0,86,starthilfe)
      MenuItem(87,"Info ber "+programmtitel$)
  Else
    txt$="Das Men konnte nicht initialisiert werden.    "+exit$
    MessageRequester(programmtitel$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  ;
  men(1)=CreateMenu(1,WinID)
  If men(1)
    MenuTitle("Koordinatenaktualisierung luft - bitte warten!")
    MenuItem(1,"Koordinatenaktualisierung abbrechen")
  Else
    txt$="Das Men konnte nicht initialisiert werden.    "+exit$
    MessageRequester(programmtitel$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
  ;
  SetMenu_(WinID,men(0))
  ;
  If CreateGadgetList(WinID)
    ContainerGadget(700,4,2,#winspalten-4,#winzeilen-48)
      Frame3DGadget(1,10,10,140,420,"Eingegebene Krper")
      ListViewGadget(2,20,30,120,290)
      Frame3DGadget(3,170,10,300,370,"Zustand")
      TextGadget(4,180,30,100,20,"Ortskoordinaten in m:")
      TextGadget(5,180,55,30,20,"x = ",#PB_Text_Right)
      StringGadget(6,215,53,240,18,"")
      TextGadget(7,180,80,30,20,"y = ",#PB_Text_Right)
      StringGadget(8,215,78,240,18,"")
      TextGadget(9,180,105,30,20,"z = ",#PB_Text_Right)
      StringGadget(10,215,103,240,18,"")
      TextGadget(11,180,130,240,20,"Geschwindigkeitskomponenten in m/s:")
      TextGadget(12,180,155,30,20,"vx = ",#PB_Text_Right)
      StringGadget(13,215,153,240,18,"")
      TextGadget(14,180,180,30,20,"vy = ",#PB_Text_Right)
      StringGadget(15,215,178,240,18,"")
      TextGadget(16,180,205,30,20,"vz = ",#PB_Text_Right)
      StringGadget(17,215,203,240,18,"")
      TextGadget(18,180,230,100,20,"Masse in kg:")
      TextGadget(19,180,255,30,20,"m = ",#PB_Text_Right)
      StringGadget(20,215,253,240,18,"")
      ButtonGadget(22,20,333,120,25,"Anzeigen  ( F5 )",#PB_Button_Default)
      ButtonGadget(23,20,365,120,25,"Entfernen",#PB_Button_Default)
      ButtonGadget(24,20,397,120,25,"Alle entfernen",#PB_Button_Default)
      Frame3DGadget(26,670,10,160,38,"Startdateizeit")
      TextGadget(27,678,26,144,17,Datum(3),#PB_Text_Center)
      Frame3DGadget(28,670,50,160,38,"Startzeit")
      TextGadget(29,678,66,144,17,Datum(4),#PB_Text_Center)
      ContainerGadget(702,665,90,170,105)
        Frame3DGadget(30,5,0,160,100,"Bezugspunkt Bild")
        OptionGadget(31,25,15,120,20," Nullpunkt")
        OptionGadget(32,25,35,120,20," Sonne")
        OptionGadget(33,25,55,120,20," Erde")
        OptionGadget(34,25,75,120,20," Schwerpunkt")
      CloseGadgetList() ; 702
      ContainerGadget(703,480,255,180,130)
        Frame3DGadget(40,10,4,160,120,"Blickrichtung")
        OptionGadget(41,30,19,130,20," Ekliptikebene")
        OptionGadget(42,30,39,130,20," x - Richtung")
        OptionGadget(43,30,59,130,20," y - Richtung")
        OptionGadget(44,30,79,130,20," z - Richtung")
        OptionGadget(45,30,99,130,20," schrg")
      CloseGadgetList() ; 703
      ContainerGadget(704,480,5,180,250)
        Frame3DGadget(50,10,5,160,240,"Anzeigen")
        CheckBoxGadget(51,30,20,120,20," Bahnen")
        CheckBoxGadget(52,30,180,120,20," Geschwindigkeit")
        CheckBoxGadget(53,30,60,130,20," Schwerpunkt")
        CheckBoxGadget(54,30,40,130,20," Fahrstrahlen")
        CheckBoxGadget(55,30,200,120,20," Hilfe")
        CheckBoxGadget(56,30,160,120,20," Namen")
        CheckBoxGadget(57,30,80,120,20," Achsen")
        CheckBoxGadget(58,30,100,120,20," Bildbreite")
        CheckBoxGadget(59,30,120,120,20," Zeit")
        CheckBoxGadget(590,30,140,120,20," Zeitschritt")
        CheckBoxGadget(591,30,220,120,20," Schwarzweibild")
      CloseGadgetList() ; 704
      ContainerGadget(705,665,195,170,190)
        Frame3DGadget(60,5,5,160,179,"Bildbreite ("+StrDD(breite.d,1)+" AE)")
        OptionGadget(61,25,20,120,20," Merkurbahn")
        OptionGadget(62,25,40,120,20," Erdbahn")
        OptionGadget(63,25,60,120,20," Marsbahn")
        OptionGadget(64,25,80,120,20," Jupiterbahn")
        OptionGadget(65,25,100,120,20," Neptunbahn")
        OptionGadget(66,25,120,120,20," Mondbahn")
        OptionGadget(67,25,140,120,20," Satellitenbahn")
        OptionGadget(68,25,160,120,20," Geostationre Bahn")
      CloseGadgetList() ; 705
      ContainerGadget(706,665,195,170,190)
        Frame3DGadget(70,5,5,160,179,"Erdoberflche")
        ContainerGadget(707,10,22,150,55)
          TextGadget(71,10,0,140,20,"Erdrotation:")
          OptionGadget(72,15,15,120,20,"Erde rotiert")
          OptionGadget(73,15,35,120,20,"Erde rotiert nicht")
        CloseGadgetList() ; 707
        ContainerGadget(708,10,82,150,55)
          TextGadget(74,10,0,140,20,"Bezugssystem:")
          OptionGadget(75,15,15,120,20,"Koordinatensystem")
          OptionGadget(76,15,35,120,20,"Erdoberflche")
        CloseGadgetList() ; 708
        ContainerGadget(709,10,142,150,35)
          TextGadget(90,10,0,140,20,"Gravitationsfeld:")
          OptionGadget(91,15,15,45,20,"Erde")
          OptionGadget(92,63,15,45,20,"Mond")
          OptionGadget(93,111,15,45,20,"Null")
        CloseGadgetList() ; 709
      CloseGadgetList() ; 706
      ContainerGadget(710,480,390,355,45)
        Frame3DGadget(80,11,0,340,40,"Zeitschritt")
        OptionGadget(81,18,15,36,20,"Var")
        OptionGadget(82,56,15,50,20,"0,1 ms")
        OptionGadget(83,107,15,42,20,"1 ms")
        OptionGadget(84,150,15,48,20,"10 ms")
        OptionGadget(85,198,15,34,20,"1 s")
        OptionGadget(86,232,15,45,20,"1 min")
        OptionGadget(87,277,15,36,20,"1 h")
        OptionGadget(88,313,15,36,20,"Std")
      CloseGadgetList() ; 710
      ProgressBarGadget(120,10,#winzeilen-66,#winspalten-28,12,0,100)
      ButtonGadget(101,215,285,110,25,"bernehmen",#PB_Button_Default)
      ButtonGadget(102,345,285,110,25,"Rckgngig",#PB_Button_Default)
      ButtonGadget(103,215,315,110,25,"Bahnradius",#PB_Button_Default)
      ButtonGadget(104,345,315,110,25,"Geschwindigkeit",#PB_Button_Default)
      ButtonGadget(105,215,345,110,25,"Zustand speichern",#PB_Button_Default)
      ButtonGadget(106,345,345,110,25,"Zustand laden",#PB_Button_Default)
      Frame3DGadget(110,170,390,300,40,"Einstellungen")
      StringGadget(111,180,406,120,18,"")
      SetGadgetColor(111,#PB_Gadget_BackColor,farbe(38))
      ButtonGadget(112,310,405,72,20,"bernehmen")
      ButtonGadget(113,390,405,72,20,"Abbrechen")
    CloseGadgetList(); 700
    ;
    InfoHilfe(1)
    InfoHilfe(4)
  Else
    txt$="Die Gadgets konnten nicht initialisiert werden.    "+exit$
    MessageRequester(programmtitel$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
EndProcedure ; InitMenuGadget
;
Procedure CtrlMenuGadget()
  If kpgad=0
    DisableMenuItem(0,5330,1)
    DisableMenuItem(0,543,1)
    DisableMenuItem(0,562,1)
    For i=770 To 773
      DisableMenuItem(0,i,1)
    Next i
    DisableGadget(6,1)
    DisableGadget(8,1)
    DisableGadget(10,1)
    DisableGadget(13,1)
    DisableGadget(15,1)
    DisableGadget(17,1)
    DisableGadget(20,1)
    SetGadgetText(23,"Entfernen")
    DisableGadget(23,1)
    DisableGadget(101,1)
    DisableGadget(103,1)
    DisableGadget(104,1)
  Else
    DisableMenuItem(0,5330,Btst(19,QQQ))
    DisableMenuItem(0,543,0)
    If (kpgad=pos(4)) Or (kpgad=pos(24)) Or (kpgad=pos(29)) Or (kpgad=pos(30))
      DisableMenuItem(0,562,1)
    Else
      DisableMenuItem(0,562,0)
    EndIf
    For i=770 To 773
      DisableMenuItem(0,i,0)
    Next i
    If (kpgad<2) And (Btst(5,QQQ)=1)
      DisableGadget(6,1)
      DisableGadget(8,1)
      DisableGadget(10,1)
      DisableGadget(13,1)
      DisableGadget(15,1)
      DisableGadget(17,1)
      DisableGadget(103,1)
      DisableGadget(104,1)
    Else
      DisableGadget(6,eingad)
      DisableGadget(8,eingad)
      DisableGadget(10,eingad)
      DisableGadget(13,eingad)
      DisableGadget(15,eingad)
      DisableGadget(17,eingad)
      DisableGadget(103,eingad)
      DisableGadget(104,eingad)
    EndIf
    DisableGadget(20,eingad)
    SetGadgetText(23,name$(kpgad)+" entfernen")
    DisableGadget(23,eingad)
    DisableGadget(101,eingad)
    If eingad
      DisableGadget(102,1)
    EndIf
  EndIf
  ;
  If kp=0
    DisableMenuItem(0,11,0)
    If eininialt$=""
      DisableMenuItem(0,14,1)
    Else
      DisableMenuItem(0,14,0)
    EndIf
    DisableMenuItem(0,21,0)
    DisableMenuItem(0,22,0)
    DisableMenuItem(0,27,0)
    DisableMenuItem(0,28,0)
    DisableMenuItem(0,29,0)
    DisableMenuItem(0,31,0)
    For i=310 To 319
      DisableMenuItem(0,i,0)
    Next i
    For i=3190 To 3195
      DisableMenuItem(0,i,0)
    Next i
    DisableMenuItem(0,320,0)
    DisableMenuItem(0,321,0)
    DisableMenuItem(0,322,0)
    DisableMenuItem(0,3221,0)
    For i=323 To 328
      DisableMenuItem(0,i,1)
    Next i
    For i=341 To 346
      DisableMenuItem(0,i,1)
    Next i
    If inidat$=neudat$
      DisableMenuItem(0,502,0)
    Else
      DisableMenuItem(0,502,1)
    EndIf
    DisableMenuItem(0,520,0)
    DisableMenuItem(0,578,0)
    DisableMenuItem(0,579,0)
    SetMenuItemState(0,579,0)
    For i=65 To 76
      DisableMenuItem(0,i,1)
    Next i
    DisableGadget(22,1)
    DisableGadget(24,1)
    SetGadgetState(31,1)
    For i=1 To 4
      DisableGadget(30+i,1)
      bgad(i)=1
    Next i
    If blick=1
      SetGadgetState(41,1)
    EndIf
    For i=41 To 45
      DisableGadget(i,0)
    Next i
    For i=61 To 68
      DisableGadget(i,1)
    Next i
    SetGadgetState(72,1)
    DisableGadget(72,0)
    DisableGadget(73,0)
    SetGadgetState(75,1)
    DisableGadget(75,0)
    DisableGadget(76,0)
    If dt.d=dtcfg.d
      SetGadgetState(88,1)
    EndIf
    SetGadgetState(91,1)
    DisableGadget(91,1)
    DisableGadget(92,1)
    DisableGadget(93,1)
    For i=101 To 105
      DisableGadget(i,1)
    Next i
    If (inidat$=neudat$) And (FileSize(appdat$+"Zustand*.ini")<>-1)
      DisableGadget(106,0)
    Else
      DisableGadget(106,1)
    EndIf
  Else
    DisableMenuItem(0,11,1)
    DisableMenuItem(0,14,1)
    DisableMenuItem(0,21,1)
    DisableMenuItem(0,22,1)
    DisableMenuItem(0,27,1)
    DisableMenuItem(0,28,1)
    DisableMenuItem(0,31,1)
    DisableMenuItem(0,502,1)
    ;
    If Btst(28,QQQ)
      If BtstI(12,18,KKK)=7
        For i=341 To 346
          DisableMenuItem(0,i,1)
        Next i
      ElseIf BtstI(12,18,KKK)>2
        For i=341 To 345
          DisableMenuItem(0,i,0)
        Next i
        DisableMenuItem(0,346,1)
      Else
        For i=341 To 346
          DisableMenuItem(0,i,0)
        Next i
      EndIf
    Else
      For i=341 To 346
        DisableMenuItem(0,i,1)
      Next i
    EndIf
    ;
    If Btst(4,QQQ)
      For i=1 To 10
        DisableMenuItem(0,309+i,Btst(i,KKK))
      Next i
      If BtstI(2,5,KKK)=0
        DisableMenuItem(0,3190,0)
      Else
        DisableMenuItem(0,3190,1)
      EndIf
      If BtstI(6,9,KKK)=0
        DisableMenuItem(0,3191,0)
      Else
        DisableMenuItem(0,3191,1)
      EndIf
      If diffstartstop.d<60
        DisableMenuItem(0,3192,Btst(11,KKK))
      EndIf
      If BtstI(12,18,KKK)=7
        DisableMenuItem(0,3193,1)
        DisableMenuItem(0,3194,1)
      Else
        DisableMenuItem(0,3193,0)
        DisableMenuItem(0,3194,0)
      EndIf
      If BtstI(19,20,KKK)
        DisableMenuItem(0,3195,1)
      Else
        DisableMenuItem(0,3195,0)
      EndIf
      For i=320 To 328
        DisableMenuItem(0,i,1)
      Next i
      DisableMenuItem(0,3221,1)
      DisableGadget(31,0)
      bgad(1)=0
      If Btst(1,KKK)
        DisableGadget(32,0)
        bgad(2)=0
      Else
        DisableGadget(32,1)
        bgad(2)=1
      EndIf
      If Btst(4,KKK)
        DisableGadget(33,0)
        bgad(3)=0
      Else
        DisableGadget(33,1)
        bgad(3)=1
      EndIf
      DisableGadget(34,0)
      bgad(4)=0
      For i=61 To 65
        DisableGadget(i,0)
      Next i
    ElseIf Btst(5,QQQ)
      If Btst(24,KKK)
        DisableMenuItem(0,320,1)
        DisableMenuItem(0,321,1)
        DisableMenuItem(0,322,1)
        DisableMenuItem(0,3221,1)
        DisableMenuItem(0,328,Btst(29,KKK)*Btst(30,KKK))
        DisableGadget(66,0)
        DisableGadget(67,0)
        DisableGadget(68,0)
        If Btst(23,QQQ)
          DisableGadget(72,1)
          DisableGadget(73,1)
          DisableGadget(75,1)
          DisableGadget(76,1)
          DisableGadget(91,0)
          DisableGadget(92,0)
          DisableGadget(93,0)
        ElseIf BtstI(29,30,KKK)=0
          DisableGadget(72,0)
          DisableGadget(73,0)
          DisableGadget(75,rtstp)
          DisableGadget(76,rtstp)
        Else
          DisableGadget(72,1)
          DisableGadget(73,1)
          DisableGadget(75,1)
          DisableGadget(76,1)
        EndIf
        If BtstI(22,23,QQQ)
          For i=323 To 327
            DisableMenuItem(0,i,1)
          Next i
          DisableMenuItem(0,520,1)
          For i=1 To 4
            DisableGadget(30+i,1)
            bgad(i)=1
          Next i
          For i=41 To 45
            DisableGadget(i,1)
          Next i
        Else
          DisableMenuItem(0,323,Btst(25,KKK))
          If BtstI(26,28,KKK)<3
            DisableMenuItem(0,324,0)
            DisableMenuItem(0,325,0)
          Else
            DisableMenuItem(0,324,1)
            DisableMenuItem(0,325,1)
          EndIf
          If BtstI(12,18,KKK)=7
            DisableMenuItem(0,326,1)
            DisableMenuItem(0,327,1)
          Else
            DisableMenuItem(0,326,0)
            DisableMenuItem(0,327,0)
          EndIf
          DisableGadget(31,1)
          bgad(1)=1
          DisableGadget(32,1)
          bgad(2)=1
          DisableGadget(33,0)
          bgad(3)=0
          DisableGadget(34,0)
          bgad(4)=0
        EndIf
        If kpgad=pos(24)
          If BtstI(12,18,KKK)+BtstI(25,30,KKK)>0
              DisableGadget(23,1)
          EndIf
          If gravob
            DisableGadget(20,1)
            DisableGadget(101,1)
            DisableGadget(102,1)
          EndIf
        EndIf
        If ((kpgad=pos(29)) Or (kpgad=pos(30))) And BtstI(22,23,QQQ)
          DisableGadget(10,1)
          DisableGadget(17,1)
        EndIf
      Else
        DisableMenuItem(0,320,0)
        DisableMenuItem(0,321,0)
        DisableMenuItem(0,322,0)
        DisableMenuItem(0,3221,0)
        For i=323 To 328
          DisableMenuItem(0,i,1)
        Next i
      EndIf
      For i=310 To 319
        DisableMenuItem(0,i,1)
      Next i
      For i=3190 To 3195
        DisableMenuItem(0,i,1)
      Next i
      SetMenuItemState(0,578,0)
      DisableMenuItem(0,578,1)
      SetMenuItemState(0,579,1)
      DisableMenuItem(0,579,1)
    EndIf
    ;
    DisableGadget(2,eingad)
    DisableGadget(22,eingad)
    DisableGadget(24,eingad)
    If (inidat$=neudat$) And (BtstI(22,23,QQQ)=0)
      DisableGadget(105,eingad)
    EndIf
    DisableGadget(106,1)
  EndIf
  ;
  SetMenuItemState(0,30,lokal)
  For i=2 To 10
    DisableMenuItem(0,63+i,1-Btst(1,KKK)*Btst(i,KKK))
  Next i
  If BtstI(24,25,KKK)=2
    DisableMenuItem(0,74,0)
  Else
    DisableMenuItem(0,74,1)
  EndIf
  If BtstI(19,20,KKK)=2
    DisableMenuItem(0,75,0)
  Else
    DisableMenuItem(0,75,1)
  EndIf
  If Btst(28,QQQ)
    DisableMenuItem(0,76,0)
  Else
    DisableMenuItem(0,76,1)
    SetMenuItemState(0,76,1)
  EndIf
  If (inidat$<>neudat$) Or (kp>0)
    DisableMenuItem(0,501,1)
  ElseIf kp=0
    DisableMenuItem(0,501,0)
  EndIf
  If Btst(29,QQQ)
    DisableMenuItem(0,502,1)
  EndIf
  For i=530 To 532 ; 5330 s.o.
    DisableMenuItem(0,i,Btst(19,QQQ))
  Next i
  For i=5331 To 5340
    DisableMenuItem(0,i,Btst(19,QQQ))
  Next i
  If BtstI(19,20,KKK)
    For i=570 To 573
      DisableMenuItem(0,i,1)
    Next i
  Else
    For i=570 To 573
      DisableMenuItem(0,i,0)
    Next i
  EndIf
  ;
  SetGadgetText(27,Datum(3))
  SetGadgetText(29,Datum(4))
  SetGadgetState(51,1-Btst(6,QQQ))
  SetGadgetState(52,Btst(7,QQQ))
  DisableGadget(54,Btst(6,QQQ))
  SetGadgetState(54,Btst(8,QQQ))
  SetGadgetState(55,Btst(12,QQQ))
  SetGadgetState(56,Btst(13,QQQ))
  SetGadgetState(57,Btst(11,QQQ))
  SetGadgetState(58,Btst(17,QQQ))
  SetGadgetState(59,Btst(10,QQQ))
  SetGadgetState(590,Btst(16,QQQ))
  SetGadgetState(591,Btst(19,QQQ))
  If BtstI(22,23,QQQ) 
    HideGadget(705,1)
    HideGadget(706,0)
  Else
    HideGadget(705,0)
    HideGadget(706,1)
  EndIf
  If gravob=1
    If Btst(9,QQQ)
      QQQ=Bclr(9,QQQ)
      SetGadgetState(53,0)
    EndIf
    DisableGadget(53,1)
  Else
    DisableGadget(53,0)
  EndIf
EndProcedure ; CtrlMenuGadget
;
Procedure EinstGadget(typ,txt1$,txt2$)
  Select typ
    Case 0 ; leer
      FreeGadget(114)
      HideGadget(111,0)
      HideGadget(112,0)
      HideGadget(113,0)
      SetGadgetText(110,txt1$)
      SetGadgetText(111,txt2$)
      DisableGadget(111,1)
      bgad(0)=1
      DisableGadget(112,1)
      DisableGadget(113,1)
      eingad=0
    Case 1 ; Einstellungen allg.
      FreeGadget(114)
      HideGadget(111,0)
      HideGadget(112,0)
      HideGadget(113,0)
      SetGadgetText(110,txt1$)
      DisableGadget(111,0)
      bgad(0)=0
      SetGadgetText(111,txt2$)
      DisableGadget(112,0)
      DisableGadget(113,0)
      eingad=1
    Case 2 ; Startzeit
      HideGadget(111,0)
      HideGadget(112,0)
      HideGadget(113,0)
      SetGadgetText(110,txt1$)
      DisableGadget(112,0)
      DisableGadget(113,0)
      OpenGadgetList(700)
      templb=startzeit.d
      If lokal
        templb-tzbias
      EndIf
      DateGadget(114,180,405,120,20,"%dd.%mm.%yyyy  %hh:%ii",templb,#PB_Date_UpDown)
      SetGadgetAttribute(114,#PB_Date_Minimum,1)
      SetGadgetAttribute(114,#PB_Date_Maximum,2145916740)
      bgad(0)=0
      CloseGadgetList() ; 700
    Case 3 ; Koordinatenaktualisierung luft
      SetGadgetText(110,txt1$)
      HideGadget(111,1)
      HideGadget(112,1)
      HideGadget(113,1)
      ButtonGadget(114,181,404,286,24,txt2$,#PB_Button_Default)
  EndSelect
EndProcedure ; EinstGadget
;
;- EINGABE
Procedure Eingeben(typ)
  keinabbruch=1
  If (KKK=0) And (typ<26) And (startzeitvar=0) And (inidat$=neudat$)
    eingabezeit.d=UTC()
    temp.d=eingabezeit.d-startzeit.d
    If temp.d>60
      startzeitalt.d=startzeit.d
      startzeit.d=eingabezeit.d
      stopzeit.d=eingabezeit.d
      stopzeitalt.d=eingabezeit.d
      BahnrechnungA(2)
    EndIf
  EndIf
  Select typ
;- Sonnensystem
    Case 1 To 11
      If stopzeitvor.d>0
        stopzeitalt.d=stopzeitvor.d
        stopzeitvor.d=0
      EndIf
      If BahnrechnungA(3)=0
        ProcedureReturn
      EndIf
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=datmm.d(typ)
      sx.d(kp)=stosx.d(typ)
      sy.d(kp)=stosy.d(typ)
      sz.d(kp)=stosz.d(typ)
      vx.d(kp)=stovx.d(typ)
      vy.d(kp)=stovy.d(typ)
      vz.d(kp)=stovz.d(typ)
      btyp=typ
      If typ=11
        btyp=4
      EndIf
      If btyp>brttmp
        BildBrt(btyp)
      EndIf
      Blickrichtung(1)
      KKK=Bset(typ,KKK)
      QQQ=Bset(4,QQQ)
      Zustand(0,kp)
;- KoerperA-G
    Case 12 To 14
      nn=11
      Repeat
        nn+1
      Until Btst(nn,KKK)=0 ; nur bei freier Stelle bei 12 bis 18 aufgerufen
      kp+1
      Zuordnen(kp,nn)
      name$(kp)=datname$(nn)
      spritenum(kp)=nn
      m.d(kp)=datmm.d(nn)
      vx.d(kp)=0
      vy.d(kp)=0
      vz.d(kp)=0
      versuch=0
      If Btst(5,QQQ)
        exp$="e+7"
      Else
        exp$="e+10"
      EndIf
      Repeat
        sy.d(kp)=ValD(Str((1+Random(30))*(1-2*Random(1)))+exp$)
        sz.d(kp)=ValD(Str((1+Random(30))*(1-2*Random(1)))+exp$)
        If typ=13 ; Ekliptikebene
          sz.d(kp)=sy.d(kp)*Tan(#ecl)
        ElseIf typ=14 ; quatorebene
          sz.d(kp)=0
        EndIf
        sx.d(kp)=ValD(Str((1+Random(30))*(1-2*Random(1)))+exp$)
        If kp>1
          res=Kollisionstest(sx.d(kp),sy.d(kp),sz.d(kp),kp,0)
        EndIf
        versuch+1
      Until (res=1) Or (kp=1) Or (versuch=100)
      Blickrichtung(1)
      If brttmp<5
        BildBrt(5)
      EndIf
      KKK=Bset(nn,KKK)
      If Btst(5,QQQ)=0
        QQQ=Bset(4,QQQ)
      EndIf
      Zustand(0,kp)
;- Doppelstern
    Case 19
      DoppPar()
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=mstern1.d
      sx.d(kp)=0
      sy.d(kp)=ydpp1.d
      sz.d(kp)=zdpp1.d
      vx.d(kp)=vxdpp1.d
      vy.d(kp)=0
      vz.d(kp)=0
      KKK=Bset(typ,KKK)
      Zustand(0,kp)
      typ+1
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=mstern2.d
      sx.d(kp)=0
      sy.d(kp)=ydpp2.d
      sz.d(kp)=zdpp2.d
      vx.d(kp)=vxdpp2.d
      vy.d(kp)=0
      vz.d(kp)=0
      KKK=Bset(typ,KKK)
      Zustand(0,kp)
      Blickrichtung(1)
      QQQ=Bset(4,QQQ)
;- Erde-geo
    Case 24,241,242,243
      Select typ
        Case 241
          QQQ=Bset(22,QQQ)
        Case 242
          QQQ=Bset(23,QQQ)
        Case 243
          QQQ=Bset(23,QQQ)
          labor=1
      EndSelect
      typ=24
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=datmm.d(typ)
      sx.d(kp)=0
      sy.d(kp)=0
      sz.d(kp)=0
      vx.d(kp)=0
      vy.d(kp)=0
      vz.d(kp)=0
      If Btst(22,QQQ)
        BildBrt(14)
      ElseIf Btst(23,QQQ)
        BildBrt(15)
        Erdoberflaeche(2)
      Else
        BildBrt(11)
      EndIf
      Blickrichtung(4)
      KKK=Bset(typ,KKK)
      QQQ=Bset(5,QQQ)
      QQQ=Bclr(24,QQQ)
      QQQ=Bset(26,QQQ)
      If Btst(23,QQQ)
        stellenalt=stellen
        stellen=MaxL(3,stellenalt)
      EndIf
      Zustand(0,kp)
      sx.d(21)=0
      sy.d(21)=radius.d(24)
      sz.d(21)=0
;- Mond-geo
    Case 25
      If BahnrechnungA(3)=0
        ProcedureReturn
      EndIf
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=datmm.d(typ)
      sx.d(kp)=stosx.d(11)-stosx.d(4)
      sy.d(kp)=stosy.d(11)-stosy.d(4)
      sz.d(kp)=stosz.d(11)-stosz.d(4)
      vx.d(kp)=stovx.d(11)-stovx.d(4)
      vy.d(kp)=stovy.d(11)-stovy.d(4)
      vz.d(kp)=stovz.d(11)-stovz.d(4)
      BildBrt(11)
      Blickrichtung(1)
      KKK=Bset(typ,KKK)
      Zustand(0,kp)
;- Satelliten
    Case 26,27
      nn=25
      Repeat
        nn+1
      Until Btst(nn,KKK)=0 ; nur bei freier Stelle bei 26 bis 28 aufgerufen
      kp+1
      Zuordnen(kp,nn)
      name$(kp)=datname$(nn)
      spritenum(kp)=nn
      m.d(kp)=datmm.d(nn)
      sx.d(kp)=0
      If satfak.d=0
        sy.d(kp)=#geostat
        gstat=1
      Else
        sy.d(kp)=radius.d(24)*satfak.d
      EndIf
      If nn=27
        sy.d(kp)=sy.d(kp)+1000000
      ElseIf nn=28
        sy.d(kp)=sy.d(kp)+2000000
      EndIf
      sz.d(kp)=0
      If typ=26 ; quatorial
        vx.d(kp)=-1
        vz.d(kp)=0
      ElseIf typ=27 ; polar
        vx.d(kp)=0
        vz.d(kp)=1
      EndIf
      vy.d(kp)=0
      Kreisbahn(kp)
      If Btst(25,KKK)=0
        BildBrt(12)
      EndIf
      If gstat
        BildBrt(13)
      ElseIf satfak.d>10
        BildBrt(11)
      EndIf
      Blickrichtung(4)
      KKK=Bset(nn,KKK)
      Zustand(0,kp)
;- KoerperW1-W2
    Case 29
      If Btst(29,KKK)
        typ=30
      EndIf
      kp+1
      Zuordnen(kp,typ)
      name$(kp)=datname$(typ)
      spritenum(kp)=typ
      m.d(kp)=datmm.d(typ)
      If labor
        xad.d=1
      ElseIf Btst(23,QQQ)
        xad.d=100
      ElseIf Btst(22,QQQ)
        xad.d=100000
      Else
        xad.d=1000000
      EndIf
      wdh.d=0
      Repeat
        If labor
          sx.d(kp)=-4+wdh.d*xad.d
          sy.d(kp)=radius.d(24)+radius.d(typ)
        ElseIf Btst(23,QQQ)
          sx.d(kp)=-400+wdh.d*xad.d
          sy.d(kp)=radius.d(24)+radius.d(typ)
        Else
          sx.d(kp)=wdh.d*xad.d
          sy.d(kp)=radius.d(24)+radius.d(typ)
        EndIf
        sz.d(kp)=0
        If labor
          vx.d(kp)=#vxlabkl
        ElseIf Btst(23,QQQ)
          vx.d(kp)=#vxlabgr
        ElseIf rtstp
          vx.d(kp)=#vxob
        Else
          vx.d(kp)=omega.d*sy.d(kp)
        EndIf
        If labor
          vy.d(kp)=#vylabkl
        ElseIf Btst(23,QQQ)
          vy.d(kp)=#vylabgr
        ElseIf Btst(22,QQQ)
          vy.d(kp)=#vyob
        Else
          vy.d(kp)=#vyerde
          If Btst(25,KKK)=0
            Bildbrt(12)
          EndIf
        EndIf
        vz.d(kp)=0
        If kp>1
          res=Kollisionstest(sx.d(kp),sy.d(kp),sz.d(kp),kp,0)
        EndIf
        wdh.d+1
      Until (res=1) Or (wdh.d=10)
      If BtstI(22,23,QQQ) And rtcmp
        zeit.d=0
        phi.d=0
      EndIf
      Blickrichtung(4)
      KKK=Bset(typ,KKK)
      Zustand(0,kp)
;- Koerper-Lagrange
    Case 31 To 35
      lgr=typ-30
      nn=11
      Repeat
        nn+1
      Until Btst(nn,KKK)=0 ; nur bei freier Stelle bei 12 bis 18 aufgerufen
      kp+1
      Zuordnen(kp,nn)
      name$(kp)=datname$(nn)
      spritenum(kp)=nn
      m.d(kp)=datmm.d(nn)
      If Btst(5,QQQ)
        m.d(kp)=m.d(kp)/1000
      EndIf
      GeschwLP(pos(lagr1),pos(lagr2))
      sx.d(kp)=sxl.d(lgr)
      sy.d(kp)=syl.d(lgr)
      sz.d(kp)=szl.d(lgr)
      vx.d(kp)=vxl.d(lgr)
      vy.d(kp)=vyl.d(lgr)
      vz.d(kp)=vzl.d(lgr)
      KKK=Bset(nn,KKK)
      Zustand(0,kp)
  EndSelect
  If kp>1
    If Kollisionstest(sx.d(kp),sy.d(kp),sz.d(kp),kp,1)=0
      Entfernen(kp,0)
      ProcedureReturn
    EndIf
  EndIf
  ;
  ClearGadgetItemList(2)
  kpgad=0
  For k=1 To kp
    If k<10
      spc=2
    Else
      spc=0
    EndIf
    AddGadgetItem(2,-1,Space(spc)+Str(k)+" :  "+name$(k))
  Next k
  bcnt=0
  bcntmax=0
  For i=0 To bahnpunkte
    sxb.d(i)=0
    syb.d(i)=0
    szb.d(i)=0
    fb.b(i)=0
    cb.b(i)=0
    mb.b(i)=0
  Next i
  If Btst(5,QQQ)
    If bezug=22
      BezugBild(22)
    Else
      BezugBild(4)
    EndIf
  EndIf
  If (kp=1) Or ((kp=2) And (typ=20))
    AddKeyboardShortcut(0,#PB_Shortcut_F5,40)
  EndIf
EndProcedure ; Eingeben
;
Procedure Entfernen(typ,del)
  ; typ=1,2,...: selektierter Krper (typ=kpgad) ; 0: alle; del=0: Bahnen nicht gelscht
  If (typ=0) Or (typ=pos(lagr1)) Or (typ=pos(lagr2))
    LagrangeEA(0,0,76)
  EndIf
  If (typ=0) Or (typ=pos(zusatzkp))
    ZusatzkraftEA(-1)
  EndIf
  ClearGadgetItemList(2)
  If typ=0
    KKK=0
    For i=1 To kp
      name$(i)=""
      spritenum(i)=0
      kpr(i)=0
      sx.d(i)=0
      sy.d(i)=0
      sz.d(i)=0
      vx.d(i)=0
      vy.d(i)=0
      vz.d(i)=0
      m.d(i)=0
    Next i
    For i=1 To 20
      pos(i)=0
    Next i
    For i=24 To 30
      pos(i)=0
    Next i
    kp=0
  Else ; ausgewhlten Krper entfernen ; typ=kpgad=pos
    For i=1 To typ-1
      If i<10
        spc=2
      Else
        spc=0
      EndIf
      AddGadgetItem(2,-1,Space(spc)+Str(i)+" :  "+name$(i))
    Next i
    For i=typ+1 To kp
      If i<11 ; wegen i-1
        spc=2
      Else
        spc=0
      EndIf
      AddGadgetItem(2,-1,Space(spc)+Str(i-1)+" :  "+name$(i))
    Next i
    KKK=Bclr(kpr(typ),KKK)
    pos(kpr(typ))=0
    For i=1 To 20
      If pos(i)>typ
        pos(i)=pos(i)-1
      EndIf
    Next i
    For i=24 To 30
      If pos(i)>typ
        pos(i)=pos(i)-1
      EndIf
    Next i
    posbzg=pos(bezug)
    ;
    Select kpr(typ)
      Case 1
        If bezug=1
          BezugBild(0)
        EndIf
      Case 4
        If bezug=4
          BezugBild(0)
        EndIf
    EndSelect
    If (kpr(typ)=hohkp) And (hohkp>0)
      QQQ=Bclr(27,QQQ)
      hohkp=0
    EndIf
    For i=typ To kp-1
      name$(i)=name$(i+1)
      spritenum(i)=spritenum(i+1)
      kpr(i)=kpr(i+1)
      sx.d(i)=sx.d(i+1)
      sy.d(i)=sy.d(i+1)
      sz.d(i)=sz.d(i+1)
      vx.d(i)=vx.d(i+1)
      vy.d(i)=vy.d(i+1)
      vz.d(i)=vz.d(i+1)
      m.d(i)=m.d(i+1)
    Next i
    name$(kp)=""
    spritenum(kp)=0
    kpr(kp)=0
    kp-1
    If typ>1
      Zustand(0,typ-1)
    Else
      Zustand(0,1)
    EndIf
  EndIf
  ;
  kpgad=0
  If kp=0
    For k=1 To 11
      stosx.d(k)=stasx.d(k)
      stosy.d(k)=stasy.d(k)
      stosz.d(k)=stasz.d(k)
      stovx.d(k)=stavx.d(k)
      stovy.d(k)=stavy.d(k)
      stovz.d(k)=stavz.d(k)
    Next k
    stopzeit.d=startzeit.d
    stopzeitalt.d=startzeit.d
    stopzeitvor.d=0
    uoff.d=uoffcfg.d
    woff.d=woffcfg.d
    BezugBild(0)
    BildBrt(1)
    Blickrichtung(1)
    BahnWeg()
    Zustand(3,0)
    Erdoberflaeche(0)
    zeit.d=0
    phi.d=0
    wcnt=0
    labor=0
    stellen=stellenalt
    If gravob
      Erdfeld(0)
    EndIf
    For i=0 To bahnpunkte
      sxw.d(i)=0
      syw.d(i)=0
      szw.d(i)=0
      phw.d(i)=0
    Next i
    diffstartstop.d=0
    InfoM(Datum(4),4)
    QQQ=Bclr(4,QQQ)
    QQQ=Bclr(5,QQQ)
    QQQ=Bclr(26,QQQ)
    RemoveKeyboardShortcut(0,#PB_Shortcut_F5)
  EndIf
  If del=1
    BahnWeg()
  EndIf
  bcnt=0
  bcntmax=0
  For i=0 To bahnpunkte
    sxb.d(i)=0
    syb.d(i)=0
    szb.d(i)=0
    fb.b(i)=0
    cb.b(i)=0
    mb.b(i)=0
  Next i
  QQQ=Bclr(25,QQQ)
EndProcedure ; Entfernen
;
Procedure Zustand(typ,k)
  ; typ 0: schreiben
  ; typ 1: bernehmen
  ; typ 2: rckgngig
  ; typ 3: nach Entfernen aller Krper
  DisableGadget(102,1)
  If Btst(5,QQQ)
    If labor
      zntr$="  ( Laborsystem klein )"
    ElseIf Btst(23,QQQ)
      zntr$="  ( Laborsystem gro )"
    Else
      zntr$="  ( geozentrisch )"
    EndIf
  EndIf
  Select typ
    Case 0
      If labor
        gsx$=StrE(sx.d(k)+4,-1)
        gsy$=StrE(sy.d(k)-radius.d(24),-1)
      ElseIf Btst(23,QQQ)
        gsx$=StrE(sx.d(k)+400,-1)
        gsy$=StrE(sy.d(k)-radius.d(24),-1)
      Else
        gsx$=StrE(sx.d(k),-1)
        gsy$=StrE(sy.d(k),-1)
      EndIf
      gsz$=StrE(sz.d(k),-1)
      gvx$=StrE(vx.d(k),-1)
      gvy$=StrE(vy.d(k),-1)
      gvz$=StrE(vz.d(k),-1)
      gm$=StrE(m.d(k),-1)
      SetGadgetText(3,"Zustand von Krper "+Str(k)+": "+name$(k)+zntr$)
      SetGadgetText(6,gsx$)
      SetGadgetText(8,gsy$)
      SetGadgetText(10,gsz$)
      SetGadgetText(13,gvx$)
      SetGadgetText(15,gvy$)
      SetGadgetText(17,gvz$)
      SetGadgetText(20,gm$)
    Case 1
      sxzwi.d=sx.d(k)
      syzwi.d=sy.d(k)
      szzwi.d=sz.d(k)
      vxzwi.d=vx.d(k)
      vyzwi.d=vy.d(k)
      vzzwi.d=vz.d(k)
      mzwi.d=m.d(k)
      rsx$=GetGadgetText(6)
      rsy$=GetGadgetText(8)
      rsz$=GetGadgetText(10)
      rvx$=GetGadgetText(13)
      rvy$=GetGadgetText(15)
      rvz$=GetGadgetText(17)
      rm$=GetGadgetText(20)
      If rsx$<>gsx$
        If FindString(LCase(rsx$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rsx$)
        EndIf
        If temp.d<>#fehld
          If labor
            sx.d(k)=temp.d-4
          ElseIf Btst(23,QQQ)
            sx.d(k)=temp.d-400
          Else
            sx.d(k)=temp.d
          EndIf
        EndIf
      EndIf
      If rsy$<>gsy$
        If FindString(LCase(rsy$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rsy$)
        EndIf
        If temp.d<>#fehld
          If Btst(23,QQQ)
            sy.d(k)=temp.d+radius.d(24)
          Else
            sy.d(k)=temp.d
          EndIf
        EndIf
      EndIf
      If rsz$<>gsz$
        If FindString(LCase(rsz$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rsz$)
        EndIf
        If temp.d<>#fehld
          sz.d(k)=temp.d
        EndIf
      EndIf
      If Kollisionstest(sx.d(k),sy.d(k),sz.d(k),k,1)=0
        sx.d(k)=sxzwi.d
        sy.d(k)=syzwi.d
        sz.d(k)=szzwi.d
      EndIf
      If rvx$<>gvx$
        If FindString(LCase(rvx$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rvx$)
        EndIf
        If temp.d<>#fehld
          vx.d(k)=temp.d
        EndIf
      EndIf
      If rvy$<>gvy$
        If FindString(LCase(rvy$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rvy$)
        EndIf
        If temp.d<>#fehld
          vy.d(k)=temp.d
        EndIf
      EndIf
      If rvz$<>gvz$
        If FindString(LCase(rvz$),"def",1)
          InfoHilfe(5)
          temp.d=#fehld
        Else
          temp.d=Wert(rvz$)
        EndIf
        If temp.d<>#fehld
          vz.d(k)=temp.d
        EndIf
      EndIf
      If (rm$<>gm$)
        If FindString(LCase(rm$),"def",1)
          temp.d=datmm.d(kpr(kpgad))
        Else
          temp.d=Wert(rm$)
        EndIf
        If temp.d<=0
          tit$="Eingabebegrenzung"
          txt$="Term "
          txt$+rm$
          txt$+":    "
          txt$+Chr(13)
          txt$+"Nur positive Werte sind zulssig.    "
          MessageRequester(tit$,txt$,#MB_ICONSTOP)
        ElseIf temp.d<>#fehld
          m.d(k)=temp.d
        EndIf
      EndIf
      Zustand(0,k)
      DisableGadget(102,0)
      If bezug=22 ; Bahnen knnen sich rel. zum SP verschieben
        BahnWeg()
      EndIf
    Case 2
      sx.d(k)=sxzwi.d
      sy.d(k)=syzwi.d
      sz.d(k)=szzwi.d
      vx.d(k)=vxzwi.d
      vy.d(k)=vyzwi.d
      vz.d(k)=vzzwi.d
      m.d(k)=mzwi.d
      Zustand(0,k)
    Case 3
      SetGadgetText(3,"Zustand")
      SetGadgetText(6,"")
      SetGadgetText(8,"")
      SetGadgetText(10,"")
      SetGadgetText(13,"")
      SetGadgetText(15,"")
      SetGadgetText(17,"")
      SetGadgetText(20,"")
  EndSelect
EndProcedure ; Zustand
;
Procedure Zuordnen(n,m)
  kpr(n)=m
  pos(m)=n
EndProcedure ; Zuordnen
;
;- BAHNRECHNUNG
Procedure.l BahnrechnungA(typ)
  ; typ 0: datx ... stax, stox
  ; typ 1: datx ... stax, stox
  ; typ 2: stax ... stax, stox
  ; typ 3: stox ... stox (datx ... stox bei inidat$<>neudat$)
  ; Rckgabe: bei Abbruch 0, sonst 1
  If multein=1
    ProcedureReturn
  EndIf
  tit$="Koordinatenaktualisierung"
  keinabbruch=1
  Select typ
    Case 0
      laufzeit.d=startzeit.d-datenzeit.d
    Case 1
      If inidat$=neudat$
        laufzeit.d=startzeit.d-datenzeit.d
      Else
        laufzeit.d=0 ;  NICHT ProcedureReturn !!!
      EndIf
    Case 2
      laufzeit.d=startzeit.d-startzeitalt.d
    Case 3
      If inidat$=neudat$
        laufzeit.d=stopzeit.d-stopzeitalt.d
      Else
        laufzeit.d=stopzeit.d-datenzeit.d
      EndIf
      If laufzeit.d=0
        ProcedureReturn 1
      EndIf
    Case 9
      DatenLaden(1)
      laufzeit.d=startzeit.d-datenzeit.d
      typ=0
  EndSelect
  ;
  If FileSize(tmpdat$)=-1
    noabb=1
  EndIf
  If IsGadget(700)
    DisableGadget(700,1)
  EndIf
  SetMenu_(WinID,men(1))
  Select typ
    Case 0,1
      For k=1 To 11
        osx.d(k)=datsx.d(k)
        osy.d(k)=datsy.d(k)
        osz.d(k)=datsz.d(k)
        ovx.d(k)=datvx.d(k)
        ovy.d(k)=datvy.d(k)
        ovz.d(k)=datvz.d(k)
      Next k
    Case 2
      For k=1 To 11
        osx.d(k)=stasx.d(k)
        osy.d(k)=stasy.d(k)
        osz.d(k)=stasz.d(k)
        ovx.d(k)=stavx.d(k)
        ovy.d(k)=stavy.d(k)
        ovz.d(k)=stavz.d(k)
      Next k
    Case 3
      If inidat$=neudat$
        For k=1 To 11
          osx.d(k)=stosx.d(k)
          osy.d(k)=stosy.d(k)
          osz.d(k)=stosz.d(k)
          ovx.d(k)=stovx.d(k)
          ovy.d(k)=stovy.d(k)
          ovz.d(k)=stovz.d(k)
        Next k
      Else
        For k=1 To 11
          osx.d(k)=datsx.d(k)
          osy.d(k)=datsy.d(k)
          osz.d(k)=datsz.d(k)
          ovx.d(k)=datvx.d(k)
          ovy.d(k)=datvy.d(k)
          ovz.d(k)=datvz.d(k)
        Next k
      EndIf
  EndSelect
  dtalt.d=dt.d
  If laufzeit.d>=0
    If typ<3
      dt.d=10
    EndIf
  Else
    If typ<3
      dt.d=-10
    Else
      dt.d=-dt.d
    EndIf
  EndIf
  If Abs(laufzeit.d)>100*dt.d
    EinstGadget(3,"","Koordinatenaktualisierung abbrechen")
  EndIf
  zeitalt.d=zeit.d
  zeit.d=0
  For k=1 To 11
    grav.d(k)=#gammacfg*datmm.d(k)
  Next k
  tempa.d=Abs(laufzeit.d)
  tempb.d=Abs(zeit.d)
  ; Schleife Bahnrechnung:
  txt$="Die Koordinatenaktualisierung wrde zur Kollision zweier Krper fhren.    "+exit$
  halb.d=0.5
  While tempb.d<tempa.d
    For k=1 To 11
      osx.d(k)=osx.d(k)+dt.d*ovx.d(k)
      osy.d(k)=osy.d(k)+dt.d*ovy.d(k)
      osz.d(k)=osz.d(k)+dt.d*ovz.d(k)
      ax.d(k)=0
      ay.d(k)=0
      az.d(k)=0
      For i=1 To 11
        If i<>k
          rr.d=Sqr(Pow(osx.d(k)-osx.d(i),2)+Pow(osy.d(k)-osy.d(i),2)+Pow(osz.d(k)-osz.d(i),2))
          If rr.d<koll.d(i,k) ; Kollision
            MessageRequester(tit$,txt$,#MB_ICONSTOP)
            keinabbruch=0
            typ=1
            Break 3
          EndIf
          rr.d=Pow(rr.d,3)
          ax.d(k)=ax.d(k)+grav.d(i)*(osx.d(i)-osx.d(k))/rr.d
          ay.d(k)=ay.d(k)+grav.d(i)*(osy.d(i)-osy.d(k))/rr.d
          az.d(k)=az.d(k)+grav.d(i)*(osz.d(i)-osz.d(k))/rr.d
        EndIf
      Next i
      ovx.d(k)=ovx.d(k)+halb.d*dt.d*ax.d(k)
      ovy.d(k)=ovy.d(k)+halb.d*dt.d*ay.d(k)
      ovz.d(k)=ovz.d(k)+halb.d*dt.d*az.d(k)
    Next k
    halb.d=1
    zeit.d=zeit.d+dt.d
    tempb.d=Abs(zeit.d)
    wID=WindowEvent()
    gID=EventGadget()
    mID=EventMenu()
    If (wID=#PB_Event_Gadget) Or (wID=#PB_Event_Menu)
      If (gID=114) Or (mID=1)
        txt$="Nach dem Abbruch der Koordinatenaktualisierung    "
        txt$+Chr(13)
        Select typ
          Case 0
            txt$+"wird die bisherige temporre Startdatei verwendet.    "
          Case 1
            txt$+"wird "+programmtitel$+" beendet.    "
          Case 2
            txt$+"wird die bisherige Startzeit verwendet.    "
          Case 3
            txt$+"wird die Eingabe des Krpers abgebrochen.    "
        EndSelect
        txt$+Chr(13)+Chr(13)
        txt$+"Soll die Koordinatenaktualisierung abgebrochen werden?    "
        res=MessageRequester(tit$,txt$,#MB_YESNO|#MB_ICONQUESTION|#MB_DEFBUTTON2)
        If res=#PB_MessageRequester_Yes
          keinabbruch=0
          Break
        EndIf
      EndIf
    EndIf
    tempc.d=Abs(zeit.d/laufzeit.d)
    pro=MaxL(Int(tempc.d*100),1)
    SetGadgetState(120,pro)
  Wend ; Ende Schleife Bahnrechnung
  ;
  EinstGadget(0,"Einstellungen","")
  SetGadgetState(120,0)
  zeit.d=zeitalt.d
  dt.d=dtalt.d
  If (typ=0) And (keinabbruch=0)
    If IsGadget(700)
      DisableGadget(700,0)
    EndIf
    InfoM(Datum(4),4)
    SetMenu_(WinID,men(0))
    ProcedureReturn keinabbruch
  EndIf
  If (typ<3) Or (keinabbruch=1)
    stopzeitalt.d=stopzeit.d
  EndIf
  If keinabbruch
    For k=1 To 11
      stosx.d(k)=osx.d(k)
      stosy.d(k)=osy.d(k)
      stosz.d(k)=osz.d(k)
      stovx.d(k)=ovx.d(k)
      stovy.d(k)=ovy.d(k)
      stovz.d(k)=ovz.d(k)
    Next k
  EndIf
  If typ<3
    If keinabbruch
      For k=1 To 11
        stasx.d(k)=osx.d(k)
        stasy.d(k)=osy.d(k)
        stasz.d(k)=osz.d(k)
        stavx.d(k)=ovx.d(k)
        stavy.d(k)=ovy.d(k)
        stavz.d(k)=ovz.d(k)
      Next k
    EndIf
    If typ<2
      If keinabbruch=0
        Programmende()
      EndIf
      DatenSpeichern()
    EndIf
    If typ=2
      If keinabbruch=0
        tempb.d=0
      EndIf
      If laufzeit.d>0
        startzeit.d=startzeitalt.d+tempb.d
      Else
        startzeit.d=startzeitalt.d-tempb.d
      EndIf
    EndIf
  EndIf
  If IsGadget(29)
    SetGadgetText(29,Datum(4))
  EndIf
  If typ=3
    InfoM(Datum(2),2)
  Else
    InfoM(Datum(4),4)
  EndIf
  If IsGadget(700)
    DisableGadget(700,0)
  EndIf
  SetMenu_(WinID,men(0))
  ProcedureReturn keinabbruch
EndProcedure ; BahnrechnungA
;
Procedure BahnrechnungB(richt)
  bahn=1-Btst(6,QQQ)
  schw=Btst(9,QQQ)
  lagr=Btst(28,QQQ)
  If zusatztyp>0
    beschl.d=fzusatz.d/m.d(pos(zusatzkp))
    reib.d=reibpar.d/1000000000
  EndIf
  dt.d=Abs(dt.d)
  dtvorred.d=Abs(dtvorred.d)
  If richt=-1
    dt.d=-dt.d
    dtvorred.d=-dtvorred.d
  EndIf
  zeitalt.d=zeit.d
  fahrf.d=0
  For k=1 To kp
    grav.d(k)=gamma.d*m.d(k)
    frbplot(k)=32
  Next k
  If gravob=1
    grav.d(1)=gamma.d*datmm.d(11)*Pow((datrr.d(24)/datrr.d(11)),2)
  ElseIf gravob=2
    grav.d(1)=0
  EndIf
  ;  Schleife Bahnrechnung:
  QQQ=Bset(3,QQQ)
  halb.d=0.5
  Repeat
    fahr=0
    For k=1 To kp
      sx.d(k)=sx.d(k)+dt.d*vx.d(k)
      sy.d(k)=sy.d(k)+dt.d*vy.d(k)
      sz.d(k)=sz.d(k)+dt.d*vz.d(k)
      ; berlauf Koordinaten/Geschwindigkeiten
      If Abs(sx.d(k))>#grosss
        stop=1100+k
      EndIf
      If Abs(sy.d(k))>#grosss
        stop=1200+k
      EndIf
      If Abs(sz.d(k))>#grosss
        stop=1300+k
      EndIf
      If Abs(vx.d(k))>#grossv
        stop=1400+k
      EndIf
      If Abs(vy.d(k))>#grossv
        stop=1500+k
      EndIf
      If Abs(vz.d(k))>#grossv
        stop=1600+k
      EndIf
      ;
      If Btst(8,QQQ)
        If fahrf.d>fahrint.d
          fahrf.d=0
          schr=bahnschritt+1
          fahr=1
        EndIf
      EndIf
      ax.d(k)=0
      ay.d(k)=0
      az.d(k)=0
      For i=1 To kp
        If i<>k
          rr.d=Sqr(Pow(sx.d(k)-sx.d(i),2)+Pow(sy.d(k)-sy.d(i),2)+Pow(sz.d(k)-sz.d(i),2))
          If rr.d<koll.d(kpr(i),kpr(k)) ; Kollision
            ko1=k
            ko2=i
            kpa=0
            stop=2
          EndIf
          rr.d=Pow(rr.d,3)
          ax.d(k)=ax.d(k)+grav.d(i)*(sx.d(i)-sx.d(k))/rr.d
          ay.d(k)=ay.d(k)+grav.d(i)*(sy.d(i)-sy.d(k))/rr.d
          az.d(k)=az.d(k)+grav.d(i)*(sz.d(i)-sz.d(k))/rr.d
        EndIf
      Next i
      vx.d(k)=vx.d(k)+halb.d*dt.d*ax.d(k)
      vy.d(k)=vy.d(k)+halb.d*dt.d*ay.d(k)
      vz.d(k)=vz.d(k)+halb.d*dt.d*az.d(k)
      ; Test Beschleunigung (Kollisionsgefahr):
      If (Btst(5,QQQ)=0) And (Btst(26,QQQ)=0)
        If (Sqr(ax.d(k)*ax.d(k)+ay.d(k)*ay.d(k)+az.d(k)*az.d(k))>akoll.d) And (Abs(dt.d)>=dtkoll.d)
          QQQ=Bset(25,QQQ)
          kpa=k
        ElseIf kpa=k
          QQQ=Bclr(25,QQQ)
          kpa=0
        EndIf
      EndIf
      ; Zusatzkraft F:
      If (zusatztyp>0) And (k=pos(zusatzkp))
        tempa.d=GeschwBetrag(k)
        tempb.d=tempa.d*tempa.d
        Select zusatztyp
          Case 1 ; F const
            If tempa.d=0 ; bei v=0 y-Richtung
              vy.d(k)=0.001
            EndIf
            temp.d=beschl.d*dt.d+1
          Case 2 ; F ~ v
            temp.d=1-reib.d*dt.d*tempa.d
            If temp.d<0
              temp.d=0
            EndIf
          Case 3 ; F ~ v^2
            temp.d=1-reib.d*dt.d*tempb.d
            If temp.d<0
              temp.d=0
            EndIf
        EndSelect
        vx.d(k)=vx.d(k)*temp.d
        vy.d(k)=vy.d(k)*temp.d
        vz.d(k)=vz.d(k)*temp.d
      EndIf
      ; quatormarke:
      If Btst(5,QQQ)
        phi.d=omega.d*zeit.d
        sx.d(21)=radius.d(24)*Sin(phi.d)
        sy.d(21)=radius.d(24)*Cos(phi.d)
        sz.d(21)=0
      EndIf
      ;
      If Btst(5,QQQ) ; Transformation auf geozentrische Koordinaten
        sx.d(k)=sx.d(k)-sx.d(pos(24))
        sy.d(k)=sy.d(k)-sy.d(pos(24))
        sz.d(k)=sz.d(k)-sz.d(pos(24))
        vx.d(k)=vx.d(k)-vx.d(pos(24))
        vy.d(k)=vy.d(k)-vy.d(pos(24))
        vz.d(k)=vz.d(k)-vz.d(pos(24))
      EndIf
    Next k
    halb.d=1
    ;
    If (Btst(25,QQQ)=1) And (reduztmp=0)
      dtvorred.d=dt.d
      dt.d=dtkoll.d
      If richt=-1
        dt.d=-dt.d
      EndIf
      reduztmp=1
    ElseIf (Btst(25,QQQ)=0) And (reduztmp=1)
      dt.d=dtvorred.d
      reduztmp=0
    EndIf
    schr+1
    If schr>bahnschritt
      If lagr
        Lagrangepunkte(pos(lagr1),pos(lagr2))
        If lagrstop=1
          lagr=0
          lagrstop=0
          LagrangeEA(0,0,76)
        EndIf
      EndIf
      Zeichnen(bahn,fahr,schw,lagr,0)
      If Btst(12,QQQ)
        If StartDrawing(ScreenOutput())
          zl=0
          If Btst(28,QQQ)
            zl=25
          EndIf   
          Box(120,zeilenl-67-zl,spaltenl-240,52+zl,farbe(31))
          DrawingMode(#PB_2DDrawing_Outlined)
          Box(120,zeilenl-67-zl,spaltenl-240,52+zl,farbe(36))
          If zl=25
            Line(120,zeilenl-67,spaltenl-240,0,farbe(36))
          EndIf
          Text(htxt$(12),1,0.94)
          If Btst(5,QQQ)
            Text(htxt$(13),1,0.96)
          Else
            Text(htxt$(14),1,0.96)
          EndIf
          If Btst(28,QQQ)
            Text(htxt$(5),1,0.914)
          EndIf
          StopDrawing()
        EndIf
      EndIf
      FlipBuffers(vblsync)
      schr=0
    EndIf
    If Btst(27,QQQ) ; Hohmannbergang
      If hoh=0
        hoh=1 ; fr Unterbrechung durch F8
      EndIf
      r1.d=RadiusBetrag(pos(hohkp))
      If hohfak.d>1 ; Radius r1 wachsend
        If r1.d<r3.d ; r1 nimmt wieder ab ; r3=0 zu Beginn
          hoh+1
        EndIf
      ElseIf hohfak.d<1 ; Radius r1 fallend
        If r1.d>r3.d ; r1 nimmt wieder zu ; r3=#riesig zu Beginn
          hoh+1
        EndIf
      EndIf
      If hoh>10 ; vermeidet Zuflle durch Rundung
        Kreisbahn(pos(hohkp))
        hoh=0
        QQQ=Bclr(27,QQQ)
      EndIf
      r3.d=r1.d
    EndIf
    fahrf.d=fahrf.d+dt.d
    zeit.d=zeit.d+dt.d
    If Abs(zeit.d)>#grosst
      stop=1100
      zeit.d=#grosst
      If richt=-1
        zeit.d=-zeit.d
      EndIf
    EndIf
    zusatzdauer.d=zusatzdauer.d-dt.d
    If zusatzdauer.d<=0
      ZusatzkraftEA(-1)
    EndIf
    ;
    ExamineKeyboard()
    If (KeyboardPushed(#PB_Key_LeftControl) Or KeyboardPushed(#PB_Key_RightControl) Or KeyboardPushed(#PB_Key_LeftAlt) Or KeyboardPushed(#PB_Key_RightAlt)) And (Btst(27,QQQ)=0)
      BildEA(2)
      quit=1  
    ElseIf KeyboardPushed(#PB_Key_F1)
      InfoHilfe(0)
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F2)
      NamenEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F3)
      AchsenEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F4)
      ZeitEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F8)
      stop=1
    ElseIf KeyboardPushed(#PB_Key_F10)
      BildbreiteEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F11)
      ZeitschrittEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_F12) And (Btst(5,QQQ)=0)
      ReduzierungEA(1)
      dt.d=dtvorred.d
      kpa=0
      Delay(500)
    ElseIf (KeyboardPushed(#PB_Key_F)) And (Btst(6,QQQ)=0)
      FahrstrahlEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_L)
      NamenLagrEA()
      Delay(500)
    ElseIf KeyboardPushed(#PB_Key_G)
      GeschwindigkeitEA()
      Delay(500)  
    ElseIf KeyboardPushed(#PB_Key_5) And (Btst(25,QQQ)=0)
      QQQ=Bset(16,QQQ)
      dt.d=dt.d/1.001
      dtvorred.d=dt.d
    ElseIf KeyboardPushed(#PB_Key_6) And (Btst(25,QQQ)=0)
      QQQ=Bset(16,QQQ)
      dt.d=dt.d*1.001
      dtvorred.d=dt.d
    ElseIf KeyboardPushed(#PB_Key_T) And (Btst(25,QQQ)=0)
      dt.d=dtvorscr.d
      If richt=-1
        dt.d=-dt.d
      EndIf
      dtvorred.d=dt.d
    ElseIf KeyboardPushed(#PB_Key_Escape) And (Btst(27,QQQ)=0)
      stop=9  
    EndIf
  Until stop>0 ; Ende Schleife Bahnrechnung
  QQQ=Bclr(3,QQQ)
  ;
  stopzeit.d=stopzeit.d+zeit.d-zeitalt.d
  If stop>8
    BildEA(2)
  EndIf
  If (stop<2) Or (stop=9); keine Kollision
    If kpgad=0
      Zustand(0,kp)
    Else
      Zustand(0,kpgad)
    EndIf
  EndIf
  If Btst(27,QQQ)=0
    hohkp=0
  EndIf
  DisableMenuItem(0,3192,1)
  InfoM(Datum(2),2)
  If stop=1100
    tit$="Zeitbegrenzung"
    txt$="Die Zeit hat die physikalisch sinnvolle Gre berschritten.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
  ElseIf stop>1100
    ko=Int(stop/100) ; z.B. stop=1308 -> ko=13, kk=8
    kk=stop-100*ko
    tit$="Koordinaten- und Geschwindigkeitsbegrenzung"
    txt$="Die "
    Select ko
      Case 11
        txt$+"x-Koordinate"
      Case 12
        txt$+"y-Koordinate"
      Case 13
        txt$+"z-Koordinate"
      Case 14
        txt$+"x-Geschwindigkeitskomponente"
      Case 15
        txt$+"y-Geschwindigkeitskomponente"
      Case 16
        txt$+"z-Geschwindigkeitskomponente"
    EndSelect
    txt$+" des Krpers Nr. "
    txt$+Str(kk)+Space(4)+Chr(13)
    txt$+"hat die physikalisch sinnvolle Gre berschritten.    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    If kpgad=kk
      Zustand(0,kpgad)
    EndIf
  EndIf
  If stop=1
    BildAnzeigen(0,1)
    ProcedureReturn
  ElseIf stop=2
    Kollisionsreaktion(ko1,ko2)
    If kp=0
      ClearScreen(farbe(31))
      If StartDrawing(ScreenOutput())
        Text(htxt$(22),1,0.48)
        Text(htxt$(23),1,0.52)
        StopDrawing()
      EndIf
      FlipBuffers(#PB_Screen_SmartSynchronization)
      Delay(5000)
      BildEA(2)
      InfoM(Datum(4),4)
    ElseIf BtstI(22,23,QQQ)=0
      BahnrechnungB(richt)
      ProcedureReturn
    Else
      BildAnzeigen(0,1)
    EndIf
  EndIf
EndProcedure ; BahnrechnungB
;
Procedure GeschwLP(k1,k2)
  ; LP zur Zeit t:
  Lagrangepunkte(k1,k2)
  ; Koordinaten zwischenspeichern:
  sxalt.d(1)=sx.d(k1)
  syalt.d(1)=sy.d(k1)
  szalt.d(1)=sz.d(k1)
  sxalt.d(2)=sx.d(k2)
  syalt.d(2)=sy.d(k2)
  szalt.d(2)=sz.d(k2)
  For k=1 To 5
    sxlalt.d(k)=sxl.d(k)
    sylalt.d(k)=syl.d(k)
    szlalt.d(k)=szl.d(k)
  Next k
  ; Koordinaten zur Zeit t+dt berechnen:
  dtalt.d=dt.d
  dt.d=1
  grav.d(k1)=gamma.d*m.d(k1)
  grav.d(k2)=gamma.d*m.d(k2)
  dx.d=Pow(sx.d(k1)-sx.d(k2),2)
  dy.d=Pow(sy.d(k1)-sy.d(k2),2)
  dz.d=Pow(sz.d(k1)-sz.d(k2),2)
  rr.d=Pow(dx.d+dy.d+dz.d,1.5)
  ax.d(k1)=0
  ay.d(k1)=0
  az.d(k1)=0
  ax.d(k1)=ax.d(k1)+(sx.d(k2)-sx.d(k1))*grav.d(k2)/rr.d
  vx.d(k1)=vx.d(k1)+ax.d(k1)*dt.d
  ay.d(k1)=ay.d(k1)+(sy.d(k2)-sy.d(k1))*grav.d(k2)/rr.d
  vy.d(k1)=vy.d(k1)+ay.d(k1)*dt.d
  az.d(k1)=az.d(k1)+(sz.d(k2)-sz.d(k1))*grav.d(k2)/rr.d
  vz.d(k1)=vz.d(k1)+az.d(k1)*dt.d
  ax.d(k2)=0
  ay.d(k2)=0
  az.d(k2)=0
  ax.d(k2)=ax.d(k2)+(sx.d(k1)-sx.d(k2))*grav.d(k1)/rr.d
  vx.d(k2)=vx.d(k2)+ax.d(k2)*dt.d
  ay.d(k2)=ay.d(k2)+(sy.d(k1)-sy.d(k2))*grav.d(k1)/rr.d
  vy.d(k2)=vy.d(k2)+ay.d(k2)*dt.d
  az.d(k2)=az.d(k2)+(sz.d(k1)-sz.d(k2))*grav.d(k1)/rr.d
  vz.d(k2)=vz.d(k2)+az.d(k2)*dt.d
  sx.d(k1)=sx.d(k1)+vx.d(k1)*dt.d
  sy.d(k1)=sy.d(k1)+vy.d(k1)*dt.d
  sz.d(k1)=sz.d(k1)+vz.d(k1)*dt.d
  sx.d(k2)=sx.d(k2)+vx.d(k2)*dt.d
  sy.d(k2)=sy.d(k2)+vy.d(k2)*dt.d
  sz.d(k2)=sz.d(k2)+vz.d(k2)*dt.d
  ; LP zur Zeit t+dt:
  Lagrangepunkte(k1,k2)
  ; Geschwindigkeit der LP:
  For k=1 To 5
    vxl.d(k)=(sxl.d(k)-sxlalt.d(k))/dt.d
    vyl.d(k)=(syl.d(k)-sylalt.d(k))/dt.d
    vzl.d(k)=(szl.d(k)-szlalt.d(k))/dt.d
  Next k
  ; Koordinaten zurckschreiben:
  sx.d(k1)=sxalt.d(1)
  sy.d(k1)=syalt.d(1)
  sz.d(k1)=szalt.d(1)
  sx.d(k2)=sxalt.d(2)
  sy.d(k2)=syalt.d(2)
  sz.d(k2)=szalt.d(2)
  For k=1 To 5
    sxl.d(k)=sxlalt.d(k)
    syl.d(k)=sylalt.d(k)
    szl.d(k)=szlalt.d(k)
  Next k
  dt.d=dtalt.d
EndProcedure ; GeschwLP
;
Procedure Lagrangepunkte(k1,k2)
  ; Berechnung L1 - L5 fr Krper k1, k2
  ; x2-x1:
  dx.d=sx.d(k2)-sx.d(k1)
  dy.d=sy.d(k2)-sy.d(k1)
  dz.d=sz.d(k2)-sz.d(k1)
  ; Vorbereitung L1 - L3:
  tempa.d=m.d(k2)/(m.d(k1)+m.d(k2))
  tempb.d=Pow(tempa.d/3,1/3)
  tempc.d=1-7*tempa.d/12
  ; L1:
  temp.d=tempa.d+1-tempb.d
  sxl.d(1)=sx.d(k1)+temp.d*dx.d
  syl.d(1)=sy.d(k1)+temp.d*dy.d
  szl.d(1)=sz.d(k1)+temp.d*dz.d
  ; L2:
  temp.d=tempa.d+1+tempb.d
  sxl.d(2)=sx.d(k1)+temp.d*dx.d
  syl.d(2)=sy.d(k1)+temp.d*dy.d
  szl.d(2)=sz.d(k1)+temp.d*dz.d
  ; L3:
  sxl.d(3)=sx.d(k1)-tempc.d*dx.d
  syl.d(3)=sy.d(k1)-tempc.d*dy.d
  szl.d(3)=sz.d(k1)-tempc.d*dz.d
  ; Vorbereitung L4 - L5:
  tempa.d=dx.d*vx.d(k2)+dy.d*vy.d(k2)+dz.d*vz.d(k2)
  tempb.d=dx.d*dx.d+dy.d*dy.d+dz.d*dz.d
  rr.d=Sqr(tempb.d)
  temp.d=tempa.d/tempb.d ; (x2-x1)v2/(x2-x1)*(x2-x1)
  wx.d=vx.d(k2)-dx.d*temp.d
  wy.d=vy.d(k2)-dy.d*temp.d
  wz.d=vz.d(k2)-dz.d*temp.d
  ; w=0-Test
  If (wx.d=0) And (wy.d=0) And (wz.d=0)
    lagrstop=1
    ProcedureReturn
  EndIf
  ;
  temp.d=Sqr(3)*rr.d/(2*Sqr(wx.d*wx.d+wy.d*wy.d+wz.d*wz.d))
  ; L4:
  sxl.d(4)=0.5*(sx.d(k1)+sx.d(k2))+temp.d*wx.d
  syl.d(4)=0.5*(sy.d(k1)+sy.d(k2))+temp.d*wy.d
  szl.d(4)=0.5*(sz.d(k1)+sz.d(k2))+temp.d*wz.d
  ; L5:
  sxl.d(5)=0.5*(sx.d(k1)+sx.d(k2))-temp.d*wx.d
  syl.d(5)=0.5*(sy.d(k1)+sy.d(k2))-temp.d*wy.d
  szl.d(5)=0.5*(sz.d(k1)+sz.d(k2))-temp.d*wz.d
EndProcedure ; Lagrangepunkte
;
Procedure Schwerpunkt()
  If (gravob=2) And (kp>1)
    start=2
  Else
    start=1
  EndIf
  m.d(22)=0
  sx.d(22)=0
  sy.d(22)=0
  sz.d(22)=0
  For k=start To kp
    m.d(22)=m.d(22)+m.d(k)
    sx.d(22)=sx.d(22)+m.d(k)*sx.d(k)
    sy.d(22)=sy.d(22)+m.d(k)*sy.d(k)
    sz.d(22)=sz.d(22)+m.d(k)*sz.d(k)
  Next k
  sx.d(22)=sx.d(22)/m.d(22)
  sy.d(22)=sy.d(22)/m.d(22)
  sz.d(22)=sz.d(22)/m.d(22)
EndProcedure ; Schwerpunkt
;
Procedure Kreisbahn(k)
  v2.d=GeschwBetrag(k)
  If v2.d=0
    ProcedureReturn
  EndIf
  r1.d=RadiusBetrag(k)
  If r1.d=0
    ProcedureReturn
  EndIf
  r2.d=vx.d(k)*sx.d(k)+vy.d(k)*sy.d(k)+vz.d(k)*sz.d(k) ; Skalarprodukt
  temp.d=r2.d/(r1.d*r1.d)
  vx.d(k)=vx.d(k)-temp.d*sx.d(k)
  vy.d(k)=vy.d(k)-temp.d*sy.d(k)
  vz.d(k)=vz.d(k)-temp.d*sz.d(k)
  v1.d=Sqr(gamma.d*m.d(1)/r1.d) ; Sollgeschwindigkeit fr Kreisbahn
  temp.d=v1.d/v2.d
  vx.d(k)=vx.d(k)*temp.d
  vy.d(k)=vy.d(k)*temp.d
  vz.d(k)=vz.d(k)*temp.d
EndProcedure ; Kreisbahn
;
Procedure.l Hohmann(k)
  If dt.d<0
    ProcedureReturn 0
  EndIf
  Select k
    Case 1
      If Btst(26,KKK)
        k=pos(26)
      Else
        ProcedureReturn 0
      EndIf
    Case 2
      If Btst(27,KKK)
        k=pos(27)
      Else
        ProcedureReturn 0
      EndIf
    Case 3
      If Btst(28,KKK)
       k=pos(28)
      Else
        ProcedureReturn 0
      EndIf
  EndSelect
  r1.d=RadiusBetrag(k)
  v1.d=Sqr(gamma.d*m.d(1)/r1.d) ; Sollgeschwindigkeit fr Kreisbahn um Erde
  v2.d=GeschwBetrag(k)
  If Abs(v1.d-v2.d)>100
    If StartDrawing(ScreenOutput())
      Text(htxt$(15),1,0.8)
      Text(htxt$(16),1,0.82)
      StopDrawing()
      FlipBuffers(#PB_Screen_SmartSynchronization)
    EndIf
    Delay(3000)
    Kreisbahn(k)
  EndIf
  QQQ=Bset(27,QQQ)
  hohkp=kpr(k)
  If hohfak.d>1
    r3.d=0
  ElseIf hohfak.d<1
    r3.d=#riesig
  EndIf
  r2.d=r1.d*hohfak.d
  If r2.d<radius.d(24)
    r2.d=radius.d(24)
  EndIf
  v2.d=Sqr(2*gamma.d*m.d(1)*r2.d/(r1.d*(r1.d+r2.d))) ;  MNU Juli 1995, S.269
  temp.d=v2.d/v1.d
  vx.d(k)=vx.d(k)*temp.d
  vy.d(k)=vy.d(k)*temp.d
  vz.d(k)=vz.d(k)*temp.d
  Zustand(0,pos(hohkp))
  dt.d=Abs(dt.d)
  ProcedureReturn 1
EndProcedure ; Hohmann
;
Procedure ZusatzkraftEA(typ)
  If typ=-1
    SetMenuItemState(0,770+zusatztyp,0)
    SetMenuItemState(0,770,1)
    zusatztyp=0
    zusatzkp=0
    zusatzdauer.d=#riesig
    InfoL("")
    ProcedureReturn
  EndIf
  If (typ=0) And (zusatztyp=0)
    ProcedureReturn
  EndIf
  If (typ=zusatztyp) And (kpgad=pos(zusatzkp))
    ProcedureReturn
  EndIf
  SetMenuItemState(0,770+zusatztyp,0)
  zusatztyp=typ
  SetMenuItemState(0,770+zusatztyp,1)
  If typ>0
    zusatzkp=kpr(kpgad)
    Select typ
      Case 1
        InfoL(name$(kpgad)+": F const")
      Case 2
        InfoL(name$(kpgad)+": F ~ v")
      Case 3
        InfoL(name$(kpgad)+": F ~ v"+Chr(178))
    EndSelect
  Else
    zusatzkp=0
    InfoL("")
  EndIf
EndProcedure ; ZusatzkraftEA
;
Procedure Erdfeld(typ)
  gravob=typ
EndProcedure ; Erdfeld
;
;- KOLLISION
Procedure Kollisionsmatrix()
  For k=1 To 30
    For i=1 To 30
      koll.d(k,i)=radius.d(k)+radius.d(i)
    Next i
  Next
EndProcedure ; Kollisionsmatrix
;
Procedure.l Kollisionstest(xx.d,yy.d,zz.d,k,m)
  res=1
  For i=1 To kp
    If i<>k
      testdist.d=Pow(sx.d(i)-xx.d,2)+Pow(sy.d(i)-yy.d,2)+Pow(sz.d(i)-zz.d,2)
      testkoll.d=koll.d(kpr(i),kpr(k))
      testkoll.d=testkoll.d*testkoll.d
      If testdist.d<testkoll.d
        res=0
        Break
      EndIf
    EndIf
  Next i
  If (res=0) And (m=1)
    tit$="Kollision"
    txt$="Eingabe unzulssig wegen Kollision "
    txt$+name$(k)+" - "+name$(i)+".    "
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
  EndIf
  ProcedureReturn res
EndProcedure ; Kollisionstest
;
Procedure Kollisionsreaktion(k1,k2)
  If kpr(k1)=24
    kk=k2
  Else
    kk=k1
  EndIf
  If StartDrawing(ScreenOutput())
    DrawingMode(#PB_2DDrawing_Outlined)
    For i=30 To 50 Step 10
      Ellipse(ku(kk),kw(kk),i,asp.d*i,farbe(36))
    Next i
    StopDrawing()
    FlipBuffers(#PB_Screen_SmartSynchronization )
    Delay(500)
  EndIf
  If Btst(24,QQQ) And BtstI(22,23,QQQ)
    StossEA()
    kollweg=1
  EndIf
  If Btst(24,QQQ)
    If kp=2
      Entfernen(0,0)
    ElseIf k1>k2 ; Krper mit grerer Nummer zuerst entfernen wegen Nummernnderung
      Entfernen(k1,0)
      Entfernen(k2,0)
    Else
      Entfernen(k2,0)
      Entfernen(k1,0)
    EndIf
  Else ; sonst unelastischer Sto:
    If m.d(k1)>m.d(k2) ; Krper mit grerer Masse wird neuer Krper
      hin=k1
      weg=k2
    Else
      hin=k2
      weg=k1
    EndIf
    If kpr(k1)=24 ; Aber: Erde (geozentrisch) wird immer neuer Krper
      hin=k1
      weg=k2
    ElseIf kpr(k2)=24
      hin=k2
      weg=k1
    EndIf
    temp.d=m.d(hin)+m.d(weg)
    vx.d(hin)=(m.d(hin)*vx.d(hin)+m.d(weg)*vx.d(weg))/temp.d
    vy.d(hin)=(m.d(hin)*vy.d(hin)+m.d(weg)*vy.d(weg))/temp.d
    vz.d(hin)=(m.d(hin)*vz.d(hin)+m.d(weg)*vz.d(weg))/temp.d
    m.d(hin)=temp.d
    Entfernen(weg,0)
  EndIf
  If kollweg=1
    StossEA()
  EndIf
EndProcedure ; Kollisionsreaktion
;
Procedure StossEA()
  QQQ=Bchg(24,QQQ)
  If Btst(24,QQQ)
    SetMenuItemState(0,578,1)
    txt$="Kollidierte Krper werden entfernt"
  Else
    SetMenuItemState(0,578,0)
    txt$="Kollidierte Krper werden nicht entfernt"
  EndIf
  InfoMo(txt$)
EndProcedure ; StossEA
;
Procedure ReduzierungEA(typ)
  QQQ=Bchg(26,QQQ)
  If Btst(26,QQQ)
    QQQ=Bclr(25,QQQ)
    reduztmp=0
  EndIf
  If typ=0
    If Btst(26,QQQ)
      SetMenuItemState(0,579,1)
      txt$="Zeitschrittreduzierung ausgeschaltet"
    Else
      SetMenuItemState(0,579,0)
      txt$="Zeitschrittreduzierung eingeschaltet"
    EndIf
    InfoMo(txt$)
  EndIf
EndProcedure ; ReduzierungEA
;
;- BILD
Procedure.l Bildweite()
  ExamineDesktops()
  ProcedureReturn DesktopWidth(0)
EndProcedure ; Bildweite
;
Procedure.l Bildhoehe()
  ExamineDesktops()
  ProcedureReturn DesktopHeight(0)
EndProcedure ; Bildhoehe
;
Procedure.l Bildtiefe()
  ExamineDesktops()
  ProcedureReturn DesktopDepth(0)
EndProcedure ; Bildtiefe
;
Procedure Geometrie(typ)
  If typ=1
    asptmp.d=aspbild.d
  Else   
    asptmp.d=aspdruck.d
  EndIf
  aspvor.d=asptmp.d
  quit=0
  alpha.d=0
  f.d=1000
  fbtmp=farbe(36)
  farbe(36)=0
  Repeat
    u=Int(f.d*Cos(alpha.d)+spalten.d/2)
    w=Int(f.d*Sin(alpha.d)*asptmp.d+zeilen.d/2)
    If (u>0) And (u<spaltenl) And (w>0) And (w<zeilenl)
      alpha.d+0.001
    Else
      f.d=f.d-1
      alpha.d=0
    EndIf
  Until alpha.d>2*#PI
  f.d=f.d*0.75
  BildEA(0)
  ClearScreen(RGB(255,255,255))
  Repeat
    ClearScreen(RGB(255,255,255))
    If StartDrawing(ScreenOutput())
      Text(programmtitel$,1,0.35)
      If typ=1
        Text(htxt$(17),1,0.55)
        Text(htxt$(18),1,0.6)
      Else
        Text(htxt$(19),1,0.55)
        Text(htxt$(20),1,0.6)
      EndIf  
      Text(htxt$(21),1,0.58)
      If sp
        Text(htxt$(24),1,0.64)
        Text(bildpfad$,1,0.66)
      EndIf
      FrontColor(RGB(0,0,0))
      alpha.d=0
      Circle(Int(uoff.d),Int(woff.d),2)
      Repeat
        u=Int(f.d*Cos(alpha.d)+spalten.d/2)
        w=Int(f.d*Sin(alpha.d)*asptmp.d+zeilen.d/2)
        If (u>0) And (u<spaltenl) And (w>0) And (w<zeilenl)
          Box(u,w,1,1)
        EndIf
        alpha.d+0.001
      Until alpha.d>2*#PI
      StopDrawing()
      FlipBuffers(#PB_Screen_SmartSynchronization )
    Else
      BildEA(2)
      farbe(36)=fbtmp
      ProcedureReturn
    EndIf
    Repeat
      ExamineKeyboard()
    Until KeyboardPushed(#PB_Key_All)
    If KeyboardPushed(#PB_Key_Up)
      asptmp.d=asptmp.d+0.005
      asptmp.d=MinD(asptmp.d,5)
      sp=0
      Delay(100)
    ElseIf KeyboardPushed(#PB_Key_Down)
      asptmp.d=asptmp.d-0.005
      asptmp.d=MaxD(asptmp.d,0.2)
      sp=0
      Delay(100)
    ElseIf KeyboardPushed(#PB_Key_F2)
      quit=2
    ElseIf KeyboardPushed(#PB_Key_P) And (typ=2)
      Delay(500)
      BildSpeichern(1)
      sp=1
      BildDrucken(1)
    ElseIf KeyboardPushed(#PB_Key_S) And (typ=2)
      Delay(500)
      BildSpeichern(1)
      sp=1
    ElseIf KeyboardPushed(#PB_Key_Escape)
      quit=1
    EndIf
  Until quit>0
  BildEA(2)
  farbe(36)=fbtmp
  If quit=2
    If typ=1
      aspbild.d=asptmp.d
      asp.d=asptmp.d
      ProjPar()
    Else
      aspdruck.d=asptmp.d  
    EndIf
    ConfigSpeichern(1)
  EndIf
EndProcedure ; Geometrie
;
Procedure BildEA(typ)
  Select typ
    Case 0,1
      If OpenScreen(spaltenl,zeilenl,tiefe,programmtitel$)=0
        txt$="Der bentigte Bildschirm konnte nicht geffnet werden.    "+exit$
        MessageRequester(programmtitel$,txt$,#MB_ICONSTOP)
        Programmende()
      EndIf
      If typ=1
        ClearScreen(farbe(31))
        GrabSprite(200,0,0,spaltenl,zeilenl,0)
        SpriteErzeugen()
      EndIf
      KeyboardMode(#PB_Keyboard_International)
      QQQ=Bset(1,QQQ)
      dtvorscr.d=dt.d
      dtvorred.d=dt.d
      reduz=Btst(26,QQQ)
      scrtmout=ScrTimeOut()
    Case 2
      QQQ=Bclr(1,QQQ)
      QQQ=Bclr(14,QQQ)
      QQQ=Bclr(15,QQQ)
      QQQ=Bclr(25,QQQ)
      reduztmp=0
      If reduz
        QQQ=Bset(26,QQQ)
      Else
        QQQ=Bclr(26,QQQ)
      EndIf
      If IsSprite(500)
        FreeSprite(500)
        foto=0
      EndIf
      dt.d=dtvorscr.d
      diffstartstop.d=Abs(startzeit.d-stopzeit.d)
      ClearScreen(farbe(0))
      FlipBuffers(#PB_Screen_SmartSynchronization)
      ClearScreen(farbe(0))
      Delay(200)
      CloseScreen()
      SetForegroundWindow_(WinID)
    EndSelect
EndProcedure ; BildEA
;
Procedure.l ScrTimeOut()
  *bufa=AllocateMemory(255)
  *bufb=AllocateMemory(255)
  *bufc=AllocateMemory(255)
  If (*bufa=0) Or (*bufb=0) Or (*bufc=0)
    ProcedureReturn #inaktiv*60
  EndIf
  bfa=*bufa
  bfb=*bufb
  bfc=*bufc
  sbk$="Control Panel\Desktop"
  val$="ScreenSaveTimeOut"
  typ=#REG_SZ
  If RegOpenKeyEx_(#HKEY_CURRENT_USER,@sbk$,0,#KEY_QUERY_VALUE,@*bufa)<>0
    ProcedureReturn #inaktiv*60
  EndIf
  If RegQueryValueEx_(*bufa,@val$,0,@typ,@*bufb,@*bufc)<>0
    ProcedureReturn #inaktiv*60
  EndIf
  RegCloseKey_(*bufa)
  FreeMemory(bfa)
  FreeMemory(bfb)
  FreeMemory(bfc)
  ProcedureReturn Val(PeekS(@*bufb))
EndProcedure ; ScrTimeOut
;
Procedure SpriteErzeugen()
  For k=1 To 30
    SpriteKoerper(k,bldzoom*bldrad(k),farbe(k))
  Next k
  SpritePunkt(22,farbe(22))
  SpritePunkt(23,farbe(23))
EndProcedure ; SpriteErzeugen
;
Procedure SpriteKoerper(n,r,f,m=#PB_2DDrawing_Default)
  If Btst(n,KKK)=0
    ProcedureReturn
  EndIf
  If IsSprite(n)
    FreeSprite(n)
  EndIf
  r=MinL(r,2*spaltenl)
  If n=24
    aspr=Int(asp.d*r)
    coaspr=Int(cob.d*aspr)
    If coaspr=0
      coaspr=1
    EndIf
  Else
    aspr=r
  EndIf
  If CreateSprite(n,2*r+4,2*aspr+4,0)
    If StartDrawing(SpriteOutput(n))
      DrawingMode(m)
      Ellipse(r+2,aspr+2,r,aspr,f)
      If n=24
        Ellipse(r+2,aspr+2,r+1,aspr+1,f)
        If breite.d<0.004
          Ellipse(r+2,aspr+2,r,coaspr,f) ; quator
        EndIf
        DrawingMode(#PB_2DDrawing_Default)
        Box(r,aspr,4,4,f) ; Erdmittelpunkt
      EndIf
      StopDrawing()
    Else
      fhl=1
    EndIf
  Else
    fhl=1
  EndIf
  If fhl
    BildEA(2)
    tit$=programmtitel$+": Bildfehler"
    txt$="Fehler bei der Erzeugung des Bildes fr "
    If (n>11 And n<19) Or (n>28)
      txt$+"Krper "
    EndIf
    txt$+datname$(n)+".    "+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
EndProcedure ; SpriteKoerper
;
Procedure SpritePunkt(n,f)
  If (n=22) And (Btst(9,QQQ)=0)
    ProcedureReturn
  EndIf
  If (n=23) And (Btst(28,QQQ)=0)
    ProcedureReturn
  EndIf
  If IsSprite(n)
    FreeSprite(n)
  EndIf
  If CreateSprite(n,13,13,0) And StartDrawing(SpriteOutput(n))
    DrawingMode(#PB_2DDrawing_Default)
    LineXY(1,7,13,7,f)
    LineXY(7,1,7,13,f)
    StopDrawing()
  Else
    BildEA(2)
    tit$=programmtitel$+": Bildfehler"
    txt$="Fehler bei der Erzeugung "
    If n=22
      txt$+"des Bildes fr den Schwerpunkt.    "
    ElseIf n=23
      txt$+"der Bilder fr die Lagrangepunkte.    "
    EndIf
    txt$+exit$
    MessageRequester(tit$,txt$,#MB_ICONSTOP)
    Programmende()
  EndIf
EndProcedure ; SpritePunkt
;
Procedure BildAnzeigen(typ,rkn)
  If typ=1
    BildEA(1)
  EndIf
  bahn=1-Btst(6,QQQ)
  schw=Btst(9,QQQ)
  lagr=Btst(28,QQQ)
  inakt=MinL(#inaktiv*60,scrtmout-5)
  rptstart=UTC()
  If lagr
    Lagrangepunkte(pos(lagr1),pos(lagr2))
    If lagrstop=1
      lagr=0
      lagrstop=0
      LagrangeEA(0,0,76)
    EndIf
  EndIf
  ;
  Repeat
    Zeichnen(bahn,0,schw,lagr,rkn)
    If IsSprite(500)
      DisplaySprite(500,50,50)
    EndIf
    If StartDrawing(ScreenOutput())
      If Btst(15,QQQ)
        Text(Space(3)+fotopart$(foto),0,0.02)
      EndIf
      If Btst(27,QQQ)
        Text(htxt$(26),1,0.94)
      ElseIf Btst(12,QQQ)
        zl=0
        If BtstI(26,28,KKK) Or Btst(28,QQQ)
          zl=25
        EndIf      
        Box(120,zeilenl-110-zl,spaltenl-240,95+zl,farbe(31))
        DrawingMode(#PB_2DDrawing_Outlined)
        Box(120,zeilenl-110-zl,spaltenl-240,95+zl,farbe(36))
        If zl=25
          Line(120,zeilenl-110,spaltenl-240,0,farbe(36))
        EndIf
        If BtstI(22,23,QQQ)
          Text(htxt$(1),1,0.90)
          Text(htxt$(8),1,0.92)
          Text(htxt$(9),1,0.94)   
          Text(htxt$(10),1,0.96)
        ElseIf Btst(5,QQQ)
          If Btst(28,QQQ) And BtstI(26,28,KKK)
            Text(htxt$(11),1,0.872)        
          ElseIf Btst(28,QQQ)
            Text(htxt$(5),1,0.872)
          ElseIf BtstI(26,28,KKK)
            Text(htxt$(7),1,0.872)
          EndIf
          Text(htxt$(1),1,0.90)
          Text(htxt$(2),1,0.92)
          Text(htxt$(3),1,0.94) 
          Text(htxt$(6),1,0.96) 
        Else
          If Btst(28,QQQ)
            Text(htxt$(5),1,0.872)
          EndIf
          Text(htxt$(1),1,0.90)
          Text(htxt$(2),1,0.92) 
          Text(htxt$(3),1,0.94)
          Text(htxt$(4),1,0.96)  
        EndIf
      EndIf
      StopDrawing()
      FlipBuffers(#PB_Screen_SmartSynchronization)
    EndIf
    ;
    ExamineKeyboard()
    Delay(10)
    If (KeyboardPushed(#PB_Key_LeftControl) Or KeyboardPushed(#PB_Key_RightControl) Or KeyboardPushed(#PB_Key_LeftAlt) Or KeyboardPushed(#PB_Key_RightAlt)) And (Btst(27,QQQ)=0)
      BildEA(2)
      quit=1  
    ElseIf KeyboardPushed(#PB_Key_F1)
      InfoHilfe(0)
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F2)
      NamenEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F3)
      AchsenEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F4)
      ZeitEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F6) And (kp>0)
      BahnrechnungB(1)
      quit=1
    ElseIf KeyboardPushed(#PB_Key_F7) And (kp>0)
      If Btst(27,QQQ)=0
        BahnrechnungB(-1)
        quit=1
      Else
        rkn=0
        rptstart=UTC()
      EndIf
    ElseIf KeyboardPushed(#PB_Key_F9)
      If Btst(27,QQQ)=0
        BahnWeg()
        bcnt=0
        bcntmax=0
        wcnt=0
        For i=0 To bahnpunkte
          sxb.d(i)=0
          syb.d(i)=0
          szb.d(i)=0
          fb.b(i)=0
          cb.b(i)=0
          mb.b(i)=0
          sxw.d(i)=0
          syw.d(i)=0
          szw.d(i)=0
          phw.d(i)=0
        Next i
        Delay(500)
        bahnweg=1
      Else
        rkn=0
        rptstart=UTC()
      EndIf
    ElseIf KeyboardPushed(#PB_Key_F10)
      BildbreiteEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F11)
      ZeitschrittEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_F12) And (Btst(5,QQQ)=0)
      ReduzierungEA(1)
      dt.d=dtvorred.d
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf (KeyboardPushed(#PB_Key_F)) And (Btst(6,QQQ)=0)
      FahrstrahlEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_E) And (blick<>1) And (brttmp<14)
      Blickrichtung(1)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_X) And (blick<>2) And (brttmp<14)
      Blickrichtung(2)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Y) And (blick<>3) And (brttmp<14)
      Blickrichtung(3)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Z) And (blick<>4) And (brttmp<14)
      Blickrichtung(4)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_S) And (blick<>5) And (brttmp<14)
      Blickrichtung(5)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_L)
      NamenLagrEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_G)
      GeschwindigkeitEA()
      Delay(500)
      rkn=0
      rptstart=UTC()  
    ElseIf KeyboardPushed(#PB_Key_N)
      NamenAbbEA()
      Delay(500)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_5) And (Btst(25,QQQ)=0)
      dt.d=dt.d/1.01
      dtvorred.d=dt.d
      QQQ=Bset(16,QQQ)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_6) And (Btst(25,QQQ)=0)
      dt.d=dt.d*1.01
      dtvorred.d=dt.d
      QQQ=Bset(16,QQQ)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_T)
      If dt.d<0
        dt.d=-dtvorscr.d
      Else
        dt.d=dtvorscr.d
      EndIf
      dtvorred.d=dt.d
      QQQ=Bclr(25,QQQ)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_Up)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Up) And KeyboardPushed(#PB_Key_V)
      woff.d=woff.d-bildschritt.d
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_Down)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Down) And KeyboardPushed(#PB_Key_V)
      woff.d=woff.d+bildschritt.d
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_Left)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Left) And KeyboardPushed(#PB_Key_V)
      uoff.d=uoff.d-bildschritt.d
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_Right)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Right) And KeyboardPushed(#PB_Key_V)
      uoff.d=uoff.d+bildschritt.d
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_R) And KeyboardPushed(#PB_Key_V)
      uoff.d=uoffcfg.d
      If brttmp>13
        woff.d=WoffErde()
      Else
        woff.d=woffcfg.d
      EndIf
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_PageUp) And KeyboardPushed(#PB_Key_B)
      Spritegroesse(1)
      SpriteErzeugen()
      Delay(10)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_PageDown) And KeyboardPushed(#PB_Key_B)
      Spritegroesse(2)
      SpriteErzeugen()
      Delay(10)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_R) And KeyboardPushed(#PB_Key_B)
      Spritegroesse(0)
      SpriteErzeugen()
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_PageUp) And (brttmp<14)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_PageUp) And (brttmp<14)
      If breite.d>0.0002
        Zoom(1-bildschritt.d/100)
        rkn=2
      Else
        rkn=0
      EndIf
      bahnweg=1
      rptstart=UTC()
    ElseIf KeyboardReleased(#PB_Key_PageDown) And (brttmp<14)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_PageDown) And (brttmp<14)
      If breite.d<1000
        Zoom(1+bildschritt.d/100)
        rkn=2
      Else
        rkn=0
      EndIf
      bahnweg=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_H) And KeyboardPushed(#PB_Key_1)
      If Hohmann(1)
        BahnrechnungB(1)
        quit=1
      Else
        rkn=0
        rptstart=UTC()
      EndIf
    ElseIf KeyboardPushed(#PB_Key_H) And KeyboardPushed(#PB_Key_2)
      If Hohmann(2)
        BahnrechnungB(1)
        quit=1
      Else
        rkn=0
        rptstart=UTC()
      EndIf
    ElseIf KeyboardPushed(#PB_Key_H) And KeyboardPushed(#PB_Key_3)
      If Hohmann(3)
        BahnrechnungB(1)
        quit=1
      Else
        rkn=0
        rptstart=UTC()
      EndIf
    ElseIf KeyboardPushed(#PB_Key_1) And (bezug<>0) And (bgad(1)=0)
      BezugBild(0)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_2) And (bezug<>1) And (bgad(2)=0)
      BezugBild(1)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_3) And (bezug<>4) And (bezug<>24) And (bgad(3)=0)
      BezugBild(4)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_4) And (bezug<>22) And (bgad(4)=0)
      BezugBild(22)
      bahnweg=1
      rkn=1
      rptstart=UTC()
    ;ElseIf KeyboardReleased(#PB_Key_Up) etc.: bei V+up etc.
    ElseIf KeyboardPushed(#PB_Key_Up) And (brttmp<14)
      Blickrichtung(11)
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Down) And (brttmp<14)
      Blickrichtung(12)
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Left) And (brttmp<14)
      Blickrichtung(13)
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Right) And (brttmp<14)
      Blickrichtung(14)
      bahnweg=1
      rkn=2
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_P)
      BildSpeichern(0)
      Repeat
        ExamineKeyboard()
      Until KeyboardPushed(#PB_Key_All)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Insert)
      QQQ=Bclr(15,QQQ)
      If IsSprite(500)
        FreeSprite(500)
      EndIf
      If foto<fotozahl
        foto+1
      Else
        foto=1
      EndIf
      If LoadSprite(500,fotoname$(foto),0)
        ClipSprite(500,0,0,spaltenl-100,zeilenl-100)
      EndIf
      Delay(300)
      rkn=0
      rptstart=UTC()
    ElseIf KeyboardPushed(#PB_Key_Delete) And IsSprite(500)
      QQQ=Bclr(15,QQQ)
      FreeSprite(500)
      foto=0
      rkn=0
      rptstart=UTC()
    ElseIf UTC()-rptstart>inakt
      BildEA(2)
      quit=1
      txt$="Die Anzeige wurde nach lngerer Inaktivitt geschlossen.    "
      MessageRequester(programmtitel$,txt$,#MB_ICONINFORMATION)
    ElseIf (KeyboardPushed(#PB_Key_Escape) And (Btst(27,QQQ)=0))
      BildEA(2)
      quit=1
    EndIf
  Until quit=1
EndProcedure ; BildAnzeigen
;
Procedure Zeichnen(bhn,fhr,shw,lgg,rkn)
  Schwerpunkt()
  ; Fahrstrahlzentrum:
  If fhr=1
    If Btst(1,KKK)
      fahrkp=pos(1)
    ElseIf Btst(24,KKK)
      fahrkp=1
    Else
      fhr=0
    EndIf
  EndIf
  ; Bahnfarbe:
  If Btst(27,QQQ)
    frbplot(pos(hohkp))=37
  Else
    frbplot(pos(hohkp))=32
  EndIf
  ; Bildschirmkoordinaten berechnen:
  pox.d=sx.d(posbzg)
  poy.d=sy.d(posbzg)
  poz.d=sz.d(posbzg)
  bcnt+1
  If bcnt+kp+2>bahnpunkte
    bcntmax=bcnt
    bcnt=1
  EndIf
  sxb.d(bcnt)=sx.d(22)
  syb.d(bcnt)=sy.d(22)
  szb.d(bcnt)=sz.d(22)
  bcnt+1
  sxb.d(bcnt)=phi.d
  For k=1 To kp
    bcnt+1
    sxb.d(bcnt)=sx.d(k)
    syb.d(bcnt)=sy.d(k)
    szb.d(bcnt)=sz.d(k)
    If BtstI(22,23,QQQ) And (k>1)
      wcnt+1
      If wcnt+2>bahnpunkte
        wcntmax=wcnt
        wcnt=0
      EndIf
      sxw.d(wcnt)=sx.d(k)
      syw.d(wcnt)=sy.d(k)
      szw.d(wcnt)=sz.d(k)
      phw.d(wcnt)=phi.d
    EndIf
    xxx.d=sxb.d(bcnt)-pox.d
    yyy.d=syb.d(bcnt)-poy.d
    zzz.d=szb.d(bcnt)-poz.d
    ku(k)=UU(xxx.d,yyy.d,zzz.d)
    kw(k)=WW(xxx.d,yyy.d,zzz.d)
    kh(k)=HH(xxx.d,yyy.d,zzz.d)
    If (rtcmp=1) And (k>1)
      templb=UUR(ku(k),kw(k),ku(1),kw(1),phi.d)
      kw(k)=WWR(ku(k),kw(k),ku(1),kw(1),phi.d)
      ku(k)=templb
    EndIf
    If (fhr=1) And (k<>fahrkp)
      fb.b(bcnt)=1
    EndIf
    cb.b(bcnt)=frbplot(k)
    If kpr(k)=11
      mb.b(bcnt)=pos(4)
    EndIf
  Next k
  If shw
    xxx.d=sx.d(22)-pox.d
    yyy.d=sy.d(22)-poy.d
    zzz.d=sz.d(22)-poz.d
    uschw=UU(xxx.d,yyy.d,zzz.d)
    wschw=WW(xxx.d,yyy.d,zzz.d)
  EndIf
  If lgg
    For i=1 To 5
      xxx.d=sxl.d(i)-pox.d
      yyy.d=syl.d(i)-poy.d
      zzz.d=szl.d(i)-poz.d
      lu(i)=UU(xxx.d,yyy.d,zzz.d)
      lw(i)=WW(xxx.d,yyy.d,zzz.d)
    Next i
  EndIf
  ;
  If Btst(21,QQQ)
    xgeo.d=sx.d(21)-pox.d
    ygeo.d=sy.d(21)-poy.d
    zgeo.d=sz.d(21)-poz.d
    ugeo=UU(xgeo.d,ygeo.d,zgeo.d)
    wgeo=WW(xgeo.d,ygeo.d,zgeo.d)
    If rtcmp
      templb=UUR(ugeo,wgeo,ku(1),kw(1),phi.d)
      wgeo=WWR(ugeo,wgeo,ku(1),kw(1),phi.d)
      ugeo=templb
    EndIf
  EndIf
  ; Mondbahnzoom:
  If (Btst(11,KKK)=1) And (mondzoom.d<>1)
    dx.d=mondzoom.d*(sx.d(pos(11))-sx.d(pos(4)))+sx.d(pos(4))
    dy.d=mondzoom.d*(sy.d(pos(11))-sy.d(pos(4)))+sy.d(pos(4))
    dz.d=mondzoom.d*(sz.d(pos(11))-sz.d(pos(4)))+sz.d(pos(4))
    xxx.d=dx.d-pox.d
    yyy.d=dy.d-poy.d
    zzz.d=dz.d-poz.d
    ku(pos(11))=UU(xxx.d,yyy.d,zzz.d)
    kw(pos(11))=WW(xxx.d,yyy.d,zzz.d)
    kh(pos(11))=HH(xxx.d,yyy.d,zzz.d)
  EndIf
  ;
  If bahnweg=1 ; fr Zoom, Blickumschaltung etc.
    ClearScreen(farbe(31))
    bahnweg=0
  Else
    DisplaySprite(200,0,0)
  EndIf
  If StartDrawing(ScreenOutput())
    For k=1 To kp
      If (fhr=1) And (k<>fahrkp) And (kpr(k)<>11)
        LineXY(ku(fahrkp),kw(fahrkp),ku(k),kw(k),farbe(33)) ; Fahrstrahl
        QQQ=Bset(2,QQQ)
      EndIf
      If bhn
        If (ku(k)>0) And (ku(k)<spaltenl) And (kw(k)>0) And (kw(k)<zeilenl)
          Box(ku(k),kw(k),1,1,farbe(frbplot(k))) ; Bahn
          QQQ=Bset(2,QQQ)
        EndIf
      EndIf
    Next k
    If (shw=1) And (gravob=0)
      If (Btst(6,QQQ)=0) And (uschw>0) And (uschw<spaltenl) And (wschw>0) And (wschw<zeilenl)
        Box(uschw,wschw,1,1,farbe(34)) ; Schwerpunktbahn
        QQQ=Bset(2,QQQ)
      EndIf
    EndIf
    If (rkn>0) And (bcnt>0) And (Btst(6,QQQ)=0)
      If BtstI(22,23,QQQ)
        RekonstruierenW()
      Else
        Rekonstruieren(rkn-1)
      EndIf
    EndIf
    StopDrawing()
  EndIf
  If Btst(3,QQQ)=0
    bcnt-kp-2
  EndIf
  If IsSprite(200)
    FreeSprite(200)
  EndIf
  GrabSprite(200,0,0,spaltenl,zeilenl,0)
  ;
  If Btst(21,QQQ)
    erad=Int(projx.d*radius.d(24))
    asperad=Int(asp.d*projx.d*radius.d(24))
    If Btst(22,QQQ)
      If StartDrawing(ScreenOutput())
        DrawingMode(#PB_2DDrawing_Outlined)
        Ellipse(ku(1),kw(1),erad,asperad,farbe(24)) ; statt Sprite (i. a. zu gro)
        Ellipse(ku(1),kw(1),erad+1,asperad+1,farbe(24))
        StopDrawing()
      EndIf
      SpriteKoerper(24,1,0,#PB_2DDrawing_Outlined) ; "Dummy" (transparent) wegen Index() etc.
    ElseIf Btst(23,QQQ)
      If StartDrawing(ScreenOutput())
        DrawingMode(#PB_2DDrawing_Outlined)
        LineXY(0,kw(1)-asperad,spaltenl,kw(1)-asperad,farbe(24))
        LineXY(0,kw(1)-asperad+1,spaltenl,kw(1)-asperad+1,farbe(24))
        StopDrawing()
      EndIf
      SpriteKoerper(24,1,0,#PB_2DDrawing_Outlined) ; s.o.
    Else
      SpriteKoerper(24,erad,farbe(24),#PB_2DDrawing_Outlined) ; statt Sprite 24
    EndIf
  EndIf
  Index()
  For k=1 To kp
    hik=hind(k)
    nuk=spritenum(hik)
    ukorr=SpriteWidth(nuk)/2
    wkorr=SpriteHeight(nuk)/2
    DisplayTransparentSprite(nuk,ku(hik)-ukorr,kw(hik)-wkorr)
  Next k
  If shw
    DisplayTransparentSprite(22,uschw-7,wschw-7)
  EndIf
  If lgg
    For i=1 To 5
      DisplayTransparentSprite(23,lu(i)-7,lw(i)-7)
    Next i
  EndIf
  If StartDrawing(ScreenOutput())
    If Btst(7,QQQ)
      Geschwindigkeit()
    EndIf  
    If Btst(11,QQQ)
      Achsen() ; Achsen
    EndIf
    If BtstI(13,14,QQQ)
      Namen(Btst(13,QQQ),shw*Btst(13,QQQ),Btst(14,QQQ)) ; Namen
    EndIf
    If Btst(10,QQQ)
      If Btst(21,QQQ)
        Text(Datum(1),1,0.03)
      Else
        Text(Datum(2),1,0.03)
      EndIf
    EndIf
    If Btst(16,QQQ) Or Btst(25,QQQ)
      If Abs(dt.d)>=1
        Text("Zeitschritt = "+StrDD(dt.d,0)+" s",2,0.03)
      ElseIf Abs(dt.d)>=0.000001
        Text("Zeitschritt = "+StrDD(dt.d,6)+" s",2,0.03)
      Else
         Text("Zeitschritt < 0.000001 s",2,0.03)
      EndIf
    EndIf
    If (Btst(26,QQQ)=1) And (Btst(5,QQQ)=0)
      Text(" Reduzierung AUS ",2,0.01,#PB_2DDrawing_XOr)
    EndIf
    If Btst(17,QQQ)
      If Btst(22,QQQ)
        Text("Bildbreite = 1000 km",0,0.03)
      ElseIf Btst(23,QQQ)
        If labor
          Text("Bildbreite = 10 m",0,0.03)
        Else
          Text("Bildbreite = 1000 m",0,0.03)
        EndIf
      ElseIf breite.d>0.1
        Text("Bildbreite = "+StrDD(breite.d,1)+" AE",0,0.03)
      Else
        brtkm.d=breite.d*#ae/1000
        Text("Bildbreite = "+StrDD(brtkm.d,0)+" km",0,0.03)
      EndIf
    EndIf
    If Btst(3,QQQ)=0
      If Btst(30,QQQ)
        txt$=" Gravitationskonstante:  "
        txt$+StrE(gamma.d,6)
        txt$+" m"+Chr(179)+" / ( kg"+Chr(183)+"s"+Chr(178)+" ) "; m^3/(kg*s^2)"
        Text(txt$,1,0.01,#PB_2DDrawing_XOr)
      EndIf
    EndIf
    If (Btst(21,QQQ)=1) And (Btst(23,QQQ)=0) And (rtcmp=0) And (rtstp=0)
      DrawingMode(#PB_2DDrawing_Outlined)
      If (ugeo>4) And (ugeo<spaltenl) And (wgeo>4) And (wgeo<zeilenl) And (breite.d<0.004)
        Box(ugeo-5,wgeo-5,10,10,farbe(21)) ; quatormarke
      EndIf
    EndIf
    StopDrawing()
  EndIf
EndProcedure ; Zeichnen
;
Procedure Rekonstruieren(typ)
  mxb=MaxL(bcnt,bcntmax)-kp+1
  kadd=kp+typ*rknschritt*(kp+2)
  fax.d=sx.d(fahrkp)
  fay.d=sy.d(fahrkp)
  faz.d=sz.d(fahrkp)
  k=1
  Repeat
    If posbzg=0
      pox.d=0
      poy.d=0
      poz.d=0
    ElseIf posbzg=22
      pox.d=sxb.d(k)
      poy.d=syb.d(k)
      poz.d=szb.d(k)
    Else
      pox.d=sxb.d(k+1+posbzg)
      poy.d=syb.d(k+1+posbzg)
      poz.d=szb.d(k+1+posbzg)
    EndIf
    If Btst(9,QQQ)
      xxx.d=sxb.d(k)-pox.d
      yyy.d=syb.d(k)-poy.d
      zzz.d=szb.d(k)-poz.d
      u=UU(xxx.d,yyy.d,zzz.d)
      w=WW(xxx.d,yyy.d,zzz.d)
      If (u>0) And (u<spaltenl) And (w>0) And (w<zeilenl)
        Box(u,w,1,1,farbe(34)) ; Schwerpunktbahn
      EndIf
    EndIf
    k+1
    phib.d=sxb.d(k)
    kk=k+kp
    k+1
    For i=k To kk
      xxx.d=sxb.d(i)-pox.d
      yyy.d=syb.d(i)-poy.d
      zzz.d=szb.d(i)-poz.d
      u=UU(xxx.d,yyy.d,zzz.d)
      w=WW(xxx.d,yyy.d,zzz.d)
      If (rtcmp=1) And (i>k)
        urt=UU(0,0,0)
        wrt=WW(0,0,0)
        templb=UUR(u,w,urt,wrt,phib.d)
        w=WWR(u,w,urt,wrt,phib.d)
        u=templb
      EndIf
      ; Mondbahnzoom:
      If (mb.b(i)>0) And (mondzoom.d<>1)
        bb=k+mb.b(i)-1
        xxx.d=(sxb.d(i)-sxb.d(bb))*mondzoom.d+sxb.d(bb)-pox.d
        yyy.d=(syb.d(i)-syb.d(bb))*mondzoom.d+syb.d(bb)-poy.d
        zzz.d=(szb.d(i)-szb.d(bb))*mondzoom.d+szb.d(bb)-poz.d
        u=UU(xxx.d,yyy.d,zzz.d)
        w=WW(xxx.d,yyy.d,zzz.d)
      EndIf
      If (u>0) And (u<spaltenl) And (w>0) And (w<zeilenl)
        Box(u,w,1,1,farbe(cb.b(i))) ; Bahn
        If typ=0
          If fb.b(i)=1
            xxx.d=fax.d-pox.d
            yyy.d=fay.d-poy.d
            zzz.d=faz.d-poz.d
            uf=UU(xxx.d,yyy.d,zzz.d)
            wf=WW(xxx.d,yyy.d,zzz.d)
            LineXY(uf,wf,u,w,farbe(33)) ; Fahrstrahl
          EndIf
        EndIf
      EndIf
    Next i
    k+kadd
  Until k>mxb
EndProcedure ; Rekonstruieren
;
Procedure RekonstruierenW()
  i=1
  Repeat
    xxx.d=sxw.d(i)
    yyy.d=syw.d(i)
    zzz.d=szw.d(i)
    phib.d=phw.d(i)
    u=UU(xxx.d,yyy.d,zzz.d)
    w=WW(xxx.d,yyy.d,zzz.d)
    If rtcmp
      urt=UU(0,0,0)
      wrt=WW(0,0,0)
      templb=UUR(u,w,urt,wrt,phib.d)
      w=WWR(u,w,urt,wrt,phib.d)
      u=templb
    EndIf
    If (u>0) And (u<spaltenl) And (w>0) And (w<zeilenl)
      Box(u,w,1,1,farbe(32)) ; Bahn
    EndIf
    i+1
  Until i>wcnt
EndProcedure ; RekonstruierenW
;
Procedure Achsen()
  DrawingMode(#PB_2DDrawing_Transparent)
  FrontColor(farbe(35))
  If Btst(22,QQQ)
    poxl.d=-400000
    poxr.d=400000
    poy.d=radius.d(24)
    poz.d=0
    lp(1)=UU(poxl.d,poy.d,poz.d)
    lp(2)=WW(poxl.d,poy.d,poz.d)
    lp(3)=UU(poxr.d,poy.d,poz.d)
    lp(4)=WW(poxr.d,poy.d,poz.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; tangentiale Achse
    For i=1 To 8
      lp(5)=lp(1)+i*(lp(3)-lp(1))/8
      lp(6)=lp(2)+4
      lp(7)=lp(2)-4
      LineXY(lp(5),lp(6),lp(5),lp(7))
      If i=1
        DrawText(lp(5)-20,lp(7)+15,"100 km")
      EndIf
      If (i=4) And ((rtcmp=0) Or (zeit.d=0))
        DrawText(lp(5)-10,lp(7)+10,"x=0")
      EndIf
    Next i
    poyo.d=radius.d(24)+600000
    pozo.d=0
    lp(1)=UU(poxl.d,poy.d,poz.d)
    lp(2)=WW(poxl.d,poy.d,poz.d)
    lp(3)=UU(poxl.d,poyo.d,pozo.d)
    lp(4)=WW(poxl.d,poyo.d,pozo.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; vertikale Achse
    For i=1 To 6
      lp(5)=lp(1)-4
      lp(6)=lp(1)+4
      lp(7)=lp(2)-i*(lp(2)-lp(4))/6
      LineXY(lp(5),lp(7),lp(6),lp(7))
      If i=1
        DrawText(lp(5)-50,lp(7)-8,"100 km")
      EndIf
    Next i
  ElseIf Btst(23,QQQ)
    If labor
      poxl.d=-4
      poxr.d=4
      einh$="1 m"
      lab=10
    Else
      poxl.d=-400
      poxr.d=400
      einh$="100 m"
      lab=0
    EndIf
    poy.d=radius.d(24)
    poz.d=0
    lp(1)=UU(poxl.d,poy.d,poz.d)
    lp(2)=WW(poxl.d,poy.d,poz.d)
    lp(3)=UU(poxr.d,poy.d,poz.d)
    lp(4)=WW(poxr.d,poy.d,poz.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; tangentiale Achse
    For i=1 To 8
      lp(5)=lp(1)+i*(lp(3)-lp(1))/8
      lp(6)=lp(2)+4
      lp(7)=lp(2)-4
      LineXY(lp(5),lp(6),lp(5),lp(7))
      If i=1
        DrawText(lp(5)-20+lab,lp(7)+15,einh$)
        DrawText(lp(5)-140,lp(7)+15,"x=0")
      EndIf
    Next i
    If labor
      poyo.d=radius.d(24)+6
    Else
      poyo.d=radius.d(24)+600
    EndIf
    pozo.d=0
    lp(1)=UU(poxl.d,poy.d,poz.d)
    lp(2)=WW(poxl.d,poy.d,poz.d)
    lp(3)=UU(poxl.d,poyo.d,pozo.d)
    lp(4)=WW(poxl.d,poyo.d,pozo.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; vertikale Achse
    For i=1 To 6
      lp(5)=lp(1)-4
      lp(6)=lp(1)+4
      lp(7)=lp(2)-i*(lp(2)-lp(4))/6
      LineXY(lp(5),lp(7),lp(6),lp(7))
      If i=1
        DrawText(lp(5)-50+2*lab,lp(7)-8,einh$)
      EndIf
    Next i
  Else
    pox.d=-sx.d(posbzg)
    poy.d=-sy.d(posbzg)
    poz.d=-sz.d(posbzg)
    If brttmp=11
      ll.d=30*radius.d(24)
    ElseIf (brttmp=12) Or (brttmp=13)
      ll.d=0.99*radius.d(24)
    Else
      ll.d=#ae
    EndIf
    lp(1)=UU(pox.d-ll.d,poy.d,poz.d)
    lp(2)=WW(pox.d-ll.d,poy.d,poz.d)
    lp(3)=UU(pox.d+ll.d,poy.d,poz.d)
    lp(4)=WW(pox.d+ll.d,poy.d,poz.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; x-Achse
    lp(1)=UU(pox.d,poy.d-ll.d,poz.d)
    lp(2)=WW(pox.d,poy.d-ll.d,poz.d)
    lp(3)=UU(pox.d,poy.d+ll.d,poz.d)
    lp(4)=WW(pox.d,poy.d+ll.d,poz.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; y-Achse
    lp(1)=UU(pox.d,poy.d,poz.d-ll.d)
    lp(2)=WW(pox.d,poy.d,poz.d-ll.d)
    lp(3)=UU(pox.d,poy.d,poz.d+ll.d)
    lp(4)=WW(pox.d,poy.d,poz.d+ll.d)
    LineXY(lp(1),lp(2),lp(3),lp(4)) ; z-Achse
    ll.d=ll.d*1.05
    lp(1)=UU(pox.d+ll.d,poy.d,poz.d)-4
    lp(2)=WW(pox.d+ll.d,poy.d,poz.d)-8
    DrawText(lp(1),lp(2),"X")
    lp(1)=UU(pox.d,poy.d+ll.d,poz.d)-4
    lp(2)=WW(pox.d,poy.d+ll.d,poz.d)-8
    DrawText(lp(1),lp(2),"Y")
    lp(1)=UU(pox.d,poy.d,poz.d+ll.d)-4
    lp(2)=WW(pox.d,poy.d,poz.d+ll.d)-8
    DrawText(lp(1),lp(2),"Z")
  EndIf
EndProcedure ; Achsen
;
Procedure Namen(krp,spk,lag)
  DrawingMode(#PB_2DDrawing_Transparent)
  FrontColor(farbe(36))
  start=1
  If krp
    If Btst(21,QQQ)
      DrawText(ku(1)-12,kw(1)-5,name$(1)) ; "Erde"
      start=2
    EndIf
    For k=start To kp
      ukorr=SpriteWidth(spritenum(k))/2
      wkorr=SpriteHeight(spritenum(k))/2
      DrawText(ku(k)+ukorr,kw(k)+wkorr,name$(k))
    Next k
  EndIf
  If spk
    DrawText(uschw+7,wschw+5,datname$(22)) ; "SP"
  EndIf
  If lag
    For i=1 To 5
      DrawText(lu(i)+7,lw(i)+5,datname$(23)+Str(i)) ; "L1" - "L5"
    Next i
  EndIf
EndProcedure ; Namen
;
Procedure Geschwindigkeit()
  If Btst(23,QQQ)
    stellengeschw=2
  Else
    stellengeschw=0
  EndIf  
  DrawingMode(#PB_2DDrawing_Transparent)
  FrontColor(farbe(36))
  For k=1 To kp
    ukorr=SpriteWidth(spritenum(k))/2
    wkorr=SpriteHeight(spritenum(k))/2+14*Btst(13,QQQ)
    DrawText(ku(k)+ukorr,kw(k)+wkorr,StrDD(GeschwBetrag(k),stellengeschw)+" m/s")
  Next k 
EndProcedure ; Geschwindigkeit
;
Procedure Text(txt$,xloc,yloc.d,m=#PB_2DDrawing_Transparent)
  Select xloc
    Case 0
      xlc=40
    Case 1
      xlc=(spaltenl-TextWidth(txt$))/2
    Case 2
      xlc=spaltenl-TextWidth(txt$)-40
  EndSelect
  DrawingMode(m)
  FrontColor(farbe(36))
  DrawText(xlc,zeilen.d*yloc.d,txt$)
EndProcedure ; Text
;
Procedure BildSpeichern(typ)
  FlipBuffers(#PB_Screen_SmartSynchronization )
  GrabSprite(300,0,0,spaltenl,zeilenl,0)
  FlipBuffers(#PB_Screen_SmartSynchronization )
  If typ=0
    Repeat
      bildnummer+1
      bildpfad$=appdat$+"Bild "+Str(bildnummer)+".jpg"
    Until FileSize(bildpfad$)=-1
  Else
    bildpfad$=appdat$+"Druckgeometrie"+tp$
  EndIf
  SaveSprite(300,bildpfad$,#PB_ImagePlugin_JPEG,10)
  If IsSprite(300)
    FreeSprite(300)
  EndIf
  If typ=0
    If StartDrawing(ScreenOutput())
      Text(htxt$(24),1,0.7)
      Text(bildpfad$,1,0.72)
      Text(htxt$(25),1,0.75)
      StopDrawing()
      FlipBuffers(#PB_Screen_SmartSynchronization )
    EndIf
  EndIf
EndProcedure ; BildSpeichern
;
Procedure BildOeffnen()
  tit$="Bilder ffnen"
  txt1$=appdat$
  txt2$="Bilddateien|*.bmp;*.jpg;*.png;*.tif"
  txt$=OpenFileRequester(tit$,txt1$,txt2$,0)
  If txt$=""
    ProcedureReturn
  ElseIf GetExtensionPart(txt$)=""
    txt3$="Dateiendung fehlt    "
    MessageRequester(tit$,txt3$,#MB_ICONSTOP)
    ProcedureReturn
  ElseIf FileSize(txt$)=-1
    txt3$="Eine Bilddatei "+GetFilePart(txt$)+" existiert nicht.    "
    MessageRequester(tit$,txt3$,#MB_ICONSTOP)
    ProcedureReturn
  Else
    RunProgram(txt$)
  EndIf
EndProcedure ; BildOeffnen
;
Procedure BildDrucken(typ)
  If typ=0
    tit$="Bilder drucken"
    txt1$=appdat$
    txt2$="Bilddateien|*.bmp;*.jpg;*.png;*.tif"
    bld$=OpenFileRequester(tit$,txt1$,txt2$,0)
    If bld$=""
      ProcedureReturn
    ElseIf GetExtensionPart(bld$)=""
      txt3$="Dateiendung fehlt    "
      MessageRequester(tit$,txt3$,#MB_ICONSTOP)
      ProcedureReturn
    ElseIf FileSize(bld$)=-1
      txt3$="Eine Bilddatei "+GetFilePart(bld$)+" existiert nicht.    "
      MessageRequester(tit$,txt3$,#MB_ICONSTOP)
      ProcedureReturn
    EndIf
    If PrintRequester()
      If StartPrinting(GetFilePart(bld$))
        If StartDrawing(PrinterOutput())
          imgid=LoadImage(0,bld$)
          wd=PrinterPageWidth()
          ht=ImageHeight(0)*wd/ImageWidth(0)
          DrawImage(imgid,0,0,wd,ht)
          StopDrawing()
          FreeImage(0)
        EndIf
        StopPrinting()
      EndIf
    EndIf
  Else
    If DefaultPrinter()
      If StartPrinting(GetFilePart(bildpfad$))
        If StartDrawing(PrinterOutput())
          imgid=LoadImage(0,bildpfad$)
          wd=PrinterPageWidth()
          ht=ImageHeight(0)*wd/ImageWidth(0)
          DrawImage(imgid,0,0,wd,ht)
          StopDrawing()
          FreeImage(0)
        EndIf
        StopPrinting()
      EndIf
    EndIf
  EndIf
EndProcedure ; BildDrucken
;
;- DARSTELLUNG
Procedure ParameterEin(typ)
  Select typ
    Case 1
      EinstGadget(1,"Bildbreite in AE",StrDD(breite.d,4))
    Case 2
      EinstGadget(1,"Standard-Zeitschritt (Betrag) in s",StrDD(dtcfg.d,0))
    Case 3
      EinstGadget(1,"Variabler Zeitschritt (Betrag) in s",StrDD(dtvar.d,6))
    Case 4
      EinstGadget(1,"Schrittweite Bahn",Str(bahnschritt))
    Case 5
      EinstGadget(1,"Zoomfaktor Mondbahn",StrDD(mondzoom.d,0))
    Case 7
      EinstGadget(1,"Fahrstrahlintervall in s",StrDD(fahrint.d,0))
    Case 8
      EinstGadget(1,"Bahnradius ndern um den Faktor",StrDD(hohfak.d,2))
    Case 9
      EinstGadget(1,"0 - 16 Nachkommastellen Normaldarstellung",Str(stellen))
    Case 18
      EinstGadget(1,"0 - 16 Nachkommastellen Exponentialdarstellung",Str(stellenexp))
    Case 10
      EinstGadget(1,"Zusatzkraft in N",StrDD(fzusatz.d,3))
    Case 11
      EinstGadget(1,"Reibungsfaktor",StrDD(reibpar.d,2))
    Case 12
      If zusatzdauer.d=#riesig
        txt$="0"
      Else
        txt$=StrDD(zusatzdauer.d,0)
      EndIf
      EinstGadget(1,"Dauer der Zusatzkraft in s"+Chr(59)+" unbegrenzt: 0",txt$)
    Case 13
      EinstGadget(1,"Schrittweite Bild",StrDD(bildschritt.d,1))
    Case 14
      EinstGadget(1,"Schrittweite Rekonstruktion",Str(rknschritt))
    Case 15
      EinstGadget(1,"Gre des Bahnspeichers in MB",StrDD(bahnspeicher/1048576,2))
    Case 16
      EinstGadget(1,"Grenzbeschleunigung in m/s"+Chr(178),StrDD(akoll.d,2))
    Case 17
      EinstGadget(1,"Reduzierter Zeitschritt in s",StrDD(dtkoll.d,2))
    Case 21
      EinstGadget(1,"Radius ("+datname$(kpr(kpgad))+") in m",StrDD(radius.d(kpr(kpgad)),0))
    Case 22
      EinstGadget(1,"Bildradius ("+name$(kpgad)+") in Bildpunkten ohne Vergrerung",Str(bldrad(kpgad)))
    Case 23
      EinstGadget(1,"Vergrerung aller Bilderradien um den Faktor",Str(bldzoom))
    Case 24
      EinstGadget(1,"Doppelsternabstand in m",StrE(dpp.d,-1))
    Case 25
      EinstGadget(1,"Masse Stern 1 in kg",StrE(mstern1.d,-1))
    Case 26
      EinstGadget(1,"Masse Stern 2 in kg",StrE(mstern2.d,-1))
    Case 31
      vbtg.d=GeschwBetrag(kpgad)
      btg$=StrE(vbtg.d,-2)
      EinstGadget(1,"Geschwindigkeit in m/s",btg$)
    Case 32
      rbtg.d=RadiusBetrag(kpgad)
      btg$=StrE(rbtg.d,-2)
      EinstGadget(1,"Bahnradius in m",btg$)
    Case 33
      EinstGadget(1,"Bahnradius in Vielfachen des Erdradius"+Chr(59)+" geostationr: 0",StrDD(satfak.d,2))
    Case 41
      txt$="Startzeit"
      If lokal
        If tzbias=#mezbias
          txt$+" (MEZ)"
        Else
          txt$+" (UTC"+tzadd$+")"
        EndIf
      Else
        txt$+" (UTC)"
      EndIf
      EinstGadget(2,txt$,"")
    Case 42
      EinstGadget(1,"Korrektur der Zeitanzeige in s",Str(biaskorr))
    Case 50
      txt$="Gravitationskonstante in"
      txt$+" m"+Chr(179)+" / ( kg"+Chr(183)+"s"+Chr(178)+" )"
      EinstGadget(1,txt$,StrE(gamma.d,6))
  EndSelect
  par=typ
EndProcedure ; ParameterEin
;
Procedure ParameterAus(typ)
  tit1$="Eingabefehler"
  tit2$="Eingabebegrenzung"
  Select typ
    Case 0
      EinstGadget(0,"Einstellungen","")
    Case 1
      If par=41 ; Startzeit
        gdtxt$=GetGadgetText(114)
        templb=GetGadgetState(114)
        FreeGadget(114)
      Else
        wrt$=GetGadgetText(111)
        If FindString(LCase(wrt$),"def",1)
          wert.d=Voreinstellung(par)
          If wert.d=#fehld
            InfoHilfe(5)
          EndIf
        Else
          wert.d=Wert(wrt$)
        EndIf
        ;
        If wert.d<>#fehld
          Select par
            Case 1 ; Bildbreite
              If (wert.d<0.0002) Or (wert.d>1000)
                txt$="Nur Bildbreiten von 0.0002 AE bis 1000 AE sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 4 ; Schrittweite Bahn
              If (wert.d>1000) Or (wert.d<>Round(wert.d,#PB_Round_Nearest))
                txt$="Nur ganzzahlige Werte bis 1000 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 5 ; Mondzoom
              If (wert.d<1) Or (wert.d>100)
                txt$="Nur Werte von 1 bis 100 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 9,18 ; Stellenzahl
              If  (wert.d<0) Or (wert.d>16) Or (wert.d<>Round(wert.d,#PB_Round_Nearest))
                txt$="Nur ganzzahlige Werte von 0 bis 16 sind zulssig.    "
                MessageRequester(tit1$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 13 ; Schrittweite Bild
              If wert.d>10
                txt$="Nur Werte bis 10 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 15 ; Bahnspeicher
              If (wert.d<5) Or (wert.d>50)
                txt$="Nur Werte von 5 MB bis 50 MB sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 22 ; Bilderradius
              If (wert.d<1) Or (wert.d>20) Or (wert.d<>Round(wert.d,#PB_Round_Nearest))
                txt$="Nur ganzzahlige Werte von 1 bis 20 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 23 ; Bilderzoom
              If (wert.d<1) Or (wert.d>20) Or (wert.d<>Round(wert.d,#PB_Round_Nearest))
                txt$="Nur ganzzahlige Werte von 1 bis 20 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 24 ; Doppelsternabstand
              If wert.d<koll.d(19,20)
                txt$="Eingabe unzulssig wegen Kollision Stern 1 - Stern 2.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 31 ; Geschwindigkeit
              If vbtg.d=0
                txt$="Die Geschwindigkeit Null kann nur durch die Eingabe    "
                txt$+Chr(13)
                txt$+"der Geschwindikeitskomponenten verndert werden.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 32 ; Bahnradius
              If rbtg.d=0
                txt$="Der Bahnradius Null kann nur durch die Eingabe    "
                txt$+Chr(13)
                txt$+"der Ortskoordinaten verndert werden.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
            Case 33 ; Satellitenbahnradius
              If (wert.d<>0) And (wert.d<=1) ; 0: geostationr
                txt$="Nur 0 oder Werte ber 1 sind zulssig.    "
                MessageRequester(tit2$,txt$,#MB_ICONSTOP)
                wert.d=#fehld
              EndIf
          EndSelect
        EndIf
        ;
        If (wert.d<=0) And (par<>9) And (par<>18) And (par<>10) And (par<>12) And (par<>14) And (par<>31) And (par<>32) And (par<>33) And (par<>42)
          txt$="Nur positive Werte sind zulssig.    "
          MessageRequester(tit2$,txt$,#MB_ICONSTOP)
          wert.d=#fehld
        ElseIf (wert.d<0) And ((par=12) Or (par=31) Or (par=32))
          txt$="Nur nicht-negative Werte sind zulssig.    "
          MessageRequester(tit2$,txt$,#MB_ICONSTOP)
          wert.d=#fehld
        EndIf
      EndIf
      If wert.d<>#fehld
        Delay(150)
        EinstGadget(0,"Einstellungen","")
      Else
        ParameterEin(par)
        ProcedureReturn
      EndIf
      Select par
        Case 1
          breite.d=wert.d
          ProjPar()
          brttmp=#brttmpcfg
          For i=61 To 68
            SetGadgetState(i,0)
          Next i
          If breite.d>0.1
            SetGadgetText(60,"Bildbreite ("+StrDD(breite.d,1)+" AE)")
          Else
            brtkm.d=breite.d*#ae/1000
            SetGadgetText(60,"Bildbreite ("+StrDD(brtkm.d,0)+" km)")
          EndIf
        Case 2
          temp.d=dtcfg.d
          dtcfg.d=wert.d
          InfoHilfe(1)
          ConfigSpeichern(1)
          If dt.d=temp.d
            dt.d=dtcfg.d
          EndIf
        Case 3
          temp.d=dtvar.d
          dtvar.d=wert.d
          InfoHilfe(1)
          If dt.d=temp.d
            dt.d=dtvar.d
          EndIf
        Case 4
          bahnschritt=Int(wert.d)
          ConfigSpeichern(1)
        Case 5
          mondzoom.d=wert.d
          BahnWeg()
        Case 7
          fahrint.d=wert.d
        Case 8
          hohfak.d=wert.d
        Case 9
          stellen=Int(wert.d)
          If kp>0
            If kpgad>0
              Zustand(0,kpgad)
            Else
              Zustand(0,kp)
            EndIf
          EndIf
        Case 18
          stellenexp=Int(wert.d)
          If kp>0
            If kpgad>0
              Zustand(0,kpgad)
            Else
              Zustand(0,kp)
            EndIf
          EndIf
        Case 10
          fzusatz.d=wert.d
        Case 11
          reibpar.d=wert.d
        Case 12
          If wert.d=0
            zusatzdauer.d=#riesig
          Else
            zusatzdauer.d=wert.d
          EndIf
        Case 13
          bildschritt.d=wert.d
          ConfigSpeichern(1)
        Case 14
          rknschritt=Int(wert.d)
          ConfigSpeichern(1)
        Case 15
          bahnspeicher=Int(wert.d*1048576)
          bahnpunkte=bahnspeicher/59-1
          ConfigSpeichern(1)
          ReDim sxb.d(bahnpunkte)
          ReDim syb.d(bahnpunkte)
          ReDim szb.d(bahnpunkte)
          ReDim fb.b(bahnpunkte)
          ReDim cb.b(bahnpunkte)
          ReDim mb.b(bahnpunkte)
          ReDim sxw.d(bahnpunkte)
          ReDim syw.d(bahnpunkte)
          ReDim szw.d(bahnpunkte)
          ReDim phw.d(bahnpunkte)
        Case 16
          akoll.d=wert.d
        Case 17
          dtkoll.d=wert.d
        Case 21
          radius.d(kpr(kpgad))=wert.d
          Kollisionsmatrix()
        Case 22
          bldrad(kpgad)=Int(wert.d)
        Case 23
          bldzoomalt=bldzoom
          bldzoom=Int(wert.d)
          If bldzoom<>bldzoomalt
            QQQ=Bset(18,QQQ)
          EndIf
        Case 24
          dpp.d=wert.d
          DoppPar()
        Case 25
          mstern1.d=wert.d
          DoppPar()
        Case 26
          mstern2.d=wert.d
          DoppPar()
        Case 31
          vfak.d=wert.d/vbtg.d
          If ((Btst(22,QQQ)=0) And (Btst(223,QQQ)=0)) Or (zeit.d>0)
            vx.d(kpgad)=vx.d(kpgad)*vfak.d
          EndIf
          vy.d(kpgad)=vy.d(kpgad)*vfak.d
          vz.d(kpgad)=vz.d(kpgad)*vfak.d
          Zustand(0,kpgad)
        Case 32
          rfak.d=wert.d/rbtg.d
          tempa.d=sx.d(kpgad)
          tempb.d=sy.d(kpgad)
          tempc.d=sz.d(kpgad)
          sx.d(kpgad)=sx.d(kpgad)*rfak.d
          sy.d(kpgad)=sy.d(kpgad)*rfak.d
          sz.d(kpgad)=sz.d(kpgad)*rfak.d
          If Kollisionstest(sx.d(kpgad),sy.d(kpgad),sz.d(kpgad),kpgad,1)=0
            sx.d(kpgad)=tempa.d
            sy.d(kpgad)=tempb.d
            sz.d(kpgad)=tempc.d
          EndIf
          Zustand(0,kpgad)
        Case 33
          satfak.d=wert.d
        Case 41
          startzeitalt.d=startzeit.d
          If lokal
            templb+tzbias
          EndIf
          startzeit.d=templb
          stopzeit.d=startzeit.d
          stopzeitalt.d=stopzeit.d
          If Abs(startzeit.d-startzeitalt.d)>59 ; DateGadget() ignoriert Sekunden
            startzeitvar=1
            BahnrechnungA(2)
            QQQ=Bset(29,QQQ)
          EndIf
        Case 42
          biaskorr=Int(wert.d)
          ConfigSpeichern(1)
          Zeit()
          InfoM(Datum(stbartyp),stbartyp)
        Case 50
          gamma.d=wert.d
          If gamma.d<>#gammacfg
            QQQ=Bset(30,QQQ)
          Else
            QQQ=Bclr(30,QQQ)
          EndIf
      EndSelect
  EndSelect
  par=0
EndProcedure ; ParameterAus
;
Procedure.d Voreinstellung(typ)
  Select typ
    Case 1
      def.d=#breitecfg
    Case 2
      def.d=#dtcfg
    Case 3
      def.d=#dtvarcfg
    Case 4
      def.d=#bahnschrittcfg
    Case 5
      def.d=#mondzoomcfg
    Case 7
      def.d=#jahrsid/12
    Case 8
      def.d=#hohfakcfg
    Case 9
      def.d=#stellencfg
    Case 10
      def.d=#fzusatzcfg
    Case 11
      def.d=#reibparcfg
    Case 13
      def.d=#bildschrittcfg
    Case 14
      def.d=#rknschrittcfg
    Case 15
      def.d=#bahnspeichercfg/1048576
    Case 16
      def.d=#akollcfg
    Case 17
      def.d=#dtkollcfg
    Case 18
      def.d=#stellenexpcfg
    Case 24
      def.d=#dppcfg
    Case 25
      def.d=datmm.d(19)
    Case 26
      def.d=datmm.d(20)
    Case 33
      def.d=#satfakcfg
    Case 42
      def.d=#biaskorrcfg
    Case 50
      def.d=#gammacfg
    Default
      def.d=#fehld
  EndSelect
  ProcedureReturn def.d
EndProcedure ; Voreinstellung
;
Procedure Zeitschritt(typ)
  For i=81 To 88
    SetGadgetState(i,0)
  Next i
  SetGadgetState(81+typ,1)
  Select typ
    Case 0 ; variabel
      dt.d=dtvar.d
    Case 1
      dt.d=0.0001
    Case 2
      dt.d=0.001
    Case 3
      dt.d=0.01
    Case 4
      dt.d=1
    Case 5
      dt.d=60
    Case 6
      dt.d=3600
    Case 7 ; Standard
      dt.d=dtcfg.d
  EndSelect
  InfoHilfe(1)
EndProcedure ; Zeitschritt
;
Procedure BezugBild(typ)
  ; typ=Bezugspunkt (0,1,4,22)
  bezugalt=bezug
  If (typ=4) And (Btst(5,QQQ)=1)
    bezug=24
  Else
    bezug=typ
  EndIf
  posbzg=pos(bezug)
  Select typ
    Case 0
      SetGadgetState(31,1)
      SetGadgetState(32,0)
      SetGadgetState(33,0)
      SetGadgetState(34,0)
    Case 1
      SetGadgetState(31,0)
      SetGadgetState(32,1)
      SetGadgetState(33,0)
      SetGadgetState(34,0)
    Case 4
      SetGadgetState(31,0)
      SetGadgetState(32,0)
      SetGadgetState(33,1)
      SetGadgetState(34,0)
    Case 22
      SetGadgetState(31,0)
      SetGadgetState(32,0)
      SetGadgetState(33,0)
      SetGadgetState(34,1)
  EndSelect
EndProcedure ; BezugBild
;
Procedure BildBrt(typ)
  For i=61 To 68
    SetGadgetState(i,0)
  Next i
  brttmpalt=brttmp
  brttmp=typ
  QQQ=Bclr(21,QQQ)
  QQQ=Bclr(22,QQQ)
  QQQ=Bclr(23,QQQ)
  Select brttmp
    Case 1 ; cfg
      breite.d=#breitecfg
      Zeitschritt(7)
    Case 2 ; Merkurbahn
      breite.d=1.5
      Zeitschritt(7)
      SetGadgetState(61,1)
    Case 3 ; Venusbahn
      breite.d=2
      Zeitschritt(7)
    Case 4 ; Erdbahn
      breite.d=3
      Zeitschritt(7)
      SetGadgetState(62,1)
    Case 5 ; Marsbahn
      breite.d=5
      Zeitschritt(7)
      SetGadgetState(63,1)
    Case 6 ; Jupiterbahn
      breite.d=15
      Zeitschritt(6)
      SetGadgetState(64,1)
    Case 7 ; Saturnbahn
      breite.d=30
      Zeitschritt(6)
    Case 8 ; Uranusbahn
      breite.d=60
      Zeitschritt(6)
    Case 9 ; Neptunbahn
      breite.d=100
      Zeitschritt(6)
      SetGadgetState(65,1)
    Case 10 ; Plutobahn
      breite.d=140
      Zeitschritt(6)
    Case 11 ; Mondbahn (geozentrisch)
      breite.d=0.01
      woff.d=woffcfg.d
      Zeitschritt(5)
      SetGadgetState(66,1)
    Case 12 ; Satellitenbahn
      QQQ=Bset(21,QQQ)
      breite.d=0.0004
      woff.d=woffcfg.d
      Zeitschritt(4)
      SetGadgetState(67,1)
    Case 13 ; Satellitenbahn (geostationr)
      QQQ=Bset(21,QQQ)
      breite.d=0.001
      woff.d=woffcfg.d
      Zeitschritt(4)
      SetGadgetState(68,1)
    Case 14 ; Erdoberflche
      QQQ=Bset(21,QQQ)
      QQQ=Bset(22,QQQ)
      breite.d=1000000/#ae
      woff.d=WoffErde()
      Zeitschritt(3)
    Case 15 ; Laborsystem
      QQQ=Bset(21,QQQ)
      QQQ=Bset(23,QQQ)
      If labor ; klein
        breite.d=10/#ae
        Zeitschritt(1)
      Else ; gro
        breite.d=1000/#ae
        Zeitschritt(2)
      EndIf
      woff.d=WoffErde()
  EndSelect
  ProjPar()
  If Btst(18,QQQ)=0
    If brttmp<6
      bldzoom=#bldzoomgrcfg
    ElseIf brttmp<8
      bldzoom=#bldzoommicfg
    ElseIf brttmp<11
      bldzoom=#bldzoomklcfg
    Else
      bldzoom=#bldzoomgrcfg
    EndIf
  EndIf
  If typ<11
    SetGadgetText(60,"Bildbreite ("+StrDD(breite.d,1)+" AE)")
  Else
    brtkm.d=breite.d*#ae/1000
    SetGadgetText(60,"Bildbreite ("+StrDD(brtkm.d,0)+" km)")
  EndIf
EndProcedure ; BildBrt
;
Procedure Erdoberflaeche(typ)
  Select typ
    Case 0
      rtstp=0
      rtcmp=0
      omega.d=#omegacfg
      SetGadgetState(72,1)
      SetGadgetState(73,0)
      SetGadgetState(75,1)
      SetGadgetState(76,0)
    Case 1
      rtstp=0
      omega.d=#omegacfg
      SetGadgetState(72,1)
      SetGadgetState(73,0)
    Case 2
      rtstp=1
      rtcmp=0
      omega.d=0
      SetGadgetState(72,0)
      SetGadgetState(73,1)
      SetGadgetState(75,1)
      SetGadgetState(76,0)
    Case 3
      rtcmp=0
      SetGadgetState(75,1)
      SetGadgetState(76,0)
    Case 4
      rtcmp=1
      SetGadgetState(75,0)
      SetGadgetState(76,1)
  EndSelect
EndProcedure ; Erdoberflaeche
;
Procedure BahnenEA()
  QQQ=Bchg(6,QQQ)
  If Btst(6,QQQ)
    BahnWeg()
    If Btst(8,QQQ)
      FahrstrahlEA()
    EndIf
  EndIf
EndProcedure ; BahnenEA
;
Procedure GeschwindigkeitEA()
  QQQ=Bchg(7,QQQ)
EndProcedure ; GeschwindigkeitEA
;  
Procedure FahrstrahlEA()
  QQQ=Bchg(8,QQQ)
EndProcedure ; FahrstrahlEA
;
Procedure AchsenEA()
  QQQ=Bchg(11,QQQ)
EndProcedure ; AchsenEA
;
Procedure SchwerpunktEA()
  QQQ=Bchg(9,QQQ)
EndProcedure ; SchwerpunktEA
;
Procedure LagrangeEA(k1,k2,mn)
  If lagralt=0
    lagralt=76
  EndIf
  If mn=lagralt
    ProcedureReturn
  EndIf
  If k1>0
    If GeschwBetrag(pos(k2))=0
      tit$="Lagrangepunkte"
      txt$="Die Berechnung der Lagrangepunkte ist nicht mglich,    "
      txt$+Chr(13)
      txt$+"da "
      txt$+name$(pos(k2))
      txt$+" die Geschwindigkeit Null hat.    "
      MessageRequester(tit$,txt$,#MB_ICONSTOP)
      ProcedureReturn
    EndIf
  EndIf
  lagr1=k1
  lagr2=k2
  SetMenuItemState(0,lagralt,0)
  If mn<76
    QQQ=Bset(28,QQQ)
    InfoR(name$(pos(k1))+" - "+name$(pos(k2))+": L")
  Else
    QQQ=Bclr(28,QQQ)
    InfoR("")
  EndIf
  SetMenuItemState(0,mn,1)
  lagralt=mn
EndProcedure ; LagrangeEA
;
Procedure ZeitEA()
  QQQ=Bchg(10,QQQ)
EndProcedure ; ZeitEA
;
Procedure ZeitschrittEA()
  QQQ=Bchg(16,QQQ)
EndProcedure ; ZeitschrittEA
;
Procedure BildbreiteEA()
  QQQ=Bchg(17,QQQ)
EndProcedure ; BildbreiteEA
;
Procedure NamenEA()
  QQQ=Bchg(13,QQQ)
EndProcedure ; NamenEA
;
Procedure NamenLagrEA()
  If Btst(28,QQQ)
    QQQ=Bchg(14,QQQ)
  EndIf
EndProcedure ; NamenLagrEA
;
Procedure NamenAbbEA()
  If foto>0
    QQQ=Bchg(15,QQQ)
  EndIf
EndProcedure ; NamenAbbEA
;
Procedure Blickrichtung(typ)
  paalt.d=pa.d
  pbalt.d=pb.d
  blick=typ
  For i=41 To 45
    SetGadgetState(i,0)
  Next i
  Select typ
    Case 1 ; senkrecht zur Ekliptikebene
      pa.d=0
      pb.d=#ecl
      SetGadgetState(41,1)
    Case 2 ; -x-Achse
      pa.d=1.5708 ; 90
      pb.d=1.5708
      SetGadgetState(42,1)
    Case 3 ; y-Achse
      pa.d=0
      pb.d=1.5708 ; 90
      SetGadgetState(43,1)
    Case 4 ; -z-Achse
      pa.d=0
      pb.d=0
      SetGadgetState(44,1)
    Case 5 ; schrg
      pa.d=0.5236 ; 30
      pb.d=1.3963 ; 80
      SetGadgetState(45,1)
    Case 11 ; 11-14: Rotation
      pb.d=MinD(pb.d+bildschritt.d/100,2000*#PI)
    Case 12
      pb.d=MaxD(pb.d-bildschritt.d/100,-2000*#PI)
    Case 13
      pa.d=MinD(pa.d+bildschritt.d/100,2000*#PI)
    Case 14
      pa.d=MaxD(pa.d-bildschritt.d/100,-2000*#PI)
  EndSelect
  If (pa.d<>paalt.d) Or (pb.d<>pbalt.d)
    If Btst(1,QQQ)=0
      BahnWeg()
    EndIf
  EndIf
  ProjPar()
EndProcedure ; Blickrichtung
;
Procedure Zoom(zoo.d)
  breite.d=breite.d*zoo.d
  breite.d=MaxD(breite.d,0.0002)
  breite.d=MinD(breite.d,1000)
  If Btst(21,QQQ)
     breite.d=MinD(breite.d,0.0075)
  EndIf
  ProjPar()
  For i=61 To 68
    SetGadgetState(i,0)
  Next i
  If breite.d>0.1
    SetGadgetText(60,"Bildbreite ("+StrDD(breite.d,1)+" AE)")
  Else
    brtkm.d=breite.d*#ae/1000
    SetGadgetText(60,"Bildbreite ("+StrDD(brtkm.d,0)+" km)")
  EndIf
EndProcedure ; Zoom
;
Procedure Spritegroesse(typ)
  ; typ: 0 Reset - 1/2 Tasten bei Bild - 3 Men (EinstGadget)
  Select typ
    Case 0
      If brttmp<6
        bldzoom=#bldzoomgrcfg
      ElseIf brttmp<8
        bldzoom=#bldzoommicfg
      ElseIf brttmp<11
        bldzoom=#bldzoomklcfg
      Else
        bldzoom=#bldzoomgrcfg
      EndIf
      QQQ=Bclr(18,QQQ)
      EinstGadget(0,"Einstellungen","")
    Case 1
      bldzoom=MinL(bldzoom+Int(bildschritt.d),20)
      QQQ=Bset(18,QQQ)
    Case 2
      bldzoom=MaxL(bldzoom-Int(bildschritt.d),1)
      QQQ=Bset(18,QQQ)
    Case 3
      ParameterEin(23)
  EndSelect
EndProcedure ; Spritegroesse
;
Procedure Farbwahl(typ)
  Select typ
    Case 0 ; Voreinstellung
      For i=1 To 40
        farbe(i)=farbecfg(i)
      Next i
      SetGadgetColor(111,#PB_Gadget_BackColor,farbe(38))
    Case 1 ; Ausgewhlter Krper
      frb=ColorRequester(farbe(kpr(kpgad)))
      If frb<>-1 ; -1: Abbruch
        farbe(kpr(kpgad))=frb
      EndIf
    Case 2 ; Screen
      frb=ColorRequester(farbe(31))
      If frb<>-1
        farbe(31)=frb
      EndIf
    Case 3 ; Bahn
      frb=ColorRequester(farbe(32))
      If frb<>-1
        farbe(32)=frb
      EndIf
    Case 4 ; Fahrstrahl
      frb=ColorRequester(farbe(33))
      If frb<>-1
        farbe(33)=frb
      EndIf
    Case 5 ; Schwerpunkt(bahn)
      frb=ColorRequester(farbe(22))
      If frb<>-1
        farbe(22)=frb
        farbe(34)=frb
      EndIf
    Case 6 ; Achsen
      frb=ColorRequester(farbe(35))
      If frb<>-1
        farbe(35)=frb
      EndIf
    Case 7 ; Text
      frb=ColorRequester(farbe(36))
      If frb<>-1
        farbe(36)=frb
      EndIf
    Case 8 ; Hohmannhalbellipse
      frb=ColorRequester(farbe(37))
      If frb<>-1
        farbe(37)=frb
      EndIf
    Case 9 ; Lagrangepunkte
      frb=ColorRequester(farbe(23))
      If frb<>-1
        farbe(23)=frb
      EndIf
    Case 10 ; quatormarke
      frb=ColorRequester(farbe(21))
      If frb<>-1
        farbe(21)=frb
      EndIf
    Case 11 ; Eingabefeld Einstellungen
      frb=ColorRequester(farbe(38))
      If frb<>-1
        farbe(38)=frb
        SetGadgetColor(111,#PB_Gadget_BackColor,farbe(38))
      EndIf
    Case 12 ; Schwarz-Wei
      QQQ=Bchg(19,QQQ)
      If Btst(19,QQQ)
        For i=1 To 40
          farbetmp(i)=farbe(i)
          farbe(i)=$040404 ; NICHT $000000 (transparent) !
        Next i
        farbe(31)=$FFFFFF
      Else
        For i=1 To 40
          farbe(i)=farbetmp(i)
        Next i
      EndIf  
  EndSelect
EndProcedure ; Farbwahl
;
Procedure Radiuswahl(typ)
  Select typ
    Case 0 ; Voreinstellung
      For i=1 To 30
        bldrad(i)=bldradcfg(i)
      Next i
      EinstGadget(0,"Einstellungen","")
    Case 1 ; Ausgewhlter Krper
      ParameterEin(22)
  EndSelect
EndProcedure ; Radiuswahl
;
Procedure DruckgeometrieEA()
  If Btst(20,QQQ)=0
    asp.d=aspdruck.d
    SetMenuItemState(0,23,1)
    QQQ=Bset(20,QQQ)
    txt$="Druckgeometrie eingeschaltet"
  Else
    asp.d=aspbild.d
    SetMenuItemState(0,23,0)
    QQQ=Bclr(20,QQQ)
    txt$="Druckgeometrie ausgeschaltet"
  EndIf
  ProjPar()
  InfoMo(txt$)
EndProcedure ; DruckgeometrieEA
;
Procedure BahnWeg()
  If Btst(2,QQQ) Or Btst(21,QQQ)
    If Btst(1,QQQ)
      ClearScreen(farbe(31))
      FlipBuffers(#PB_Screen_SmartSynchronization )
    EndIf
    QQQ=Bclr(2,QQQ)
  EndIf
EndProcedure ; BahnWeg
;
Procedure SynchronisationEA()
  vblsync=#PB_Screen_SmartSynchronization-vblsync
  SetMenuItemState(0,24,#PB_Screen_SmartSynchronization-vblsync)
  txt$="Synchronisation mit Monitorfrequenz "
  If vblsync=#PB_Screen_SmartSynchronization 
    txt$+"eingeschaltet"
  Else
    txt$+"ausgeschaltet"
  EndIf
  InfoMo(txt$)
  ConfigSpeichern(1)
EndProcedure ; SynchronisationEA
;
Procedure LokalEA()
  lokal=1-lokal
  ConfigSpeichern(1)
  InfoM(Datum(stbartyp),stbartyp)
  If par=41
    ParameterEin(41)
  EndIf
EndProcedure ; LokalEA
;
;- INFO-HILFE
Procedure Info()
  lizenz1$="Copyright  "+Chr(169)+"  Dr. Arnim Wegner"
  lizenz2$="GNU General Public License"
  lizenz3$=" ist freie Software, die Sie unter bestimmten Bedingungen"
  lizenz4$="weitergeben drfen; lesen Sie Lizenz.pdf und Handbuch.pdf fr Details."
  lizenz5$="Fr "
  lizenz6$=" besteht KEINERLEI GARANTIE;"
  lizenz7$="lesen Sie Lizenz.pdf und Handbuch.pdf fr Details."
  lizenz8$=" is free software, and you are welcome to redistribute it"
  lizenz9$="under certain conditions; for details read Lizenz.pdf and Handbuch.pdf."
  lizenz10$=" comes with ABSOLUTELY NO WARRANTY;"
  lizenz11$="for details read Lizenz.pdf and Handbuch.pdf."
  txt$=Space(47)+programmtitel$+Chr(13)+Chr(13)
  txt$+Space(34)+lizenz1$+Chr(13)+Chr(13)+Chr(13)
  txt$+Space(38)+lizenz2$+Chr(13)+Chr(13)
  txt$+Space(6)+programmtitel$+lizenz3$+Space(8)+Chr(13)
  txt$+Space(8)+lizenz4$+Chr(13)
  txt$+Space(22)+lizenz5$+programmtitel$+lizenz6$+Chr(13)
  txt$+Space(23)+lizenz7$+Chr(13)+Chr(13)
  txt$+Space(8)+programmtitel$+lizenz8$+Chr(13)
  txt$+Space(8)+lizenz9$+Chr(13)
  txt$+Space(16)+programmtitel$+lizenz10$+Chr(13)
  txt$+Space(26)+lizenz11$+Chr(13)
  MessageRequester(programmtitel$,txt$,#PB_MessageRequester_Ok)
EndProcedure ; Info
;
Procedure InfoL(txt$)
  StatusBarText(0,0,txt$,#PB_StatusBar_Raised|#PB_StatusBar_Center)
EndProcedure ; InfoL
;
Procedure InfoM(txt$,typ)
  StatusBarText(0,1,txt$,#PB_StatusBar_Raised|#PB_StatusBar_Center)
  stbartxt$=txt$
  stbartyp=typ
EndProcedure ; InfoM
;
Procedure InfoMo(txt$)
  StatusBarText(0,1,txt$,#PB_StatusBar_Raised|#PB_StatusBar_Center)
EndProcedure ; InfoMo
;
Procedure InfoR(txt$)
  StatusBarText(0,2,txt$,#PB_StatusBar_Raised|#PB_StatusBar_Center)
EndProcedure ; InfoR
;
Procedure InfoHilfe(typ)
  Select typ
    Case 0
      QQQ=Bchg(12,QQQ)
    Case 1
      GadgetToolTip(81,StrDD(dtvar.d,6)+" s")
      GadgetToolTip(88,StrDD(dtcfg.d,0)+" s")
    Case 2
      tit$="Texte ffnen"
      txt1$=pfad$+"Handbuch.pdf"
      txt2$="PDF-Dateien|*.pdf"
      txt$=OpenFileRequester(tit$,txt1$,txt2$,0)
      If txt$=""
        ProcedureReturn
      ElseIf GetExtensionPart(txt$)=""
        txt3$="Dateiendung fehlt    "
        MessageRequester(tit$,txt3$,#MB_ICONSTOP)
        ProcedureReturn
      ElseIf FileSize(txt$)=-1
        txt3$="Eine Textdatei "+GetFilePart(txt$)+" existiert nicht.    "
        MessageRequester(tit$,txt3$,#MB_ICONSTOP)
        ProcedureReturn
      Else
        RunProgram(txt$)
      EndIf
    Case 3
      starthilfe=1-starthilfe
      ConfigSpeichern(1)
      SetMenuItemState(0,86,starthilfe)
      If starthilfe
        txt$="Anzeige der Hilfe beim Programmstart eingeschaltet"
      Else
        txt$="Anzeige der Hilfe beim Programmstart ausgeschaltet"
      EndIf
      InfoMo(txt$)
    Case 4
      If starthilfe
        InfoHilfe(0)
      EndIf
    Case 5
      tit$="Voreinstellung"
      txt$="Dieser Wert kann nicht durch die Eingabe    "
      txt$+Chr(13)
      txt$+"von "+Chr(132)+"def"+Chr(148)+" eingestellt werden.    "
      MessageRequester(tit$,txt$,#MB_ICONINFORMATION)
    Case 6
      txt$="Programmverzeichnis:"
      txt$+Chr(13)
      txt$+pfad$+Space(4)
      txt$+Chr(13)+Chr(13)
      txt$+"Anwendungsdatenverzeichnis:"
      txt$+Chr(13)
      txt$+appdat$+Space(4)
      If appdatalt$<>""
        txt$+Chr(13)+Chr(13)
        txt$+"Anwendungsdatenverzeichnis der vorhergehenden Programmversion:    "
        txt$+Chr(13)
        txt$+appdatalt$+Space(4)
      EndIf
      MessageRequester(programmtitel$,txt$,#MB_ICONINFORMATION)
  EndSelect
EndProcedure ; InfoHilfe
;
Procedure HilfeBild() 
  htxt$(1)="Start: F6 / F7  -  Bahnen lschen: F9  -  Zurck: Esc"
  htxt$(2)="Hilfe aus: F1  -  Namen: F2  -  Achsen: F3  -  Zeit: F4  -  Fahrstrahlen: F  -  Blickrichtung: E, X, Y, Z, S, Pfeiltasten  -  Verschieben: V + Pfeiltasten (Reset: V + R)"
  htxt$(3)="Zoom: Bild auf/ab  -  Bildergre: B + Bild auf/ab (Reset B + R)  -  Geschwindigkeit: G  -  Speichern: P"
  htxt$(4)="Bezugspunkt: 1 2 3 4  -  Bildbreite: F10  -  Zeitschritt:  Anzeigen F11  -  Verkleinern 5  -  Reset T  -  Vergrern 6  -  Reduzierung F12"
  htxt$(5)="Namen der Lagrangepunkte: L"
  htxt$(6)="Bezugspunkt: 3 4  -  Bildbreite: F10  -  Zeitschritt:  Anzeigen F11  -  Verkleinern 5  -  Reset T  -  Vergrern 6"
  htxt$(7)="Hohmannbergang: H + Nummer des Satelliten"
  htxt$(8)="Hilfe aus: F1  -  Namen: F2  -  Achsen: F3  -  Zeit: F4  -  Fahrstrahlen: F  -  Verschieben: V + Pfeiltasten (Reset: V + R)"
  htxt$(9)="Bildergre: B + Bild auf/ab (Reset B + R)  -  Speichern: P"
  htxt$(10)="Bildbreite: F10  -  Zeitschritt:  Anzeigen F11  -  Verkleinern 5  -  Reset T  -  Vergrern 6"
  If fotozahl>0
    htxt$(3)+"  -  Illustrationen: Einfg - Entf;  Bezeichnung: N"
    htxt$(9)+"  -  Illustrationen: Einfg - Entf;  Bezeichnung: N"
  EndIf
  htxt$(11)=htxt$(5)+Space(20)+htxt$(7)
  htxt$(12)="Hilfe aus: F1  -  Namen: F2  -  Achsen: F3  -  Zeit: F4  -  Anhalten: F8  -  Zurck: Esc"
  htxt$(13)="Fahrstrahlen: F  -  Geschwindigkeit: G  -  Bildbreite: F10  -  Zeitschritt:  Anzeigen F11  -  Verkleinern 5  -  Reset T  -  Vergrern 6"
  htxt$(14)=htxt$(13)+"  -  Reduzierung F12" 
  htxt$(15)="Da der Krper sich nicht auf einer Kreisbahn bewegt,"
  htxt$(16)="kann kein regulrer Hohmannbergang ausgefhrt werden."
  htxt$(17)="Dies sollte ein Kreis sein."
  htxt$(18)="Abbruch: Esc - Einstellung speichern: F2"
  htxt$(19)="Dies sollte auf dem Ausdruck dieses Bildes ein Kreis sein." 
  htxt$(20)="Abbruch: Esc - Bild speichern: S - Bild speichern und drucken: P - Einstellung speichern: F2"
  htxt$(21)="Einstellung des senkrechten Durchmessers: Cursortasten Auf und Ab"
  htxt$(22)="Die letzten Krper wurden nach ihrer Kollision entfernt."
  htxt$(23)="Der Bildschirm wird geschlossen."
  htxt$(24)="Bild gespeichert unter"
  htxt$(25)="Weiter mit beliebiger Taste"
  htxt$(26)="Fortsetzung des Hohmannbergangs mit Taste F6"
EndProcedure ; HilfeBild
;
;- SONSTIGE FKT
Procedure.l Btst(i,xxx)
  ProcedureReturn ((xxx<<(30-i))&2147483647)>>30 ; 2147483647=2^31-1
EndProcedure ; Btst
;
Procedure.l BtstI(i,j,xxx)
  For k=i To j
    bti+Btst(k,xxx)
  Next k
  ProcedureReturn bti
EndProcedure ; BtstI
;
Procedure.l Bset(i,xxx)
  ProcedureReturn xxx|(%1<<i)
EndProcedure ; Bset
;
Procedure.l Bclr(i,xxx)
  ProcedureReturn xxx&(2147483647-(%1<<i))
EndProcedure ; Bclr
;
Procedure.l Bchg(i,xxx)
  If Btst(i,xxx)
    ProcedureReturn Bclr(i,xxx)
  Else
    ProcedureReturn Bset(i,xxx)
  EndIf
EndProcedure ; Bchg
;
Procedure.l HexLong(h$)
  ; Umwandlung von 6stelligen Hexadezimalstrings wie "$24F34A" fr Farben
  For i=2 To 7
    a=Asc(Mid(h$,i,1))-48
    If (a>16) And (a<23)
      a-7
    EndIf
    hl+a*Pow(16,7-i)
  Next i
  ProcedureReturn hl
EndProcedure ; HexLong
;
Procedure ProjPar()
  projx.d=spalten.d/(breite.d*#ae)
  projy.d=projx.d*asp.d
  sia.d=Sin(pa.d)
  sib.d=Sin(pb.d)
  coa.d=Cos(pa.d)
  cob.d=Cos(pb.d)
  siasib.d=sia.d*sib.d
  siacob.d=sia.d*cob.d
  sibcoa.d=sib.d*coa.d
  coacob.d=coa.d*cob.d
  sia2cob.d=sia.d*siacob.d
  coa2cob.d=coa.d*coacob.d
EndProcedure ; ProjPar
;
Procedure Index()
  For k=1 To kp
    hcop(k)=kh(k)
    hsort(k)=kh(k)
  Next k
  SortArray(hsort(),0,1,kp)
  For i=1 To kp
    For j=1 To kp
      If hsort(i)=hcop(j)
        hcop(j)=#fehll ; als "verbraucht" markieren
        hind(i)=j
        j=kp
      EndIf
    Next j
  Next i
EndProcedure ; Index
;
Procedure.d RadiusBetrag(k)
  ProcedureReturn Sqr(sx.d(k)*sx.d(k)+sy.d(k)*sy.d(k)+sz.d(k)*sz.d(k))
EndProcedure ; RadiusBetrag
;
Procedure.d GeschwBetrag(k)
  ProcedureReturn Sqr(vx.d(k)*vx.d(k)+vy.d(k)*vy.d(k)+vz.d(k)*vz.d(k))
EndProcedure ; GeschwBetrag
;
Procedure DoppPar()
  tempb.d=Sin(#ecl)
  tempc.d=Cos(#ecl)
  temp.d=mstern1.d+mstern2.d
  tempa.d=-mstern2.d*dpp.d/temp.d
  ydpp1.d=tempa.d*tempc.d
  zdpp1.d=tempa.d*tempb.d
  tempa.d=mstern1.d*dpp.d/temp.d
  ydpp2.d=tempa.d*tempc.d
  zdpp2.d=tempa.d*tempb.d
  tempa.d=Sqr(gamma.d/(dpp.d*temp.d))
  vxdpp1.d=mstern2.d*tempa.d
  vxdpp2.d=-mstern1.d*tempa.d
EndProcedure ; DoppPar
;
Procedure.d WoffErde()
  ; Berechnung w-Offset fr Erdoberflche
  ProcedureReturn asp.d*spalten.d*radius.d(24)/(breite.d*#ae)+zeilen.d-115
EndProcedure ; WoffErde
;
Procedure.l UTC()
  ProcedureReturn Date()+tzbias+dlbias+biaskorr
EndProcedure ; UTC
;
Procedure.s Datum(typ)
  ; Zeitpunkt in s -> Datum + Uhrzeit (UTC oder lokal)
  If lokal
    If tzbias=#mezbias
      uhr$=" MEZ"
    Else
      uhr$=" UTC"+tzadd$
    EndIf
    tzl=tzbias
  Else
    uhr$=" UTC"
    tzl=0
  EndIf
  tzd.d=tzl
  Select typ
    Case 1
      templa=startzeit.d+zeit.d-tzd.d
      tst=zeit.d
      If (templa<0) Or (templa>2145916800) Or (templa=#fehll) Or (tst=#fehll)
        time$=Jahr(startzeit.d+zeit.d-tzd.d)
      Else
        templa=zeit.d
        If templa<0
          vz$="- "
          templa=-templa
        EndIf
        If templa>86400
          d$="Tag  "+vz$+Str(1+Int(templa/86400))+Space(5)
        EndIf
        time$=d$+vz$+FormatDate("%hh:%ii:%ss",templa)
        If Btst(23,QQQ)
          time$=StrDD(zeit.d,6)
        EndIf
      EndIf
    Case 2
      templa=startzeit.d+zeit.d-tzd.d
      If (templa<0) Or (templa>2145916800) Or (templa=#fehll)
        time$=Jahr(startzeit.d+zeit.d-tzd.d)
      Else
        If Btst(3,QQQ)
          time$=FormatDate("%dd.%mm.%yyyy - %hh"+uhr$,templa)
        Else
          time$=FormatDate("%dd.%mm.%yyyy - %hh:%ii"+uhr$,templa)
        EndIf
      EndIf
    Case 3
      time$=FormatDate("%dd.%mm.%yyyy - %hh:%ii UTC",startdateizeit)
    Case 4
      If (inidat$=neudat$) Or (startzeitvar=1)
        temp.d=startzeit.d-tzd.d
        templa=startzeit.d-tzl
      Else
        temp.d=startdateizeit-tzl
        templa=startdateizeit-tzl
      EndIf
      If (templa<0) Or (templa>2145916800) Or (templa=#fehll)
        time$=Jahr(temp.d)
      Else
        time$=FormatDate("%dd.%mm.%yyyy - %hh:%ii"+uhr$,templa)
      EndIf
    Case 5
      templa=datenzeit.d-tzd.d
      If (templa<0) Or (templa>2145916800) Or (templa=#fehll)
        time$=Jahr(datenzeit.d-tzd.d)
      Else
        time$=FormatDate("%dd.%mm.%yyyy - %hh:%ii"+uhr$,templa)
      EndIf
    Case 6
      templa=startzeit.d+zeit.d
      If (templa<0) Or (templa>2145916800) Or (templa=#fehll)
        time$=Jahr(startzeit.d+zeit.d)
      Else
        time$=FormatDate("%dd.%mm.%yyyy - %hh:%ii UTC",templa)
      EndIf
  EndSelect
  ProcedureReturn time$
EndProcedure ; Datum
;
Procedure.s Jahr(t.d)
  ; Zeitpunkt in s -> Jahreszahl
  If t.d>2145916800
    tempq.q=IntQ(2038+(t.d-2145916800)/#jahrsid)
  ElseIf t.d<0
    tempq.q=IntQ(1970+t.d/#jahrsid)
  EndIf
  ProcedureReturn StrQ(tempq.q)
EndProcedure ; Jahr
;
Procedure.l UU(x.d,y.d,z.d)
  ; Parallelprojektion Punkt (3-dim) -> Pixel (2-dim)
  proja.d=coa.d*x.d+sia.d*y.d
  ProcedureReturn Int(projx.d*proja.d+uoff.d)
EndProcedure ; UU
;
Procedure.l WW(x.d,y.d,z.d)
  ; Parallelprojektion Punkt (3-dim) -> Pixel (2-dim)
  projb.d=coacob.d*y.d+sib.d*z.d-siacob.d*x.d
  ProcedureReturn Int(woff.d-projy.d*projb.d)
EndProcedure ; WW
;
Procedure.l HH(x.d,y.d,z.d)
  ; Punkt (3-dim) -> "Abstand" von der Projektionsebene;
  ; muss nach UU und WW aufgerufen werden wegen proja.d und projb.d
  dqu1.d=x.d*x.d+y.d*y.d+z.d*z.d
  dqu2.d=MinD(proja.d*proja.d+projb.d*projb.d,dqu1.d)
  dqu.d=projx.d*Sqr(dqu1.d-dqu2.d) ; ~ Abstand von der Projektionsebene
  vrz.d=siasib.d*x.d-sibcoa.d*y.d+coa2cob.d*z.d+sia2cob.d*z.d ; Spatprodukt
  If vrz.d<0
    ProcedureReturn -Int(dqu.d)
  Else
    ProcedureReturn Int(dqu.d)
  EndIf
EndProcedure ; HH
;
Procedure.l UUR(u,w,uztr,wztr,ph.d)
  ; Rotation in der u-w-Ebene um den Winkel ph um den Erdmittelpunkt
  ProcedureReturn Int((u-uztr)*Cos(ph.d)+(w-wztr)*Sin(ph.d)/asp.d)+uztr ;  Rotationsmatrix
EndProcedure ; UUR
;
Procedure.l WWR(u,w,uztr,wztr,ph.d)
  ProcedureReturn Int(((w-wztr)*Cos(ph.d)/asp.d-(u-uztr)*Sin(ph.d))*asp.d)+wztr ; s.o.
EndProcedure ; WWR
;
Procedure.d Wert(a$)
  ; ValD mit Prfung des eingegebenen Terms
  a$=Trim(a$)
  If a$=""
    ProcedureReturn #fehld
  EndIf
  a0$=LCase(a$) ; E oder e verwendbar
  ll=Len(a0$)
  If Left(a0$,1)="-"
    a0$=Mid(a0$,2,ll-1)
    ll-1
    vorz.d=-1
  ElseIf Left(a0$,1)="+"
    a0$=Mid(a0$,2,ll-1)
    ll-1
    vorz.d=1
  Else
    vorz.d=1
  EndIf
  ; Test auf spezielle Gren:
  If Left(a0$,2)="er"
    If Mid(a0$,3,1)="+" ; er plus Zahl
      ll=ll-3
      a0$=Mid(a0$,4,ll) ; nur zus. Summand prfen
      erd.d=6378000
    Else
      a0$="6378000"
      ll=7
    EndIf
  ElseIf a0$="ae"
    a0$="149597870660"
    ll=12
  EndIf
  ;
  tit1$="Eingabefehler"
  tit2$="Eingabebegrenzung"
  txt$="Term "
  txt$+a$
  txt$+":    "
  txt$+Chr(13)
  ; Ziffern eingegeben?
  ziff=0
  If ll>0
    For i=1 To ll
      If (Asc(Mid(a0$,i,1))>47) And (Asc(Mid(a0$,i,1))<58)
        ziff=1
        Break
      EndIf
    Next i
  EndIf
  If (ziff=0) Or (ll=0)
    txt$+"Keine Ziffern eingegeben.    "
    MessageRequester(tit1$,txt$,#MB_ICONSTOP)
    ProcedureReturn #fehld
  EndIf
  ;
  acp=43  ; +
  acm=45  ; -
  acd=46  ; .
  ace=101 ; e
  ; Prfung auf unerlaubte Zeichen:
  For i=1 To ll
    ac=Asc(Mid(a0$,i,1))
    If (ac<48) Or (ac>57) ; keine Ziffer
      If (ac=acp) Or (ac=acm) Or (ac=acd) Or (ac=ace)
        If ac=acd ; nur ein . erlaubt
          acd=48
        EndIf
        If ac=ace ; nur ein e erlaubt
          ace=48
          acd=48 ; nach e kein . erlaubt
        EndIf
      Else
        txt$+"Unzulssige(s) Zeichen.    "
        MessageRequester(tit1$,txt$,#MB_ICONSTOP)
        ProcedureReturn #fehld
      EndIf
    EndIf
  Next i
  ; Zerlegung in Teilstrings:
  a1$=""
  a2$=""
  a3$=""
  p=FindString(a0$,".",1)
  e=FindString(a0$,"e",1)
  If e>0
    If p>0
      a1$=Left(a0$,p-1) ; Zeichen vor . (Ziffern, -)
      a2$=Mid(a0$,p+1,e-p-1) ; Zeichen nach . (Ziffern, e, -)
    Else
      a1$=Left(a0$,e-1) ; Zeichen vor e
    EndIf
    a3$=Mid(a0$,e+1,ll-e) ; Zeichen nach e (Ziffern, -)
  Else
    If p>0
      a1$=Left(a0$,p-1) ; Zeichen vor . (Ziffern, -)
      a2$=Mid(a0$,p+1,ll-p) ; Zeichen nach .
    Else
      a1$=a0$ ; nur Zeichen
    EndIf
  EndIf
  While Right(a2$,1)="0"
    a2$=Left(a2$,Len(a2$)-1)
  Wend
  ;
  If FindString(a1$,"+",2)>0 ; Prfung auf +
    txt$+"Pluszeichen an falscher Stelle.    "
    MessageRequester(tit1$,txt$,#MB_ICONSTOP)
    ProcedureReturn #fehld
  EndIf
  If FindString(a1$,"-",1)>0 ; Prfung auf -
    txt$+"Minuszeichen an falscher Stelle.    "
    MessageRequester(tit1$,txt$,#MB_ICONSTOP)
    ProcedureReturn #fehld
  EndIf
  If a1$=""
    a1$="0"
  EndIf
  If Len(a1$)+Len(a2$)>50 ; Prfung Stellenzahl
    txt$+"Anzahl der Ziffern zu hoch.    "
    MessageRequester(tit2$,txt$,#MB_ICONSTOP)
    ProcedureReturn #fehld
  EndIf
  If a2$<>""
    If FindString(a2$,"+",1)>0
      txt$+"Pluszeichen nach dem Dezimalpunkt.    "
      MessageRequester(tit1$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
    If FindString(a2$,"-",1)>0
      txt$+"Minuszeichen nach dem Dezimalpunkt.    "
      MessageRequester(tit1$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
  EndIf
  If a3$<>""
    If FindString(a3$,"+",2)>0
      txt$+"Pluszeichen an falscher Stelle im Exponenten.    "
      MessageRequester(tit1$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
    If FindString(a3$,"-",2)>0
      txt$+"Minuszeichen an falscher Stelle im Exponenten.    "
      MessageRequester(tit1$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
    If (Val(a3$)<-18) Or (Val(a3$)>50)
      txt$+"Nur Exponenten von -18 bis 50 sind zulssig.    "
      MessageRequester(tit2$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
    If (p>0) And (Len(a1$)>1)
      txt$+"Bei der Exponentialdarstellung ist nur eine Ziffer vor dem Dezimalpunkt zulssig.   "
      MessageRequester(tit1$,txt$,#MB_ICONSTOP)
      ProcedureReturn #fehld
    EndIf
  EndIf
  ; Rckgabe:
  x.d=vorz.d*ValD(a0$)
  If erd.d>0
    x.d=erd.d+x.d
  EndIf
  ProcedureReturn x.d
EndProcedure ; Wert
;
Procedure.s StrDD(x.d,s)
  d$=StrD(x.d,s)
  If ValD(d$)=0 And Left(d$,1)="-" ; "-0"
    d$=Mid(d$,2)
  EndIf
  ProcedureReturn d$
EndProcedure ; StrDD
;
Procedure.s StrE(x.d,st)
  If Abs(x.d)<1e-100
    ProcedureReturn "0"
  EndIf
  If st=-1
    stl=stellen
    stlexp=stellenexp
  ElseIf st=-2
    stl=MinL(stellen,10)
    stlexp=MinL(stellenexp,10)
  Else
    stl=st
    stlexp=st
  EndIf
  If (Abs(x.d)>=0.000001) And (Abs(x.d)<=1000000)
    a$=StrDD(x.d,stl)
    If a$="-0"
      a$="0"
    EndIf
    ProcedureReturn a$
  EndIf
  If x.d<0
    x.d=Abs(x.d)
    v$="-"
  EndIf
  d=100
  a$=StrDD(x.d,d)
  p=FindString(a$,".",1)
  a1$=Left(a$,p-1)
  a2$=Right(a$,d)
  l1=Len(a1$)
  If a1$="0"
    e=1
    While Left(a2$,1)="0"
      a2$=Right(a2$,d-e)
      e+1
    Wend
    a3$=Left(a2$,1)
    l2=Len(a2$)
    a4$=Right(a2$,l2-1)
    e=-e
  Else
    a3$=Left(a1$,1)
    e=l1-1
    a4$=Right(a1$,e)+a2$
  EndIf
  a5$=Left(a4$,stlexp)
  If a5$<>""
    p$="."
  EndIf
  a$=v$+a3$+p$+a5$+"e"+Str(e)
  If a$="-0"
    a$="0"
  EndIf
  ProcedureReturn a$
EndProcedure ; StrE
;
Procedure.l MaxL(x.l,y.l)
  If x.l>y.l
    ProcedureReturn x.l
  Else
    ProcedureReturn y.l
  EndIf
EndProcedure  ; MaxL
;
Procedure.d MaxD(x.d,y.d)
  If x.d>y.d
    ProcedureReturn x.d
  Else
    ProcedureReturn y.d
  EndIf
EndProcedure ; MaxD
;
Procedure.l MinL(x.l,y.l)
  If x.l<y.l
    ProcedureReturn x.l
  Else
    ProcedureReturn y.l
  EndIf
EndProcedure ; MinL
;
Procedure.d MinD(x.d,y.d)
  If x.d<y.d
    ProcedureReturn x.d
  Else
    ProcedureReturn y.d
  EndIf
EndProcedure ; MinD
;
Procedure Status()
  txt1$="0987654321098765432109876543210     "
  txt2$=Right(Bin(QQQ+2147483648),31)
  txt3$=Right(Bin(KKK+2147483648),31)
  txt$=txt1$+Chr(13)+txt2$+Chr(13)+txt3$
  MessageRequester("Status",txt$,#MB_ICONINFORMATION)
EndProcedure ; Status
;
;-####################################### Programmende #####################################
